/*
 * Decompiled with CFR 0.152.
 */
package lia.gsi;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import lia.gsi.net.GSIBaseServer;
import lia.gsi.net.Peer;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.jaas.UserNamePrincipal;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GSIServer
extends GSIBaseServer {
    protected static final int PORT = 54320;
    private static Logger logger = Logger.getLogger(GSIServer.class.getName());

    public GSIServer(int port) throws Exception {
        this(null, null, port);
    }

    public GSIServer() throws Exception {
        this(null, null, 54320);
    }

    public GSIServer(GSSCredential cred, int port) throws Exception {
        super(cred, port);
    }

    public GSIServer(String serverKey, String serverCert, int port) throws Exception {
        super(GSIServer.generateGSSCredential(serverKey, serverCert), port);
    }

    public static GSSCredential generateGSSCredential(String serverKey, String serverCert) throws GlobusCredentialException, CredentialException, IOException, GSSException {
        X509Credential credentials;
        if (serverKey == null && serverCert == null) {
            serverKey = System.getProperty("X509_SERVICE_KEY");
            serverCert = System.getProperty("X509_SERVICE_CERT");
        }
        if (serverKey == null && serverCert == null) {
            serverKey = System.getenv("X509_HOST_KEY");
            serverCert = System.getenv("X509_HOST_CERT");
        }
        if (serverKey == null && serverCert == null) {
            serverKey = "/etc/grid-security/hostkey.pem";
            serverCert = "/etc/grid-security/hostcert.pem";
            File certFile = new File(serverCert);
            File keyFile = new File(serverKey);
            if (!certFile.exists()) {
                serverCert = null;
            }
            if (!keyFile.exists()) {
                serverKey = null;
            }
        }
        if (serverKey == null && serverCert == null) {
            credentials = X509Credential.getDefaultCredential();
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Using user proxy certificate:" + credentials.getSubject());
            }
        } else if (serverKey != null && serverCert != null) {
            credentials = new X509Credential(serverCert, serverKey);
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Using host certificate:" + credentials.getSubject());
            }
        } else {
            throw new IOException("Error: Service credentials could not be loaded.");
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "credentials:" + credentials);
        }
        return new GlobusGSSCredentialImpl(credentials, 2);
    }

    public static void main(String[] args) throws Exception {
        GSIServer ctrlServer = new GSIServer();
        ctrlServer.start();
        System.out.println("Started");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setGssMode(GSIConstants.MODE_GSI);
    }

    @Override
    protected void handleConnection(Peer peer) {
        Socket socket = peer.getSocket();
        Subject peerSubject = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.info("Client connected: " + socket.getInetAddress() + ":" + socket.getPort());
        }
        try {
            socket.getOutputStream();
            socket.getInputStream();
            peerSubject = peer.getPeerSubject();
        }
        catch (Throwable t) {
            logger.log(Level.INFO, "Authentication failed:", t);
            if (socket != null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Client disconnected");
                }
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
        this.handleConversation(this, socket, peerSubject);
    }

    protected void handleConversation(GSIServer parent, Socket client, Subject peerSubject) {
        logger.info("Client connected :" + client + "\n" + peerSubject);
        if (peerSubject != null) {
            UserNamePrincipal up = (UserNamePrincipal)peerSubject.getPrincipals(UserNamePrincipal.class).toArray()[0];
            System.out.println("LocalID:" + up.getName());
        }
        try {
            PrintWriter pw = new PrintWriter(client.getOutputStream());
            pw.println("HELLO From GSI Server. Your order please!");
            pw.flush();
            System.out.println("Sent");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getContact() {
        String gid = null;
        try {
            gid = this.getCredentials().getName().toString();
        }
        catch (GSSException e) {
            return null;
        }
        StringBuffer url = new StringBuffer();
        url.append(this.getHost()).append(":").append(String.valueOf(this.getPort())).append(":").append(gid);
        return url.toString();
    }
}

