/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.FDTCloseable;

public abstract class AbstractFDTCloseable
implements FDTCloseable {
    private static final Logger logger = Logger.getLogger(AbstractFDTCloseable.class.getName());
    private static final AsynchronousCloseThread closer;
    protected final Object closeLock = new Object();
    protected volatile boolean closed = false;
    private volatile String downMessage;
    private volatile Throwable downCause;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(String downMessage, Throwable downCause) {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.isClosed()) {
                this.setClosed(true);
                this.downMessage = downMessage;
                this.downCause = downCause;
                AbstractFDTCloseable.closer.workingQueue.add(this);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public String downMessage() {
        return this.downMessage;
    }

    public Throwable downCause() {
        return this.downCause;
    }

    protected abstract void internalClose() throws Exception;

    static {
        AsynchronousCloseThread tmp = null;
        try {
            tmp = new AsynchronousCloseThread();
            tmp.start();
        }
        catch (Throwable t) {
            System.err.println("\n\n Cannot instantiate AsynchronousCloseThread !! \n\n");
            t.printStackTrace();
            throw new RuntimeException("Cannot instantiate AsynchronousCloseThread", t);
        }
        closer = tmp;
    }

    private static final class AsynchronousCloseThread
    extends Thread {
        BlockingQueue<AbstractFDTCloseable> workingQueue = new LinkedBlockingQueue<AbstractFDTCloseable>();

        private AsynchronousCloseThread() {
            this.setDaemon(true);
            this.setName(" AsyncCloseThread [ " + this.workingQueue.size() + " ]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            AbstractFDTCloseable closeable = null;
            while (true) {
                try {
                    while (true) {
                        this.setName(" AsyncCloseThread waiting to take wqSize: " + this.workingQueue.size());
                        closeable = null;
                        closeable = this.workingQueue.take();
                        this.setName(" AsyncCloseThread CLOSING [ " + closeable + " ] wqSize: " + this.workingQueue.size());
                        Object object = closeable.closeLock;
                        synchronized (object) {
                            closeable.internalClose();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    logger.log(Level.WARNING, "[ AsynchronousCloseThread ] [ HANDLED ] Got InterruptedException on task [ " + closeable + " ] Exc:", ie);
                    Thread.interrupted();
                    continue;
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "[ AsynchronousCloseThread ] [ HANDLED ] Got generic exception on task [ " + closeable + " ] Exc:", t);
                    continue;
                }
                break;
            }
        }
    }
}

