/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import lia.util.net.common.Utils;

public class NetloggerRecord {
    private int block;
    private int buffer;
    private String code = "429";
    private Date completed = new Date();
    private InetAddress destination = Utils.getLoopbackAddress();
    private InetAddress host = Utils.getLoopbackAddress();
    private long nbytes;
    private Date start = this.completed;
    private int streams;
    private String type = "RETR";

    public static String toULMDate(Date date) {
        SimpleDateFormat ulmFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        String ulmDate = ulmFormat.format(date) + "000";
        return ulmDate;
    }

    public int getBuffer() {
        return this.buffer;
    }

    public void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public int getBlock() {
        return this.block;
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Date getCompleted() {
        return this.completed;
    }

    public void setCompleted(Date completed) {
        this.completed = completed;
    }

    public InetAddress getDestination() {
        return this.destination;
    }

    public void setDestination(InetAddress destination) {
        this.destination = destination;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public void setHost(InetAddress host) {
        this.host = host;
    }

    public long getNbytes() {
        return this.nbytes;
    }

    public void setNbytes(long nbytes) {
        this.nbytes = nbytes;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public int getStreams() {
        return this.streams;
    }

    public void setStreams(int streams) {
        this.streams = streams;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toULMString() {
        String ulm = Utils.joinString(" ", "DATE=" + NetloggerRecord.toULMDate(this.completed), "HOST=" + this.host.getHostName(), "PROG=fdt", "START=" + NetloggerRecord.toULMDate(this.start), "BUFFER=" + this.buffer, "BLOCK=" + this.block, "NBYTES=" + this.nbytes, "STREAMS=" + this.streams, "DEST=[" + this.destination.getHostAddress() + "]", "TYPE=" + this.type, "CODE=" + this.code);
        return ulm;
    }

    public String toString() {
        return this.toULMString();
    }
}

