/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.disk;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FDTSessionManager;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.FileSession;
import lia.util.net.copy.IOSession;
import lia.util.net.copy.disk.DiskWriterManager;
import lia.util.net.copy.disk.GenericDiskTask;

public class DiskWriterTask
extends GenericDiskTask {
    private static final Logger logger = Logger.getLogger(DiskWriterTask.class.getName());
    private static final DiskWriterManager dwm = DiskWriterManager.getInstance();
    private static final FDTSessionManager fsm = FDTSessionManager.getInstance();
    final BlockingQueue<FileBlock> queue;
    private final Lock countersRLock;
    private final Lock countersWLock;
    private final AtomicBoolean hasToRun;
    private final boolean doNotForceOnClose;
    public long dtTake;
    public long dtWrite;
    public long dtFinishSession;
    public long dtTotal;
    long sTime;
    long sTimeWrite;
    long sTimeFinish;
    long finishTime;

    DiskWriterTask(int partitionID, int writerID, BlockingQueue<FileBlock> queue) {
        super(partitionID, writerID);
        this.queue = queue;
        this.hasToRun = new AtomicBoolean(true);
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.countersRLock = rwl.readLock();
        this.countersWLock = rwl.writeLock();
        boolean hasP = System.getProperty("fdt.doNotForceOnClose") != null;
        this.doNotForceOnClose = hasP ? Boolean.getBoolean("fdt.doNotForceOnClose") : true;
    }

    public void stopIt() {
        if (this.hasToRun.compareAndSet(true, false)) {
            logger.log(Level.INFO, this.myName + " STOPPED!");
        }
    }

    public final Lock getCountersRLock() {
        return this.countersRLock;
    }

    public int partitionID() {
        return this.partitionID;
    }

    public BlockingQueue<FileBlock> queue() {
        return this.queue;
    }

    public final int writerID() {
        return this.taskID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String cName = Thread.currentThread().getName();
        this.myName = "DiskWriterTask [ partitionID=" + this.partitionID + ", writerID= " + this.taskID + ", tid=" + Thread.currentThread().getId() + " ] since: " + new Date();
        try {
            Thread.currentThread().setName(this.myName);
        }
        catch (Throwable t1) {
            logger.log(Level.SEVERE, "Got exception trying to set thread name for DiskWriterTask", t1);
        }
        int writtenBytes = -1;
        BlockingQueue<FileBlock> queue = this.queue;
        logger.log(Level.INFO, this.myName + " STARTED. Active = " + this.hasToRun.get());
        while (this.hasToRun.get()) {
            FileBlock fileBlock = null;
            FileChannel fileChannel = null;
            IOSession fileSession = null;
            FDTSession fdtSession = null;
            try {
                this.sTime = System.nanoTime();
                this.sTimeFinish = 0L;
                fileBlock = queue.poll(10L, TimeUnit.SECONDS);
                if (fileBlock == null || fileBlock.buff == null) {
                    if (!this.hasToRun.get()) break;
                    continue;
                }
                fdtSession = fsm.getSession(fileBlock.fdtSessionID);
                if (fdtSession == null) {
                    logger.log(Level.WARNING, this.myName + " Got a fileBlock for fdtSessionID: " + fileBlock.fdtSessionID + " but the session does not appear to be in the manager's map");
                    continue;
                }
                fileSession = fdtSession.getFileSession(fileBlock.fileSessionID);
                if (fileSession == null) {
                    logger.log(Level.WARNING, " No such fileSession in local map [ fileSessionID: " + fileBlock.fileSessionID + ", fdtSessionID: " + fileBlock.fdtSessionID + " ]");
                    continue;
                }
                this.sTimeWrite = System.nanoTime();
                fileChannel = ((FileSession)fileSession).getChannel();
                if (fileChannel != null) {
                    writtenBytes = -1;
                    int remainingBeforeWrite = fileBlock.buff.remaining();
                    writtenBytes = !((FileSession)fileSession).isLoop() ? fileChannel.write(fileBlock.buff, fileBlock.fileOffset) : fileChannel.write(fileBlock.buff);
                    if (fileBlock.buff.hasRemaining()) {
                        File fp;
                        File f = ((FileSession)fileSession).getFile();
                        long freeSpace = -1L;
                        long totalSpace = -1L;
                        long usableSpace = -1L;
                        File file = fp = f != null && f.exists() ? f : f.getParentFile();
                        if (fp != null) {
                            freeSpace = fp.getFreeSpace();
                            totalSpace = fp.getTotalSpace();
                            usableSpace = fp.getUsableSpace();
                        }
                        String ratio = "";
                        boolean isFull = false;
                        if (totalSpace > 0L) {
                            double freeSpaceRatio = freeSpace / totalSpace;
                            double usableSpaceRatio = usableSpace / totalSpace;
                            ratio = ratio + "freeSpaceRatio: " + Utils.percentDecimalFormat(freeSpaceRatio) + "% usableSpaceRatio: " + Utils.percentDecimalFormat(usableSpaceRatio) + "%";
                            if (freeSpace < (long)fileBlock.buff.capacity() || usableSpace < (long)fileBlock.buff.capacity() || freeSpaceRatio < 5.0 || usableSpaceRatio < 5.0) {
                                isFull = true;
                                ratio = ratio + "\n\n Not enough space to write the buffers on current partition!";
                            }
                        } else {
                            ratio = ratio + " totalSpace: " + totalSpace + " <= 0 BYTES; free/usable ratio cannot be computed !";
                        }
                        String cause = "";
                        cause = !isFull ? "\n\n\n [ ERROR ] " + this.myName + " buffer still hasRemaining() for file: " + f + "\n\n The disk partition may be full or there is a BUG in FileSystem/Kernel/OS/Java NIO !! \n\n\n Disk partition statistics for " + fp + ":\n\n Total free/usable/total space: " + freeSpace + " / " + usableSpace + " / " + totalSpace + " bytes\n " + ratio + "\n\n\n Please note that the partial file will be deleted and space may be available after the session finishes! \n\n\n fileblock offset = " + fileBlock.fileOffset + "\n buff.remaining() before write: " + remainingBeforeWrite + "\n buff.remaining() after write: " + fileBlock.buff.remaining() + "\n new position = " + fileChannel.position() + "\n written bytes = " + writtenBytes + "\n\n\n" : "\n\n\n [ ERROR ] " + this.myName + "\n The disk partition for: " + fp + " may be full \n\n Total free/usable/total space: " + freeSpace + " / " + usableSpace + " / " + totalSpace + " bytes\n " + ratio + "\n\n\n Please note that the partial file will be deleted and space may be available after the session finishes! \n\n";
                        fdtSession.close(cause, new IOException(cause));
                        continue;
                    }
                    if (writtenBytes == -1) {
                        this.sTimeFinish = System.nanoTime();
                        logger.log(Level.WARNING, "\n\n [ ERROR ] " + this.myName + " ... Unable to write bytes to [  ( " + fileSession.sessionID() + " ): " + ((FileSession)fileSession).fileName() + " ] Disk full or R/O partition ?");
                        IOException downCause = new IOException("Unable to write bytes ????  [ Full disk or R/O partition ]");
                        downCause.fillInStackTrace();
                        fsm.getSession(fileBlock.fdtSessionID).finishFileSession(fileSession.sessionID(), downCause);
                    } else {
                        ((FileSession)fileSession).cProcessedBytes.addAndGet(writtenBytes);
                        dwm.addAndGetTotalBytes(writtenBytes);
                        dwm.addAndGetUtilBytes(writtenBytes);
                        this.addAndGetTotalBytes(writtenBytes);
                        this.addAndGetUtilBytes(writtenBytes);
                        fdtSession.addAndGetTotalBytes(writtenBytes);
                        fdtSession.addAndGetUtilBytes(writtenBytes);
                    }
                    if (((FileSession)fileSession).cProcessedBytes.get() == fileSession.sessionSize()) {
                        if (!fdtSession.loop()) {
                            try {
                                if (!((FileSession)fileSession).isNull() && !((FileSession)fileSession).isZero()) {
                                    if (this.doNotForceOnClose) {
                                        if (logger.isLoggable(Level.FINER)) {
                                            logger.log(Level.FINER, "CLOSE - Not enforcing flush - " + ((FileSession)fileSession).getFile() + " closing without forcing the channel");
                                        }
                                    } else {
                                        ((FileSession)fileSession).getChannel().force(true);
                                    }
                                }
                            }
                            catch (Throwable t1) {
                                logger.log(Level.WARNING, this.myName + " got exception forcing data to  writer channel for file writer session " + fileSession, t1);
                            }
                            ((FileSession)fileSession).getChannel().close();
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "\n " + this.myName + " ... All the bytes ( " + fileSession.sessionSize() + " ) for [  ( " + fileSession.sessionID() + " ): " + ((FileSession)fileSession).fileName() + " ] have been written ");
                        }
                        if (!fdtSession.loop()) {
                            fdtSession.finishFileSession(fileSession.sessionID(), null);
                        }
                        fileSession.close(null, null);
                        this.sTimeFinish = System.nanoTime();
                    }
                } else {
                    NullPointerException downCause = new NullPointerException("Null File Channel inside disk writer worker [ " + this.myName + " ] for [  ( " + fileSession.sessionID() + " ): " + ((FileSession)fileSession).fileName() + " ]");
                    ((Throwable)downCause).fillInStackTrace();
                    this.sTimeFinish = System.nanoTime();
                    fsm.getSession(fileBlock.fdtSessionID).finishFileSession(fileSession.sessionID(), downCause);
                }
                this.finishTime = System.nanoTime();
                this.countersWLock.lock();
                try {
                    this.dtTotal += this.finishTime - this.sTime;
                    this.dtTake += this.sTimeWrite - this.sTime;
                    if (this.sTimeFinish != 0L) {
                        this.dtWrite += this.sTimeFinish - this.sTimeWrite;
                        this.dtFinishSession += this.finishTime - this.sTimeFinish;
                        continue;
                    }
                    this.dtWrite += this.finishTime - this.sTimeWrite;
                }
                finally {
                    this.countersWLock.unlock();
                }
            }
            catch (IOException ioe) {
                this.sTimeFinish = System.nanoTime();
                logger.log(Level.SEVERE, this.myName + " ... Got I/O Exception writing to file [  ( " + fileSession.sessionID() + " ): " + ((FileSession)fileSession).fileName() + " ] offset: " + fileBlock.fileOffset, ioe);
                if (fileSession.sessionID() == null) continue;
                fdtSession.finishFileSession(fileSession.sessionID(), ioe);
            }
            catch (InterruptedException ie) {
                if (fileSession == null) {
                    logger.log(Level.SEVERE, this.myName + " ... Got InterruptedException Exception writing to file [  ( fileSession is null ) ] offset: " + (fileBlock == null ? " fileBlock is null" : "" + fileBlock.fileOffset), ie);
                    continue;
                }
                logger.log(Level.SEVERE, this.myName + " ... Got InterruptedException Exception writing to file [  ( " + fileSession.sessionID() + " ): " + ((FileSession)fileSession).fileName() + " ] offset: " + (fileBlock == null ? " fileBlock is null" : "" + fileBlock.fileOffset), ie);
            }
            catch (Throwable t) {
                this.sTimeFinish = System.nanoTime();
                if (fileSession == null) {
                    logger.log(Level.SEVERE, this.myName + " ... Got GeneralException Exception writing to file [  ( fileSession is null ) ] offset: " + (fileBlock == null ? " fileBlock is null" : "" + fileBlock.fileOffset), t);
                } else {
                    logger.log(Level.SEVERE, this.myName + " ... Got GeneralException Exception writing to file [  ( " + fileSession.sessionID() + " ): " + ((FileSession)fileSession).fileName() + " ] offset: " + (fileBlock == null ? " fileBlock is null" : "" + fileBlock.fileOffset), t);
                }
                if (fdtSession == null || fileSession.sessionID() == null) continue;
                fdtSession.finishFileSession(fileSession.sessionID(), t);
            }
            finally {
                try {
                    if (fileBlock != null && fileBlock.buff != null) {
                        bufferPool.put(fileBlock.buff);
                    }
                    fileBlock = null;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, this.myName + " ... unable to return the buffer to the bufferPool", t);
                }
            }
        }
        try {
            Utils.drainFileBlockQueue(queue);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Possbile buff loss from the pool", t);
        }
        try {
            Thread.currentThread().setName(cName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stopIt();
        logger.log(Level.INFO, this.myName + " STOPPED! hasToRun() = " + this.hasToRun.get());
    }
}

