/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.filters.examples;

import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import lia.util.net.copy.FileSession;
import lia.util.net.copy.filters.Preprocessor;
import lia.util.net.copy.filters.ProcessorInfo;

public class FirewallFileNames
implements Preprocessor {
    @Override
    public void preProcessFileList(ProcessorInfo processorInfo, Subject peerSubject) throws Exception {
        Map<String, FileSession> fileSessionMap = processorInfo.fileSessionMap;
        String firewallPrefix = System.getProperty("FirewallFileNames.prefix");
        if (firewallPrefix == null || firewallPrefix.trim().isEmpty()) {
            System.out.println("[ FirewallFileNames ] No prefix defined");
            return;
        }
        String firewallPrefixTrim = firewallPrefix.trim();
        System.out.println(" [ FirewallFileNames ] firewall prefix pattern=" + firewallPrefixTrim);
        Iterator<Map.Entry<String, FileSession>> iterator = fileSessionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FileSession> entry = iterator.next();
            FileSession fileSession = entry.getValue();
            String fName = fileSession.fileName();
            System.out.println("[ FirewallFileNames ] fname = " + fName);
            if (!fName.startsWith(firewallPrefixTrim)) continue;
            System.out.println("FNAME firewalled: " + fName);
            iterator.remove();
        }
    }
}

