/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lia.util.net.copy.gui.EnhancedJPanel;
import lia.util.net.copy.gui.PreferencesHandler;

public class ConnectDialog
extends JDialog
implements KeyListener,
ItemListener {
    final JFrame parent;
    public String sHost = "localhost";
    public String sPort = "54321";
    public String sUser = System.getProperty("user.name");
    public boolean bDialogOK = false;
    private JTextField textHost = new JTextField();
    private JTextField textPort = new JTextField();
    private JTextField textUser = new JTextField();
    private JCheckBox useSSH = new JCheckBox("Connect using ssh");

    public ConnectDialog(JFrame f) {
        super(f, "Connection preferences", true);
        EnhancedJPanel mainPanel = new EnhancedJPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.parent = f;
        JPanel p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        mainPanel.add(p);
        p.add(new JLabel("Remote Hostname: "));
        try {
            this.sHost = PreferencesHandler.get("hostname", "localhost");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.textHost.setText(this.sHost);
        this.textHost.addKeyListener(this);
        p.add(this.textHost);
        boolean useSSH = true;
        try {
            useSSH = Boolean.valueOf(PreferencesHandler.get("useSSH", "true"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        mainPanel.add(p);
        p.add(new JLabel("Remote Username: "));
        try {
            this.sUser = PreferencesHandler.get("user", this.sUser);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.textUser.setText(this.sUser);
        this.textUser.addKeyListener(this);
        p.add(this.textUser);
        this.textUser.setEnabled(useSSH);
        p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        mainPanel.add(p);
        this.useSSH.setSelected(useSSH);
        this.useSSH.addItemListener(this);
        this.useSSH.setOpaque(false);
        p.add(this.useSSH);
        p.add(Box.createHorizontalGlue());
        p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new BoxLayout(p, 0));
        mainPanel.add(p);
        p.add(new JLabel("FDT Port Number: "));
        try {
            this.sPort = PreferencesHandler.get("port", "54321");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.textPort.setText(this.sPort);
        this.textPort.addKeyListener(this);
        p.add(this.textPort);
        p = new JPanel();
        p.setOpaque(false);
        p.setLayout(new GridLayout(0, 2));
        mainPanel.add(p);
        JButton bOK = new JButton("OK");
        bOK.addKeyListener(this);
        bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConnectDialog.this.sHost = ConnectDialog.this.textHost.getText();
                ConnectDialog.this.sPort = ConnectDialog.this.textPort.getText();
                ConnectDialog.this.sUser = ConnectDialog.this.textUser.isEnabled() ? ConnectDialog.this.textUser.getText() : null;
                if (ConnectDialog.this.sHost == null || ConnectDialog.this.sHost.length() == 0) {
                    JOptionPane.showMessageDialog(ConnectDialog.this.parent, "You must enter the hostname");
                    return;
                }
                if (ConnectDialog.this.textUser.isEnabled() && (ConnectDialog.this.sUser == null || ConnectDialog.this.sUser.length() == 0)) {
                    JOptionPane.showMessageDialog(ConnectDialog.this.parent, "You must enter a valid username");
                    return;
                }
                if (ConnectDialog.this.sPort == null || ConnectDialog.this.sPort.length() == 0) {
                    JOptionPane.showMessageDialog(ConnectDialog.this.parent, "You must enter a valid port number");
                    return;
                }
                try {
                    Integer.parseInt(ConnectDialog.this.sPort);
                }
                catch (Throwable t) {
                    JOptionPane.showMessageDialog(ConnectDialog.this.parent, "You must enter a valid port number");
                }
                PreferencesHandler.put("hostname", ConnectDialog.this.sHost);
                if (ConnectDialog.this.textUser.isEnabled()) {
                    PreferencesHandler.put("user", ConnectDialog.this.sUser);
                }
                PreferencesHandler.put("port", ConnectDialog.this.sPort);
                PreferencesHandler.save();
                ConnectDialog.this.bDialogOK = true;
                ConnectDialog.this.setVisible(false);
            }
        });
        p.add(bOK);
        JButton bCancel = new JButton("Cancel");
        bCancel.addKeyListener(this);
        bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConnectDialog.this.bDialogOK = false;
                ConnectDialog.this.setVisible(false);
            }
        });
        p.add(bCancel);
        this.getContentPane().setLayout(new BorderLayout(2, 2));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.setSize(330, 330);
        this.setLocationRelativeTo(this.parent);
        this.pack();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2) {
            this.textUser.setEnabled(false);
            PreferencesHandler.put("useSSH", "false");
            PreferencesHandler.save();
        } else {
            this.textUser.setEnabled(true);
            PreferencesHandler.put("useSSH", "true");
            PreferencesHandler.save();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.bDialogOK = false;
            this.setVisible(false);
            return;
        }
        if (e.getKeyCode() == 10) {
            this.sHost = this.textHost.getText();
            this.sPort = this.textPort.getText();
            this.sUser = this.textUser.isEnabled() ? this.textUser.getText() : null;
            if (this.sHost == null || this.sHost.length() == 0) {
                JOptionPane.showMessageDialog(this.parent, "You must enter the hostname");
                return;
            }
            if (this.textUser.isEnabled() && (this.sUser == null || this.sUser.length() == 0)) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid username");
                return;
            }
            if (this.sPort == null || this.sPort.length() == 0) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid port number");
                return;
            }
            try {
                Integer.parseInt(this.sPort);
            }
            catch (Throwable t) {
                JOptionPane.showMessageDialog(this.parent, "You must enter a valid port number");
            }
            PreferencesHandler.put("hostname", this.sHost);
            if (this.textUser.isEnabled()) {
                PreferencesHandler.put("user", this.sUser);
            }
            PreferencesHandler.put("port", this.sPort);
            PreferencesHandler.save();
            this.bDialogOK = true;
            this.setVisible(false);
            return;
        }
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.setLocationRelativeTo(this.parent);
            this.toFront();
            this.pack();
        }
        super.setVisible(v);
    }
}

