/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.disk.DiskReaderManager;
import lia.util.net.copy.disk.DiskWriterManager;
import lia.util.net.copy.monitoring.FDTSessionMonitoringTask;
import lia.util.net.copy.transport.TCPTransportProvider;

public abstract class FDTReportingTask
implements Runnable {
    protected static final DiskReaderManager diskReaderManager = DiskReaderManager.getInstance();
    protected static final DiskWriterManager diskWriterManager = DiskWriterManager.getInstance();
    private static final Logger logger = Logger.getLogger("lia.util.net.copy.monitoring.FDTReportingTask");

    public abstract void finishFDTSession(FDTSession var1);

    public abstract void startFDTSession(FDTSession var1);

    public HashMap<String, HashMap<String, Double>> getReaderParams() {
        HashMap<String, HashMap<String, Double>> monitoringParams = new HashMap<String, HashMap<String, Double>>();
        FDTSession fdtSession = null;
        Iterator it = null;
        double rate = 0.0;
        Set fdtSessions = diskReaderManager.getSessions();
        it = fdtSessions.iterator();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "FDTReportingTask - ReaderSessions: " + fdtSessions);
        }
        while (it.hasNext()) {
            FDTSessionMonitoringTask fdtSessionMTask;
            fdtSession = (FDTSession)it.next();
            TCPTransportProvider transportProvider = fdtSession.getTransportProvider();
            HashMap<String, Double> fdtSessionParams = new HashMap<String, Double>();
            if (transportProvider != null && transportProvider.monitoringTask != null) {
                rate = transportProvider.monitoringTask.getTotalRate() * 8.0 / 1000000.0;
                fdtSessionParams.put("NET_OUT_Mb", rate);
            }
            if ((fdtSessionMTask = fdtSession.getMonitoringTask()) != null) {
                rate = fdtSessionMTask.getTotalRate() / 1048576.0;
                fdtSessionParams.put("DISK_READ_MB", rate);
                double tSize = fdtSession.getSize() <= 0L ? 0.0 : (double)fdtSession.getSize() / 1048576.0;
                double cSize = fdtSession.getTotalBytes() <= 0L ? 0.0 : (double)fdtSession.getTotalBytes() / 1048576.0;
                fdtSessionParams.put("TotalMBytes", tSize);
                fdtSessionParams.put("TransferredMBytes", cSize);
                if (fdtSession.getSize() > 0L) {
                    fdtSessionParams.put("TransferRatio", cSize * 100.0 / tSize);
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No FDTSessionMonitoringTask started for fdtSession: " + fdtSession);
            }
            String monID = fdtSession.getMonID();
            if (monID != null) {
                monitoringParams.put(monID, fdtSessionParams);
                continue;
            }
            monitoringParams.put(fdtSession.getRemoteAddress().getHostAddress() + ":" + fdtSession.getRemotePort(), fdtSessionParams);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "FDTReportingTask - returning ReaderParams: " + monitoringParams);
        }
        return monitoringParams;
    }

    public HashMap<String, HashMap<String, Double>> getWriterParams() {
        HashMap<String, HashMap<String, Double>> monitoringParams = new HashMap<String, HashMap<String, Double>>();
        FDTSession fdtSession = null;
        Iterator it = null;
        it = diskWriterManager.getSessions().iterator();
        double rate = 0.0;
        while (it.hasNext()) {
            FDTSessionMonitoringTask fdtSessionMTask;
            fdtSession = (FDTSession)it.next();
            TCPTransportProvider transportProvider = fdtSession.getTransportProvider();
            HashMap<String, Double> fdtSessionParams = new HashMap<String, Double>();
            if (transportProvider != null && transportProvider.monitoringTask != null) {
                rate = transportProvider.monitoringTask.getTotalRate() * 8.0 / 1000000.0;
                fdtSessionParams.put("NET_IN_Mb", rate);
            }
            if ((fdtSessionMTask = fdtSession.getMonitoringTask()) != null) {
                rate = fdtSessionMTask.getTotalRate() / 1048576.0;
                fdtSessionParams.put("DISK_WRITE_MB", rate);
                double tSize = fdtSession.getSize() <= 0L ? 0.0 : (double)fdtSession.getSize() / 1048576.0;
                double cSize = fdtSession.getTotalBytes() <= 0L ? 0.0 : (double)fdtSession.getTotalBytes() / 1048576.0;
                fdtSessionParams.put("TotalMBytes", tSize);
                fdtSessionParams.put("TransferredMBytes", cSize);
                if (fdtSession.getSize() > 0L) {
                    fdtSessionParams.put("TransferRatio", cSize * 100.0 / tSize);
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "No FDTSessionMonitoringTask started for fdtSession: " + fdtSession);
            }
            String monID = fdtSession.getMonID();
            if (monID != null) {
                monitoringParams.put(monID, fdtSessionParams);
                continue;
            }
            monitoringParams.put(fdtSession.getRemoteAddress().getHostAddress() + ":" + fdtSession.getRemotePort(), fdtSessionParams);
        }
        return monitoringParams;
    }
}

