/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.monitoring.lisa;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class cmdExec {
    public static CommandResult NullCommandResult = new CommandResult(null, true);
    private static cmdExec _instance = null;
    public final transient Logger logger = Logger.getLogger("monalisa.util.cmdExec");
    public String full_cmd;
    public Process pro;
    protected LinkedList streams = null;
    protected LinkedList streamsReal = null;
    protected boolean stopStreams = false;
    protected boolean stopStreamsReal = false;
    String osname = System.getProperty("os.name");
    String exehome = System.getProperty("user.home");

    private cmdExec() {
        this.streams = new LinkedList();
        this.streamsReal = new LinkedList();
    }

    public static synchronized cmdExec getInstance() {
        if (_instance == null) {
            _instance = new cmdExec();
        }
        return _instance;
    }

    public void setCmd(String cmd) {
        this.osname = System.getProperty("os.name");
        this.full_cmd = cmd;
    }

    public BufferedReader procOutput(String cmd) {
        try {
            if (this.osname.startsWith("Linux") || this.osname.startsWith("Mac")) {
                this.pro = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd});
            } else if (this.osname.startsWith("Windows")) {
                this.pro = Runtime.getRuntime().exec(this.exehome + cmd);
            }
            InputStream out = this.pro.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(out));
            BufferedReader err = new BufferedReader(new InputStreamReader(this.pro.getErrorStream()));
            String buffer = "";
            String ret = "";
            while ((buffer = err.readLine()) != null) {
                ret = ret + buffer + "\n'";
            }
            if (ret.length() != 0) {
                return null;
            }
            return br;
        }
        catch (Exception e) {
            this.logger.warning("FAILED to execute cmd = " + this.exehome + cmd);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public BufferedReader exeHomeOutput(String cmd) {
        try {
            this.pro = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", this.exehome + cmd});
            InputStream out = this.pro.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(out));
            BufferedReader err = new BufferedReader(new InputStreamReader(this.pro.getErrorStream()));
            String buffer = "";
            String ret = "";
            while ((buffer = err.readLine()) != null) {
                ret = ret + buffer + "\n'";
            }
            if (ret.length() != 0) {
                return null;
            }
            return br;
        }
        catch (Exception e) {
            this.logger.warning("FAILED to execute cmd = " + this.exehome + cmd);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void stopModule() {
        if (this.pro != null) {
            this.pro.destroy();
        }
    }

    public BufferedReader readProc(String filePath) {
        try {
            return new BufferedReader(new FileReader(filePath));
        }
        catch (Exception e) {
            return null;
        }
    }

    public CommandResult executeCommand(String command, String expect) {
        return this.executeCommand(command, expect, 60000);
    }

    public CommandResult executeCommand(String command, String expect, long timeout) {
        StreamGobbler output = null;
        StreamGobbler error = null;
        boolean isError = false;
        try {
            String osName = System.getProperty("os.name");
            Process proc = null;
            if (osName.indexOf("Win") != -1) {
                proc = Runtime.getRuntime().exec(command);
            } else if (osName.indexOf("Linux") != -1 || osName.indexOf("Mac") != -1) {
                String[] cmd = new String[]{"/bin/sh", "-c", command};
                proc = Runtime.getRuntime().exec(cmd);
            } else {
                isError = true;
                return null;
            }
            error = this.getStreamGobbler();
            output = this.getStreamGobbler();
            error.setInputStream(proc.getErrorStream());
            output.setInputStream(proc.getInputStream());
            String out = "";
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    out = error.getOutput();
                    if (out != null && out.length() != 0 && proc.exitValue() != 0) {
                        isError = true;
                        break;
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                if (expect != null && (out = output.getOutput()) != null && out.length() != 0 && out.indexOf(expect) != -1) {
                    isError = false;
                    break;
                }
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > timeout) {
                    isError = true;
                    break;
                }
                Thread.sleep(100L);
            }
            proc.destroy();
            proc.waitFor();
            if (out.length() == 0 || proc.exitValue() == 0) {
                out = output.getOutput();
            }
            error.stopIt();
            output.stopIt();
            this.addStreamGobbler(error);
            this.addStreamGobbler(output);
            error = null;
            output = null;
            return new CommandResult(out, isError);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (error != null) {
                this.addStreamGobbler(error);
                error.stopIt();
                error = null;
            }
            if (output != null) {
                this.addStreamGobbler(output);
                output.stopIt();
                output = null;
            }
            isError = true;
            return new CommandResult("", true);
        }
    }

    public CommandResult executeCommand(String command, Pattern expect) {
        return this.executeCommand(command, expect, 60000L);
    }

    public CommandResult executeCommand(String command, Pattern expect, long timeout) {
        StreamGobbler output = null;
        StreamGobbler error = null;
        boolean isError = false;
        try {
            String osName = System.getProperty("os.name");
            Process proc = null;
            if (osName.indexOf("Win") != -1) {
                proc = Runtime.getRuntime().exec(command);
            } else if (osName.indexOf("Linux") != -1 || osName.indexOf("Mac") != -1) {
                String[] cmd = new String[]{"/bin/sh", "-c", command};
                proc = Runtime.getRuntime().exec(cmd);
            } else {
                isError = true;
                return null;
            }
            error = this.getStreamGobbler();
            output = this.getStreamGobbler();
            error.setInputStream(proc.getErrorStream());
            output.setInputStream(proc.getInputStream());
            String out = "";
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    out = error.getOutput();
                    if (out != null && out.length() != 0 && proc.exitValue() != 0) {
                        isError = true;
                        break;
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                if (expect != null && (out = output.getOutput()) != null && out.length() != 0 && expect.matcher(out).matches()) {
                    isError = false;
                    break;
                }
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > timeout) {
                    isError = true;
                    break;
                }
                Thread.sleep(100L);
            }
            proc.destroy();
            proc.waitFor();
            if (out.length() == 0 || proc.exitValue() == 0) {
                out = output.getOutput();
            }
            error.stopIt();
            output.stopIt();
            this.addStreamGobbler(error);
            this.addStreamGobbler(output);
            error = null;
            output = null;
            return new CommandResult(out, isError);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (error != null) {
                this.addStreamGobbler(error);
                error.stopIt();
                error = null;
            }
            if (output != null) {
                this.addStreamGobbler(output);
                output.stopIt();
                output = null;
            }
            return new CommandResult("", true);
        }
    }

    public CommandResult executeCommand(String command, String expect, int howManyTimes) {
        return this.executeCommand(command, expect, howManyTimes, 60000L);
    }

    public CommandResult executeCommand(String command, String expect, int howManyTimes, long timeout) {
        StreamGobbler output = null;
        StreamGobbler error = null;
        int nr = 0;
        boolean isError = false;
        try {
            String osName = System.getProperty("os.name");
            Process proc = null;
            if (osName.indexOf("Win") != -1) {
                proc = Runtime.getRuntime().exec(command);
            } else if (osName.indexOf("Linux") != -1 || osName.indexOf("Mac") != -1) {
                String[] cmd = new String[]{"/bin/sh", "-c", command};
                proc = Runtime.getRuntime().exec(cmd);
            } else {
                return NullCommandResult;
            }
            error = this.getStreamGobbler();
            output = this.getStreamGobbler();
            error.setInputStream(proc.getErrorStream());
            output.setInputStream(proc.getInputStream());
            String out = "";
            long startTime = System.currentTimeMillis();
            while (true) {
                try {
                    out = error.getOutput();
                    if (out != null && out.length() != 0 && proc.exitValue() != 0) {
                        isError = true;
                        break;
                    }
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                if (expect != null && (out = output.getOutput()) != null && out.length() != 0 && out.indexOf(expect) != -1 && (nr = this.getStringOccurences(out, expect)) >= howManyTimes) {
                    isError = false;
                    break;
                }
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > timeout) {
                    isError = true;
                    break;
                }
                Thread.sleep(100L);
            }
            proc.destroy();
            proc.waitFor();
            if (out.length() == 0 || proc.exitValue() == 0) {
                out = output.getOutput();
            }
            error.stopIt();
            output.stopIt();
            this.addStreamGobbler(error);
            this.addStreamGobbler(output);
            error = null;
            output = null;
            return new CommandResult(out, isError);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (error != null) {
                this.addStreamGobbler(error);
                error.stopIt();
                error = null;
            }
            if (output != null) {
                this.addStreamGobbler(output);
                output.stopIt();
                output = null;
            }
            return NullCommandResult;
        }
    }

    protected int getStringOccurences(String text, String token) {
        if (text.indexOf(token) < 0) {
            return 0;
        }
        int nr = 0;
        String str = text;
        while (str.indexOf(token) >= 0) {
            str = str.substring(str.indexOf(token) + token.length());
            ++nr;
        }
        return nr;
    }

    public CommandResult executeCommandReality(String command, String expect, String path) {
        return this.executeCommandReality(command, expect, 60000, path);
    }

    public CommandResult executeCommandReality(String command, String expect, long timeout, String path) {
        StreamRealGobbler error = null;
        StreamRealGobbler output = null;
        boolean isError = false;
        try {
            String osName = System.getProperty("os.name");
            Process proc = null;
            if (osName.indexOf("Win") != -1) {
                proc = Runtime.getRuntime().exec(command);
            } else if (osName.indexOf("Linux") != -1) {
                String[] cmd = new String[]{"/bin/sh", "-c", command};
                proc = path != null && path.length() != 0 ? Runtime.getRuntime().exec(cmd, new String[]{"PATH=" + path}) : Runtime.getRuntime().exec(cmd);
            } else {
                return NullCommandResult;
            }
            error = this.getStreamRealGobbler(timeout);
            output = this.getStreamRealGobbler(timeout);
            error.setInputStream(proc.getErrorStream());
            output.setInputStream(proc.getInputStream());
            String out = "";
            long startTime = System.currentTimeMillis();
            boolean timeoutOccured = false;
            while (true) {
                try {
                    out = error.forceAllOutput();
                    if (proc.exitValue() == 0) break;
                    isError = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (expect != null && (out = output.forceAllOutput()) != null && out.length() != 0 && out.indexOf(expect) != -1) {
                        isError = false;
                        proc.destroy();
                        break;
                    }
                    long endTime = System.currentTimeMillis();
                    if (endTime - startTime > timeout) {
                        isError = true;
                        timeoutOccured = true;
                        proc.destroy();
                        break;
                    }
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
            if (!timeoutOccured) {
                proc.waitFor();
            } else {
                try {
                    Thread.sleep(2000L);
                    proc.getOutputStream().close();
                    proc.getInputStream().close();
                    proc.getErrorStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (out != null && out.length() == 0 || proc.exitValue() == 0) {
                out = output.forceAllOutput();
            }
            if (timeoutOccured) {
                out = out + "...Timeout";
            }
            error.stopIt();
            output.stopIt();
            this.addStreamRealGobbler(error);
            this.addStreamRealGobbler(output);
            error = null;
            output = null;
            return new CommandResult(out, isError);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (error != null) {
                this.addStreamRealGobbler(error);
                error.stopIt();
                error = null;
            }
            if (output != null) {
                this.addStreamRealGobbler(output);
                output.stopIt();
                output = null;
            }
            return NullCommandResult;
        }
    }

    public void executeCommandRealityForFinish(String command, String path) {
        this.executeCommandRealityForFinish(command, false, path);
    }

    public void executeCommandRealityForFinish(String command, boolean showOutput, String path) {
        this.executeCommandRealityForFinish(command, showOutput, 3600000L, path);
    }

    public boolean executeCommandRealityForFinish(String command, boolean showOutput, long timeout, String path) {
        boolean isError;
        block17: {
            StreamRealGobbler error = null;
            StreamRealGobbler output = null;
            isError = false;
            try {
                String osName = System.getProperty("os.name");
                Process proc = null;
                if (osName.indexOf("Win") != -1) {
                    proc = Runtime.getRuntime().exec(command);
                } else if (osName.indexOf("Linux") != -1) {
                    String[] cmd = new String[]{"/bin/sh", "-c", command};
                    proc = path != null && path.length() != 0 ? Runtime.getRuntime().exec(cmd, new String[]{"PATH=" + path}) : Runtime.getRuntime().exec(cmd);
                } else {
                    return true;
                }
                if (showOutput) {
                    error = this.getStreamRealGobbler(timeout);
                    output = this.getStreamRealGobbler(timeout);
                    error.setProgress(true);
                    output.setProgress(true);
                    error.setInputStream(proc.getErrorStream());
                    output.setInputStream(proc.getInputStream());
                    error.setProgress(false);
                    output.setProgress(false);
                }
                long startTime = System.currentTimeMillis();
                boolean timeoutOccured = false;
                while (true) {
                    try {
                        if (proc.exitValue() == 0) break;
                        isError = true;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        long endTime = System.currentTimeMillis();
                        if (endTime - startTime > timeout) {
                            isError = true;
                            timeoutOccured = true;
                            proc.destroy();
                            break;
                        }
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
                if (!timeoutOccured) {
                    proc.waitFor();
                } else {
                    try {
                        Thread.sleep(2000L);
                        proc.getOutputStream().close();
                        proc.getInputStream().close();
                        proc.getErrorStream().close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (showOutput) {
                    error.setProgress(false);
                    output.setProgress(false);
                    error.stopIt();
                    output.stopIt();
                    this.addStreamRealGobbler(error);
                    this.addStreamRealGobbler(output);
                    error = null;
                    output = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                isError = true;
                if (error != null) {
                    this.addStreamRealGobbler(error);
                    error.stopIt();
                    error = null;
                }
                if (output == null) break block17;
                this.addStreamRealGobbler(output);
                output.stopIt();
                output = null;
            }
        }
        return isError;
    }

    public CommandResult executeCommandReality(String command, String expect, int howManyTimes, String path) {
        return this.executeCommandReality(command, expect, howManyTimes, 60000L, path);
    }

    public CommandResult executeCommandReality(String command, String expect, int howManyTimes, long timeout, String path) {
        StreamRealGobbler error = null;
        StreamRealGobbler output = null;
        boolean isError = false;
        try {
            String osName = System.getProperty("os.name");
            Process proc = null;
            if (osName.indexOf("Win") != -1) {
                proc = Runtime.getRuntime().exec(command);
            } else if (osName.indexOf("Linux") != -1) {
                String[] cmd = new String[]{"/bin/sh", "-c", command};
                proc = path != null && path.length() != 0 ? Runtime.getRuntime().exec(cmd, new String[]{"PATH=" + path}) : Runtime.getRuntime().exec(cmd);
            } else {
                return NullCommandResult;
            }
            error = this.getStreamRealGobbler(timeout);
            output = this.getStreamRealGobbler(timeout);
            error.setInputStream(proc.getErrorStream());
            output.setInputStream(proc.getInputStream());
            String out = "";
            long startTime = System.currentTimeMillis();
            boolean timeoutOccured = false;
            while (true) {
                try {
                    out = error.forceAllOutput();
                    if (out == null || out.length() == 0 || proc.exitValue() == 0) break;
                    isError = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    int nr;
                    if (expect != null && (out = output.forceAllOutput()) != null && out.length() != 0 && out.indexOf(expect) != -1 && (nr = this.getStringOccurences(out, expect)) >= howManyTimes) {
                        isError = false;
                        proc.destroy();
                        break;
                    }
                    long endTime = System.currentTimeMillis();
                    if (endTime - startTime > timeout) {
                        isError = true;
                        timeoutOccured = true;
                        proc.destroy();
                        break;
                    }
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
            if (!timeoutOccured) {
                proc.waitFor();
            } else {
                try {
                    Thread.sleep(2000L);
                    proc.getOutputStream().close();
                    proc.getInputStream().close();
                    proc.getErrorStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (out != null && out.length() == 0 || proc.exitValue() == 0) {
                out = output.forceAllOutput();
            }
            error.stopIt();
            output.stopIt();
            this.addStreamRealGobbler(error);
            this.addStreamRealGobbler(output);
            error = null;
            output = null;
            return new CommandResult(out, isError);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (error != null) {
                this.addStreamRealGobbler(error);
                error.stopIt();
                error = null;
            }
            if (output != null) {
                this.addStreamRealGobbler(output);
                output.stopIt();
                output = null;
            }
            return NullCommandResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamGobbler getStreamGobbler() {
        LinkedList linkedList = this.streams;
        synchronized (linkedList) {
            if (this.streams.size() == 0) {
                StreamGobbler stream = new StreamGobbler(null);
                stream.start();
                return stream;
            }
            return (StreamGobbler)this.streams.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamGobbler(StreamGobbler stream) {
        LinkedList linkedList = this.streams;
        synchronized (linkedList) {
            if (!this.stopStreams) {
                this.streams.addLast(stream);
            } else {
                stream.stopItForever();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamRealGobbler getStreamRealGobbler(long timeout) {
        LinkedList linkedList = this.streamsReal;
        synchronized (linkedList) {
            if (this.streamsReal.size() == 0) {
                StreamRealGobbler stream = new StreamRealGobbler(null, timeout);
                stream.start();
                return stream;
            }
            StreamRealGobbler st = (StreamRealGobbler)this.streamsReal.removeFirst();
            st.setTimeout(timeout);
            return st;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamRealGobbler(StreamRealGobbler stream) {
        LinkedList linkedList = this.streamsReal;
        synchronized (linkedList) {
            if (!this.stopStreamsReal) {
                this.streamsReal.addLast(stream);
            } else {
                stream.stopItForever();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt() {
        Thread sg;
        LinkedList linkedList = this.streams;
        synchronized (linkedList) {
            this.stopStreams = true;
            while (this.streams.size() > 0) {
                sg = (StreamGobbler)this.streams.removeFirst();
                ((StreamGobbler)sg).stopItForever();
            }
        }
        linkedList = this.streamsReal;
        synchronized (linkedList) {
            this.stopStreamsReal = true;
            while (this.streamsReal.size() > 0) {
                sg = (StreamRealGobbler)this.streamsReal.removeFirst();
                ((StreamRealGobbler)sg).stopItForever();
            }
        }
    }

    class StreamRealGobbler
    extends Thread {
        final char[] buf;
        InputStream is;
        InputStreamReader isr;
        StringBuilder output;
        boolean stop;
        boolean doneReading;
        boolean stopForever;
        private Thread thread;
        private boolean showProgress;
        private long timeout;

        public StreamRealGobbler(InputStream is, long timeout) {
            super("Stream Real Gobler");
            this.output = new StringBuilder();
            this.stop = false;
            this.doneReading = false;
            this.stopForever = false;
            this.thread = null;
            this.showProgress = false;
            this.timeout = timeout;
            this.is = is;
            this.setDaemon(true);
            this.buf = new char[32];
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInputStream(InputStream is) {
            this.is = is;
            this.output = new StringBuilder();
            this.stop = false;
            char[] cArray = this.buf;
            synchronized (this.buf) {
                this.doneReading = false;
                this.buf.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void setProgress(boolean showProgress) {
            this.showProgress = showProgress;
        }

        public String getOutput() {
            return this.output == null ? null : this.output.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public String forceAllOutput() {
            if (!this.doneReading) {
                try {
                    if (!this.isr.ready()) {
                        return null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.thread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                char[] cArray = this.buf;
                // MONITORENTER : this.buf
                this.buf.notifyAll();
                // MONITOREXIT : cArray
                long start = System.currentTimeMillis();
                while (!this.doneReading) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.doneReading) {
                        if (this.output == null) {
                            return null;
                        }
                        String string = this.output.toString();
                        return string;
                    }
                    long now = System.currentTimeMillis();
                    if (now - start < this.timeout) continue;
                    return null;
                }
            }
            if (this.output == null) {
                return null;
            }
            String string = this.output.toString();
            return string;
        }

        public void stopIt() {
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.isr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopItForever() {
            char[] cArray = this.buf;
            synchronized (this.buf) {
                this.stopIt();
                this.stopForever = true;
                this.buf.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            this.thread = Thread.currentThread();
            while (true) {
                char[] cArray = this.buf;
                // MONITORENTER : this.buf
                while (this.is == null && !this.stopForever) {
                    try {
                        this.buf.wait();
                    }
                    catch (Exception exception) {}
                }
                // MONITOREXIT : cArray
                if (this.stopForever) {
                    cArray = this.buf;
                    // MONITORENTER : this.buf
                    this.doneReading = true;
                    // MONITOREXIT : cArray
                    return;
                }
                try {
                    this.isr = new InputStreamReader(this.is);
                    while (!this.stop) {
                        try {
                            int ret = this.isr.read(this.buf);
                            if (ret <= 0) break;
                            String nstr = new String(this.buf, 0, ret);
                            if (this.showProgress) {
                                cmdExec.this.logger.info(nstr);
                            }
                            this.output.append(nstr);
                        }
                        catch (Exception ex) {
                            // empty catch block
                            break;
                        }
                    }
                    char[] ex = this.buf;
                    // MONITORENTER : this.buf
                    this.doneReading = true;
                    // MONITOREXIT : ex
                }
                catch (Exception ioe) {
                    this.output = new StringBuilder();
                }
                try {
                    this.is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.is = null;
            }
        }
    }

    class StreamGobbler
    extends Thread {
        InputStream is;
        StringBuilder output;
        boolean stop;
        boolean stopForever;
        boolean doneReading;

        public StreamGobbler(InputStream is) {
            super("Stream Gobler");
            this.stop = false;
            this.stopForever = false;
            this.doneReading = false;
            this.is = is;
            this.output = new StringBuilder();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInputStream(InputStream is) {
            this.is = is;
            this.output = new StringBuilder();
            this.stop = false;
            StreamGobbler streamGobbler = this;
            synchronized (streamGobbler) {
                this.doneReading = false;
                this.notify();
            }
        }

        public String getOutput() {
            return this.output == null ? null : this.output.toString();
        }

        public synchronized String forceAllOutput() {
            if (!this.doneReading) {
                return null;
            }
            this.doneReading = false;
            return this.output == null ? null : this.output.toString();
        }

        public void stopIt() {
            this.stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopItForever() {
            StreamGobbler streamGobbler = this;
            synchronized (streamGobbler) {
                this.stopForever = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                StreamGobbler streamGobbler = this;
                synchronized (streamGobbler) {
                    while (this.is == null && !this.stopForever) {
                        try {
                            this.wait();
                        }
                        catch (Exception exception) {}
                    }
                }
                if (this.stopForever) break;
                try {
                    InputStreamReader isr = new InputStreamReader(this.is);
                    BufferedReader br = new BufferedReader(isr);
                    String line = null;
                    while (!this.stop && (line = br.readLine()) != null) {
                        this.output.append(line);
                    }
                    StreamGobbler streamGobbler2 = this;
                    synchronized (streamGobbler2) {
                        this.doneReading = true;
                    }
                    this.is.close();
                }
                catch (Exception ioe) {
                    this.output = new StringBuilder();
                }
                this.is = null;
            }
        }
    }

    public static class CommandResult {
        private final String output;
        private final boolean failed;

        public CommandResult(String output, boolean wasError) {
            this.output = output;
            this.failed = wasError;
        }

        public String getOutput() {
            return this.output == null ? "" : this.output;
        }

        public boolean failed() {
            return this.failed;
        }
    }
}

