/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.HeaderBufferPool;
import lia.util.net.copy.transport.internal.FDTSelectionKey;

public abstract class FDTKeyAttachement {
    private static final AtomicInteger SEQ = new AtomicInteger(0);
    private static final HeaderBufferPool headerPool = HeaderBufferPool.getInstance();
    private static final DirectByteBufferPool payloadPool = DirectByteBufferPool.getInstance();
    protected final int seq;
    private final ByteBuffer[] _array = new ByteBuffer[2];
    public FDTSelectionKey fdtSelectionKey;
    protected boolean useFixedSizeBlocks;
    private ByteBuffer header = null;
    private ByteBuffer payload = null;

    public FDTKeyAttachement(FDTSelectionKey fdtSelectionKey, boolean useFixedSizeBlocks) {
        this.seq = SEQ.getAndIncrement();
        this.fdtSelectionKey = fdtSelectionKey;
        this.useFixedSizeBlocks = useFixedSizeBlocks;
    }

    public synchronized void setBuffers(ByteBuffer header, ByteBuffer payload) {
        this.header = header;
        this.payload = payload;
        this.setArray();
    }

    private void setArray() {
        this._array[0] = this.header;
        this._array[1] = this.payload;
    }

    public synchronized void recycleBuffers() {
        if (this.header != null) {
            headerPool.put(this.header);
            this.header = null;
        }
        if (this.payload != null) {
            payloadPool.put(this.payload);
            this.payload = null;
        }
        this.setArray();
    }

    public synchronized void recycleAndSetPayload(ByteBuffer bb) {
        if (this.payload != null) {
            payloadPool.put(this.payload);
        }
        this.payload = bb;
        this.setArray();
    }

    public synchronized void setPayload(ByteBuffer bb) {
        this.payload = bb;
        this.setArray();
    }

    public synchronized void recycleHeader() {
        if (this.header != null) {
            headerPool.put(this.header);
            this.header = null;
        }
        this.setArray();
    }

    public synchronized void recyclePaylod() {
        if (this.payload != null) {
            payloadPool.put(this.payload);
            this.payload = null;
        }
        this.setArray();
    }

    public synchronized boolean recycleAndSetBuffers() throws InterruptedException {
        this.recycleBuffers();
        ByteBuffer _header = null;
        ByteBuffer _payload = null;
        try {
            _header = headerPool.poll(2L, TimeUnit.SECONDS);
            if (_header != null) {
                _payload = payloadPool.poll(2L, TimeUnit.SECONDS);
            }
        }
        finally {
            if (_header == null) {
                return false;
            }
            if (_payload == null) {
                if (_header != null) {
                    headerPool.put(_header);
                    this.header = null;
                }
                return false;
            }
        }
        this.setBuffers(_header, _payload);
        return true;
    }

    public synchronized boolean hasBuffers() {
        return this.header != null && this.payload != null;
    }

    public synchronized boolean hasHeader() {
        return this.header != null;
    }

    public synchronized boolean hasPayload() {
        return this.payload != null;
    }

    public synchronized ByteBuffer[] asArray() {
        return this._array;
    }

    public final boolean useFixedSizeBlocks() {
        return this.useFixedSizeBlocks;
    }

    public final synchronized ByteBuffer header() {
        return this.header;
    }

    public final synchronized ByteBuffer payload() {
        return this.payload;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SocketAttachement :- header: ").append(this.header).append(" :- payload: ").append(this.payload);
        return sb.toString();
    }
}

