/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.util.Strings;

public class SendSignedAndEncryptedMail {
    public static void main(String[] stringArray) {
        if (stringArray.length != 5) {
            System.err.println("usage: SendSignedAndEncryptedMail <pkcs12Keystore> <password> <keyalias> <smtp server> <email address>");
            System.exit(0);
        }
        try {
            MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
            mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
            mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
            mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
            mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
            CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
            Security.addProvider(new BouncyCastleProvider());
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            keyStore.load(new FileInputStream(stringArray[0]), stringArray[1].toCharArray());
            Certificate[] certificateArray = keyStore.getCertificateChain(stringArray[2]);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(stringArray[2], stringArray[1].toCharArray());
            if (privateKey == null) {
                throw new Exception("cannot find private key for alias: " + stringArray[2]);
            }
            Properties properties = System.getProperties();
            properties.put("mail.smtp.host", stringArray[3]);
            Session session = Session.getDefaultInstance((Properties)properties, null);
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(stringArray[4]));
            mimeMessage.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(stringArray[4]));
            mimeMessage.setSubject("example encrypted message");
            mimeMessage.setContent((Object)"example encrypted message", "text/plain");
            mimeMessage.saveChanges();
            SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
            sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
            sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((DEREncodable)((Object)new SMIMEEncryptionKeyPreferenceAttribute(new IssuerAndSerialNumber(new X500Name(((X509Certificate)certificateArray[0]).getIssuerDN().getName()), ((X509Certificate)certificateArray[0]).getSerialNumber()))));
            aSN1EncodableVector.add((DEREncodable)((Object)new SMIMECapabilitiesAttribute(sMIMECapabilityVector)));
            SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator();
            sMIMESignedGenerator.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(aSN1EncodableVector)).build("DSA".equals(privateKey.getAlgorithm()) ? "SHA1withDSA" : "MD5withDSA", privateKey, (X509Certificate)certificateArray[0]));
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            arrayList.add(certificateArray[0]);
            JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
            sMIMESignedGenerator.addCertificates(jcaCertStore);
            MimeMultipart mimeMultipart = sMIMESignedGenerator.generate(mimeMessage, "BC");
            MimeMessage mimeMessage2 = new MimeMessage(session);
            Enumeration enumeration = mimeMessage.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                mimeMessage2.addHeaderLine((String)enumeration.nextElement());
            }
            mimeMessage2.setContent((Multipart)mimeMultipart);
            mimeMessage2.saveChanges();
            SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
            sMIMEEnvelopedGenerator.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator((X509Certificate)certificateArray[0]).setProvider("BC"));
            MimeBodyPart mimeBodyPart = sMIMEEnvelopedGenerator.generate(mimeMessage2, new JceCMSContentEncryptorBuilder(CMSAlgorithm.RC2_CBC).setProvider("BC").build());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            mimeBodyPart.writeTo((OutputStream)byteArrayOutputStream);
            MimeMessage mimeMessage3 = new MimeMessage(session, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            enumeration = mimeMessage.getAllHeaderLines();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (Strings.toLowerCase(string).startsWith("content-")) continue;
                mimeMessage3.addHeaderLine(string);
            }
            Transport.send((Message)mimeMessage3);
        }
        catch (SMIMEException sMIMEException) {
            sMIMEException.getUnderlyingException().printStackTrace(System.err);
            sMIMEException.printStackTrace(System.err);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

