/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.SocketPool;
import org.globus.ftp.extended.GridFTPServerFacade;

public class StripeContextManager {
    static Log logger = LogFactory.getLog(StripeContextManager.class.getName());
    protected int stripes;
    protected StripeTransferContext[] contextList;
    protected int stripeQuitTokens = 0;
    protected Object contextQuitToken = new Object();

    public StripeContextManager(int stripes, SocketPool pool, GridFTPServerFacade facade) {
        this.stripes = stripes;
        this.contextList = new StripeTransferContext[stripes];
        for (int i = 0; i < stripes; ++i) {
            this.contextList[i] = new StripeTransferContext(this);
            this.contextList[i].setSocketPool(pool);
            this.contextList[i].setTransferThreadManager(facade.createTransferThreadManager());
        }
    }

    public int getStripes() {
        return this.stripes;
    }

    public EBlockParallelTransferContext getStripeContext(int stripe) {
        return this.contextList[stripe];
    }

    public Object getQuitToken() {
        for (int i = 0; i < this.stripes; ++i) {
            logger.debug("examining stripe " + i);
            if (this.contextList[i].getStripeQuitToken() == null) continue;
            ++this.stripeQuitTokens;
            logger.debug("obtained stripe quit token. Total = " + this.stripeQuitTokens + "; total needed = " + this.stripes);
        }
        if (this.stripeQuitTokens == this.stripes) {
            if (this.contextQuitToken == null) {
                logger.debug("not releasing the quit token.");
            } else {
                logger.debug("releasing the quit token.");
            }
            Object myToken = this.contextQuitToken;
            this.contextQuitToken = null;
            return myToken;
        }
        logger.debug("not releasing the quit token. ");
        return null;
    }

    class StripeTransferContext
    extends EBlockParallelTransferContext {
        StripeContextManager mgr;

        public StripeTransferContext(StripeContextManager mgr) {
            this.mgr = mgr;
        }

        public Object getStripeQuitToken() {
            Object token = super.getQuitToken();
            logger.debug(token != null ? "stripe released the quit token" : "stripe did not release the quit token");
            return token;
        }

        public Object getQuitToken() {
            return this.mgr.getQuitToken();
        }
    }
}

