/*
 * Decompiled with CFR 0.152.
 */
package org.globusonline.transfer;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.globusonline.transfer.APIError;
import org.globusonline.transfer.Authenticator;

public class BaseTransferAPIClient {
    protected String username;
    protected String baseUrl;
    protected String format;
    protected Authenticator authenticator;
    protected boolean useMultiThreaded = false;
    protected int timeout = 30000;
    protected KeyManager[] keyManagers;
    protected TrustManager[] trustManagers;
    protected SSLSocketFactory socketFactory;
    static final String VERSION = "v0.10";
    static final String PROD_BASE_URL = "https://transfer.api.globusonline.org/v0.10";
    static final String QA_BASE_URL = "https://transfer.qa.api.globusonline.org/v0.10";
    static final String TEST_BASE_URL = "https://transfer.test.api.globusonline.org/v0.10";
    static final String DEFAULT_BASE_URL = "https://transfer.api.globusonline.org/v0.10";
    public static final String FORMAT_JSON = "application/json";
    public static final String FORMAT_HTML = "application/xhtml+xml";
    public static final String FORMAT_DEFAULT = "application/json";
    static final String CLIENT_VERSION = "0.10.8";

    public static void main(String[] stringArray) {
        BaseTransferAPIClient baseTransferAPIClient = new BaseTransferAPIClient(stringArray[0], "application/json");
        try {
            HttpsURLConnection httpsURLConnection = baseTransferAPIClient.request("GET", "/tasksummary");
            BaseTransferAPIClient.printResult(httpsURLConnection);
            httpsURLConnection.disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BaseTransferAPIClient(String string, String string2) {
        this(string, string2, null, null, null);
    }

    public BaseTransferAPIClient(String string, String string2, String string3) {
        this(string, string2, null, null, string3);
    }

    public BaseTransferAPIClient(String string, String string2, TrustManager[] trustManagerArray, KeyManager[] keyManagerArray, String string3) {
        this.username = string;
        this.format = string2;
        this.baseUrl = string3 == null ? "https://transfer.api.globusonline.org/v0.10" : string3;
        this.trustManagers = trustManagerArray;
        this.keyManagers = keyManagerArray;
        this.socketFactory = null;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public HttpsURLConnection request(String string, String string2) throws IOException, MalformedURLException, GeneralSecurityException, APIError {
        return this.request(string, string2, null, null);
    }

    public HttpsURLConnection request(String string, String string2, String string3, Map<String, String> map) throws IOException, MalformedURLException, GeneralSecurityException, APIError {
        int n;
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        this.initSocketFactory(false);
        SSLSocketFactory sSLSocketFactory = this.socketFactory;
        if (this.useMultiThreaded) {
            sSLSocketFactory = this.createSocketFactory();
        }
        if (map != null) {
            string2 = string2 + "?" + BaseTransferAPIClient.buildQueryString(map);
        }
        URL uRL = new URL(this.baseUrl + string2);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
        httpsURLConnection.setConnectTimeout(this.timeout);
        httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
        httpsURLConnection.setRequestMethod(string);
        HttpsURLConnection.setFollowRedirects(false);
        httpsURLConnection.setUseCaches(false);
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestProperty("X-Transfer-API-X509-User", this.username);
        httpsURLConnection.setRequestProperty("X-Transfer-API-Client", this.getClass().getName() + "/" + CLIENT_VERSION);
        httpsURLConnection.setRequestProperty("Accept", this.format);
        if (this.authenticator != null) {
            this.authenticator.authenticateConnection(httpsURLConnection);
        }
        if (string3 != null) {
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setRequestProperty("Content-Type", this.format);
            httpsURLConnection.setRequestProperty("Content-Length", "" + string3.length());
        }
        httpsURLConnection.connect();
        if (string3 != null) {
            DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
            dataOutputStream.writeBytes(string3);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        if ((n = httpsURLConnection.getResponseCode()) >= 400) {
            String string4 = httpsURLConnection.getResponseMessage();
            String string5 = null;
            Map<String, List<String>> map2 = httpsURLConnection.getHeaderFields();
            if (map2.containsKey("X-Transfer-API-Error")) {
                string5 = map2.get("X-Transfer-API-Error").get(0);
            }
            throw this.constructAPIError(n, string4, string5, httpsURLConnection.getErrorStream());
        }
        return httpsURLConnection;
    }

    protected APIError constructAPIError(int n, String string, String string2, InputStream inputStream) {
        return new APIError(n, string, string2);
    }

    public void setConnectTimeout(int n) {
        this.timeout = n;
    }

    public void setUseMultiThreaded(boolean bl) {
        this.useMultiThreaded = bl;
    }

    protected SSLSocketFactory createSocketFactory() {
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(this.keyManagers, this.trustManagers, null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't create SSLSocketFactory.", exception);
        }
    }

    protected synchronized void initSocketFactory(boolean bl) {
        if (this.socketFactory == null || bl) {
            this.socketFactory = this.createSocketFactory();
        }
    }

    public static void printResult(HttpsURLConnection httpsURLConnection) throws IOException, GeneralSecurityException, APIError {
        Object object;
        Object object2;
        Object object3;
        Map.Entry<String, List<String>> entry2;
        int n = httpsURLConnection.getResponseCode();
        String string = httpsURLConnection.getResponseMessage();
        System.out.println(n + " " + string);
        Map<String, List<String>> map = httpsURLConnection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry2 : map.entrySet()) {
            object3 = entry2.getKey();
            if (object3 == null) continue;
            object2 = (List)entry2.getValue();
            object = object2.iterator();
            while (object.hasNext()) {
                System.out.println(entry2.getKey() + ": " + object.next());
            }
        }
        entry2 = null;
        entry2 = n < 400 ? httpsURLConnection.getInputStream() : httpsURLConnection.getErrorStream();
        object3 = new InputStreamReader((InputStream)((Object)entry2));
        object2 = new BufferedReader((Reader)object3);
        while ((object = ((BufferedReader)object2).readLine()) != null) {
            System.out.println((String)object);
        }
        ((BufferedReader)object2).close();
    }

    public String getUsername() {
        return this.username;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getFormat() {
        return this.format;
    }

    public static String buildQueryString(Map<String, String> map) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            stringBuilder.append("=");
            stringBuilder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return stringBuilder.toString();
    }

    public static String endpointPath(String string) throws UnsupportedEncodingException {
        return "/endpoint/" + URLEncoder.encode(string);
    }
}

