/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.ac.impl;

import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.ac.ACLookupListener;
import org.italiangrid.voms.ac.ACParsingContext;
import org.italiangrid.voms.ac.VOMSACLookupStrategy;
import org.italiangrid.voms.asn1.VOMSACUtils;
import org.italiangrid.voms.asn1.VOMSConstants;
import org.italiangrid.voms.util.NullListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafACLookupStrategy
implements VOMSACLookupStrategy,
VOMSConstants {
    private ACLookupListener listener;

    public LeafACLookupStrategy(ACLookupListener l) {
        this.listener = l;
    }

    public LeafACLookupStrategy() {
        this(NullListener.INSTANCE);
    }

    @Override
    public List<ACParsingContext> lookupVOMSAttributeCertificates(X509Certificate[] certChain) {
        ArrayList<ACParsingContext> parsedACs = new ArrayList<ACParsingContext>();
        if (certChain == null || certChain.length == 0) {
            throw new VOMSError("Cannot extract VOMS Attribute Certificates from a null or empty certificate chain!");
        }
        for (int index = 0; index < certChain.length; ++index) {
            X509Certificate cert = certChain[index];
            this.listener.notifyACLookupEvent(certChain, index);
            try {
                List<AttributeCertificate> vomsACs;
                if (!ProxyUtils.isProxy(cert) || (vomsACs = VOMSACUtils.getACsFromCertificate(cert)).isEmpty()) continue;
                this.listener.notifyACParseEvent(certChain, index);
                ACParsingContext ctx = new ACParsingContext(vomsACs, index, certChain);
                parsedACs.add(ctx);
                break;
            }
            catch (IOException e) {
                throw new VOMSError(e.getMessage(), e);
            }
        }
        return parsedACs;
    }
}

