/*
 * Decompiled with CFR 0.152.
 */
package apmon;

import apmon.ApMonException;
import apmon.ApMonMonitoringConstants;
import apmon.BkThread;
import apmon.MonitoredJob;
import apmon.XDROutputStream;
import apmon.host.cmdExec;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import lia.util.net.common.Config;
import lia.util.net.common.MonitoringUtils;

public class ApMon {
    public static final int MAX_DGRAM_SIZE = 8192;
    public static final int XDR_STRING = 0;
    public static final int XDR_INT32 = 2;
    public static final int XDR_REAL32 = 4;
    public static final int XDR_REAL64 = 5;
    public static final int DEFAULT_PORT = 8884;
    public static final int JOB_MONITOR_INTERVAL = 20;
    public static final int SYS_MONITOR_INTERVAL = 20;
    public static final int RECHECK_INTERVAL = 600;
    public static final int MAX_MSG_RATE = 20;
    public static final int GEN_MONITOR_INTERVALS = 100;
    static final String APMON_VERSION = "2.2.7";
    static final int FILE_INIT = 1;
    static final int LIST_INIT = 2;
    static final int DIRECT_INIT = 3;
    static String osName;
    private static Logger logger;
    private static Map mValueTypes;
    protected long prvTime = 0L;
    protected double prvSent = 0.0;
    protected double prvDrop = 0.0;
    protected long crtTime = 0L;
    protected long crtSent = 0L;
    protected long crtDrop = 0L;
    protected double hWeight = Math.exp(-0.08333333333333333);
    Object initSource = null;
    int initType;
    long recheckInterval = 600L;
    long crtRecheckInterval = 600L;
    String clusterName;
    String nodeName;
    Vector destAddresses;
    Vector destPorts;
    Vector destPasswds;
    byte[] buf;
    int dgramSize;
    Hashtable confResources;
    ByteArrayOutputStream baos;
    DatagramSocket dgramSocket;
    BkThread bkThread = null;
    boolean bkThreadStarted = false;
    Object mutexBack = new Object();
    Object mutexCond = new Object();
    boolean condChanged = false;
    boolean recheckChanged;
    boolean jobMonChanged;
    boolean sysMonChanged;
    boolean autoDisableMonitoring = true;
    boolean confCheck = false;
    boolean sysMonitoring = false;
    boolean jobMonitoring = false;
    boolean genMonitoring = false;
    long jobMonitorInterval = 20L;
    long sysMonitorInterval = 20L;
    int maxMsgRate = 20;
    int genMonitorIntervals = 100;
    long sysMonitorParams;
    long jobMonitorParams;
    long genMonitorParams;
    long lastJobInfoSend;
    long lastSysInfoSend;
    double lastUtime;
    double lastStime;
    String myHostname = null;
    String myIP = null;
    int numCPUs;
    Vector netInterfaces = new Vector();
    Vector allMyIPs = new Vector();
    String sysClusterName = "ApMon_userSend";
    String sysNodeName = null;
    Vector monJobs = new Vector();
    Hashtable sender = new Hashtable();

    public ApMon(String filename) throws ApMonException, SocketException, IOException {
        this.initType = 1;
        this.initMonitoring();
        this.initSource = filename;
        this.initialize(filename, true);
        this.initSenderRef();
    }

    public ApMon(Vector destList) throws ApMonException, SocketException, IOException {
        this.initType = 2;
        this.initMonitoring();
        this.initSource = destList;
        this.initialize(destList, true);
        this.initSenderRef();
    }

    public ApMon(Vector destAddresses, Vector destPorts) throws ApMonException, SocketException, IOException {
        this.initType = 3;
        this.arrayInit(destAddresses, destPorts, null);
        this.initSenderRef();
    }

    public ApMon(Vector destAddresses, Vector destPorts, Vector destPasswds) throws ApMonException, SocketException, IOException {
        this.initType = 3;
        this.initMonitoring();
        this.arrayInit(destAddresses, destPorts, destPasswds);
        this.initSenderRef();
    }

    public static void setLogLevel(String newLevel_s) {
        int i;
        String[] levels_s = new String[]{"FATAL", "WARNING", "INFO", "FINE", "DEBUG"};
        Level[] levels = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINEST};
        for (i = 0; i < 5 && !newLevel_s.equals(levels_s[i]); ++i) {
        }
        if (i >= 5) {
            logger.warning("[ setLogLevel() ] Invalid level value: " + newLevel_s);
            return;
        }
        logger.info("Setting logging level to " + newLevel_s);
        logger.setLevel(levels[i]);
    }

    public static int getPID() {
        try {
            RuntimeMXBean rt = ManagementFactory.getRuntimeMXBean();
            return Integer.parseInt(rt.getName().split("@")[0]);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public void addJobToMonitor(int pid, String workDir, String clusterName, String nodeName) {
        MonitoredJob job = new MonitoredJob(pid, workDir, clusterName, nodeName);
        if (!this.monJobs.contains(job)) {
            this.monJobs.add(job);
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Job <" + job + "> already exsist.");
        }
    }

    public void removeJobToMonitor(int pid) {
        for (int i = 0; i < this.monJobs.size(); ++i) {
            MonitoredJob job = (MonitoredJob)this.monJobs.elementAt(i);
            if (job.getPid() != pid) continue;
            this.monJobs.remove(job);
            break;
        }
    }

    public void setMonitorClusterNode(String cName, String nName) {
        if (cName != null) {
            this.sysClusterName = cName;
        }
        if (nName != null) {
            this.sysNodeName = nName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(String filename, boolean firstTime) throws ApMonException, SocketException, IOException {
        Vector destAddresses = new Vector();
        Vector destPorts = new Vector();
        Vector destPasswds = new Vector();
        Hashtable confRes = new Hashtable();
        try {
            this.loadFile(filename, destAddresses, destPorts, destPasswds, confRes);
        }
        catch (Exception e) {
            if (firstTime) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof ApMonException) {
                    throw (ApMonException)e;
                }
            }
            logger.warning("Configuration not reloaded successfully, keeping the previous one");
            return;
        }
        ApMon apMon = this;
        synchronized (apMon) {
            this.arrayInit(destAddresses, destPorts, destPasswds, firstTime);
            this.confResources = confRes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(Vector destList, boolean firstTime) throws ApMonException, SocketException, IOException {
        Vector destAddresses = new Vector();
        Vector destPorts = new Vector();
        Vector destPasswds = new Vector();
        Hashtable confRes = new Hashtable();
        logger.info("Initializing destination addresses & ports:");
        try {
            for (int i = 0; i < destList.size(); ++i) {
                String dest = (String)destList.get(i);
                if (dest.startsWith("http")) {
                    this.loadURL(dest, destAddresses, destPorts, destPasswds, confRes);
                    continue;
                }
                this.addToDestinations(dest, destAddresses, destPorts, destPasswds);
            }
        }
        catch (Exception e) {
            if (firstTime) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof ApMonException) {
                    throw (ApMonException)e;
                }
                if (e instanceof SocketException) {
                    throw (SocketException)e;
                }
            }
            logger.warning("Configuration not reloaded successfully, keeping the previous one");
            return;
        }
        ApMon apMon = this;
        synchronized (apMon) {
            this.arrayInit(destAddresses, destPorts, destPasswds, firstTime);
            this.confResources = confRes;
        }
    }

    void loadFile(String filename, Vector destAddresses, Vector destPorts, Vector destPasswds, Hashtable confRes) throws IOException, ApMonException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        confRes.put(new File(filename), new Long(System.currentTimeMillis()));
        logger.info("Loading file " + filename + "...");
        while ((line = in.readLine()) != null) {
            String tmp = line.trim();
            if (tmp.length() == 0 || tmp.startsWith("#")) continue;
            if (tmp.startsWith("xApMon_loglevel")) {
                StringTokenizer lst = new StringTokenizer(tmp, " =");
                lst.nextToken();
                ApMon.setLogLevel(lst.nextToken());
                continue;
            }
            if (tmp.startsWith("xApMon_")) {
                this.parseXApMonLine(tmp);
                continue;
            }
            this.addToDestinations(tmp, destAddresses, destPorts, destPasswds);
        }
    }

    void loadURL(String url, Vector destAddresses, Vector destPorts, Vector destPasswds, Hashtable confRes) throws IOException, ApMonException {
        String destLine;
        System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
        System.setProperty("sun.net.client.defaultReadTimeout", "5000");
        URL destURL = null;
        try {
            destURL = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ApMonException(e.getMessage());
        }
        URLConnection urlConn = destURL.openConnection();
        long lmt = urlConn.getLastModified();
        confRes.put(new URL(url), new Long(lmt));
        logger.info("Loading from URL " + url + "...");
        BufferedReader br = new BufferedReader(new InputStreamReader(destURL.openStream()));
        while ((destLine = br.readLine()) != null) {
            String tmp2 = destLine.trim();
            if (tmp2.length() == 0 || tmp2.startsWith("#")) continue;
            if (tmp2.startsWith("xApMon_loglevel")) {
                StringTokenizer lst = new StringTokenizer(tmp2, " =");
                lst.nextToken();
                ApMon.setLogLevel(lst.nextToken());
                continue;
            }
            if (tmp2.startsWith("xApMon_")) {
                this.parseXApMonLine(tmp2);
                continue;
            }
            this.addToDestinations(tmp2, destAddresses, destPorts, destPasswds);
        }
        br.close();
    }

    void addToDestinations(String line, Vector destAddresses, Vector destPorts, Vector destPasswds) {
        int port = 8884;
        String[] tokens = line.split("(\\s)+");
        String passwd = "";
        if (tokens == null) {
            return;
        }
        line = tokens[0].trim();
        if (tokens.length > 1) {
            passwd = tokens[1].trim();
        }
        StringTokenizer st = new StringTokenizer(line, ":");
        String addr = st.nextToken();
        try {
            port = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 8884;
        }
        catch (NumberFormatException e) {
            logger.warning("Wrong address: " + line);
        }
        destAddresses.add(addr);
        destPorts.add(new Integer(port));
        if (passwd != null) {
            destPasswds.add(passwd);
        }
    }

    void arrayInit(Vector destAddresses, Vector destPorts, Vector destPasswds) throws ApMonException, SocketException, IOException {
        this.arrayInit(destAddresses, destPorts, destPasswds, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void arrayInit(Vector destAddresses, Vector destPorts, Vector destPasswds, boolean firstTime) throws ApMonException, SocketException, IOException {
        if (destAddresses.size() == 0 || destPorts.size() == 0) {
            throw new ApMonException("No destination hosts specified");
        }
        Vector<String> tmpAddresses = new Vector<String>();
        Vector tmpPorts = new Vector();
        Vector tmpPasswds = new Vector();
        for (int i = 0; i < destAddresses.size(); ++i) {
            InetAddress inetAddr = InetAddress.getByName((String)destAddresses.get(i));
            String ipAddr = inetAddr.getHostAddress();
            if (tmpAddresses.contains(ipAddr)) continue;
            tmpAddresses.add(ipAddr);
            tmpPorts.add(destPorts.get(i));
            if (destPasswds != null) {
                tmpPasswds.add(destPasswds.get(i));
            }
            logger.info("adding destination: " + ipAddr + ":" + destPorts.get(i));
        }
        ApMon i = this;
        synchronized (i) {
            this.destPorts = new Vector(tmpPorts);
            this.destAddresses = new Vector(tmpAddresses);
            this.destPasswds = new Vector(tmpPasswds);
        }
        if (firstTime) {
            cmdExec exec = new cmdExec();
            this.myHostname = exec.executeCommand("hostname -f", "");
            exec.stopIt();
            this.sysNodeName = this.myHostname;
            this.dgramSocket = new DatagramSocket();
            this.lastJobInfoSend = System.currentTimeMillis();
            try {
                this.lastSysInfoSend = BkThread.getBootTime();
            }
            catch (Exception e) {
                logger.warning("Error reading boot time from /proc/stat/.");
                this.lastSysInfoSend = 0L;
            }
            this.lastStime = 0.0;
            this.lastUtime = 0.0;
            BkThread.getNetConfig(this.netInterfaces, this.allMyIPs);
            this.myIP = this.allMyIPs.size() > 0 ? (String)this.allMyIPs.get(0) : "unknown";
            try {
                this.baos = new ByteArrayOutputStream();
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "", t);
                throw new ApMonException("Got General Exception while encoding:" + t);
            }
        }
        this.setJobMonitoring(this.jobMonitoring, this.jobMonitorInterval);
        this.setSysMonitoring(this.sysMonitoring, this.sysMonitorInterval);
        this.setGenMonitoring(this.genMonitoring, this.genMonitorIntervals);
        this.setConfRecheck(this.confCheck, this.recheckInterval);
    }

    public void sendTimedParameters(String clusterName, String nodeName, int nParams, Vector paramNames, Vector valueTypes, Vector paramValues, int timestamp) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendTimedParameters(clusterName, nodeName, nParams, paramNames, paramValues, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTimedParameters(String clusterName, String nodeName, int nParams, Vector paramNames, Vector paramValues, int timestamp) throws ApMonException, UnknownHostException, SocketException, IOException {
        if (Config.getInstance().getMonitor().equals("OPENTSDB")) {
            MonitoringUtils monUtils = new MonitoringUtils(Config.getInstance());
            monUtils.shareMetrics(clusterName, nodeName, paramNames, paramValues);
        }
        if (!this.shouldSend()) {
            return;
        }
        if (clusterName != null) {
            this.clusterName = clusterName;
            this.nodeName = nodeName != null ? new String(nodeName) : this.myHostname;
        }
        this.updateSEQ_NR();
        this.encodeParams(nParams, paramNames, paramValues, timestamp);
        ApMon apMon = this;
        synchronized (apMon) {
            for (int i = 0; i < this.destAddresses.size(); ++i) {
                InetAddress destAddr = InetAddress.getByName((String)this.destAddresses.get(i));
                int port = (Integer)this.destPorts.get(i);
                String header = "v:2.2.7_jp:";
                String passwd = "";
                if (this.destPasswds != null && this.destPasswds.size() == this.destAddresses.size()) {
                    passwd = (String)this.destPasswds.get(i);
                }
                header = header + passwd;
                byte[] newBuff = null;
                try {
                    XDROutputStream xdrOS = new XDROutputStream(this.baos);
                    xdrOS.writeString(header);
                    xdrOS.pad();
                    xdrOS.writeInt((Integer)this.sender.get("INSTANCE_ID"));
                    xdrOS.pad();
                    xdrOS.writeInt((Integer)this.sender.get("SEQ_NR"));
                    xdrOS.pad();
                    xdrOS.flush();
                    byte[] tmpbuf = this.baos.toByteArray();
                    this.baos.reset();
                    newBuff = new byte[tmpbuf.length + this.buf.length];
                    System.arraycopy(tmpbuf, 0, newBuff, 0, tmpbuf.length);
                    System.arraycopy(this.buf, 0, newBuff, tmpbuf.length, this.buf.length);
                }
                catch (Throwable t) {
                    logger.warning("Cannot add ApMon header...." + t);
                    newBuff = this.buf;
                }
                if (newBuff == null || newBuff.length == 0) {
                    logger.warning("Cannot send null or 0 length buffer!!");
                    continue;
                }
                this.dgramSize = newBuff.length;
                DatagramPacket dp = new DatagramPacket(newBuff, this.dgramSize, destAddr, port);
                try {
                    this.dgramSocket.send(dp);
                }
                catch (IOException e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.warning("Error sending parameters to " + this.destAddresses.get(i));
                    }
                    this.dgramSocket.close();
                    this.dgramSocket = new DatagramSocket();
                }
                if (!logger.isLoggable(Level.FINE)) continue;
                StringBuffer sbLogMsg = new StringBuffer();
                sbLogMsg.append(" Datagram with size ").append(this.dgramSize);
                sbLogMsg.append(" sent to ").append(this.destAddresses.get(i)).append(", containing parameters:\n");
                sbLogMsg.append(this.printParameters(paramNames, paramValues));
                logger.log(Level.FINE, sbLogMsg.toString());
            }
        }
    }

    public void sendParameters(String clusterName, String nodeName, int nParams, Vector paramNames, Vector valueTypes, Vector paramValues) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendParameters(clusterName, nodeName, nParams, paramNames, paramValues);
    }

    public void sendParameters(String clusterName, String nodeName, int nParams, Vector paramNames, Vector paramValues) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendTimedParameters(clusterName, nodeName, nParams, paramNames, paramValues, -1);
    }

    public void sendParameter(String clusterName, String nodeName, String paramName, int valueType, Object paramValue) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendParameter(clusterName, nodeName, paramName, paramValue);
    }

    public void sendParameter(String clusterName, String nodeName, String paramName, Object paramValue) throws ApMonException, UnknownHostException, SocketException, IOException {
        Vector<String> paramNames = new Vector<String>();
        paramNames.add(paramName);
        Vector<Object> paramValues = new Vector<Object>();
        paramValues.add(paramValue);
        this.sendParameters(clusterName, nodeName, 1, paramNames, paramValues);
    }

    public void sendTimedParameter(String clusterName, String nodeName, String paramName, int valueType, Object paramValue, int timestamp) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendTimedParameter(clusterName, nodeName, paramName, paramValue, timestamp);
    }

    public void sendTimedParameter(String clusterName, String nodeName, String paramName, Object paramValue, int timestamp) throws ApMonException, UnknownHostException, SocketException, IOException {
        Vector<String> paramNames = new Vector<String>();
        paramNames.add(paramName);
        Vector<Object> paramValues = new Vector<Object>();
        paramValues.add(paramValue);
        this.sendTimedParameters(clusterName, nodeName, 1, paramNames, paramValues, timestamp);
    }

    public void sendParameter(String clusterName, String nodeName, String paramName, int paramValue) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendParameter(clusterName, nodeName, paramName, new Integer(paramValue));
    }

    public void sendTimedParameter(String clusterName, String nodeName, String paramName, int paramValue, int timestamp) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendTimedParameter(clusterName, nodeName, paramName, new Integer(paramValue), timestamp);
    }

    public void sendParameter(String clusterName, String nodeName, String paramName, double paramValue) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendParameter(clusterName, nodeName, paramName, new Double(paramValue));
    }

    public void sendTimedParameter(String clusterName, String nodeName, String paramName, double paramValue, int timestamp) throws ApMonException, UnknownHostException, SocketException, IOException {
        this.sendTimedParameter(clusterName, nodeName, paramName, new Double(paramValue), timestamp);
    }

    void ensureSize(ByteArrayOutputStream baos) throws ApMonException {
        if (baos == null) {
            throw new ApMonException("Null ByteArrayOutputStream");
        }
        if (baos.size() > 8192) {
            throw new ApMonException("Maximum datagram size exceeded");
        }
    }

    void encodeParams(int nParams, Vector paramNames, Vector paramValues, int timestamp) throws ApMonException {
        try {
            XDROutputStream xdrOS = new XDROutputStream(this.baos);
            this.ensureSize(this.baos);
            xdrOS.writeString(this.clusterName);
            xdrOS.pad();
            xdrOS.writeString(this.nodeName);
            xdrOS.pad();
            xdrOS.writeInt(nParams);
            xdrOS.pad();
            for (int i = 0; i < nParams; ++i) {
                xdrOS.writeString((String)paramNames.get(i));
                xdrOS.pad();
                Object oValue = paramValues.get(i);
                int valType = (Integer)mValueTypes.get(oValue.getClass().getName());
                xdrOS.writeInt(valType);
                xdrOS.pad();
                switch (valType) {
                    case 0: {
                        xdrOS.writeString((String)paramValues.get(i));
                        break;
                    }
                    case 2: {
                        int ival = (Integer)paramValues.get(i);
                        xdrOS.writeInt(ival);
                        break;
                    }
                    case 5: {
                        double dval = (Double)paramValues.get(i);
                        xdrOS.writeDouble(dval);
                        break;
                    }
                    default: {
                        throw new ApMonException("Unknown type for XDR encoding");
                    }
                }
                xdrOS.pad();
            }
            if (timestamp > 0) {
                xdrOS.writeInt(timestamp);
                xdrOS.pad();
            }
            this.ensureSize(this.baos);
            xdrOS.flush();
            this.buf = this.baos.toByteArray();
            this.baos.reset();
            logger.fine("Send buffer length: " + this.buf.length + "B");
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "", t);
            throw new ApMonException("Got General Exception while encoding:" + t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConfCheck() {
        boolean val;
        Object object = this.mutexBack;
        synchronized (object) {
            val = this.confCheck;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfRecheck(boolean confCheck, long interval) {
        int val = -1;
        if (confCheck) {
            logger.info("Enabling configuration reloading (interval " + interval + " s)");
        }
        Object object = this.mutexBack;
        synchronized (object) {
            if (this.initType == 3) {
                logger.warning("setConfRecheck(): no configuration file/URL to reload\n");
            } else {
                this.confCheck = confCheck;
                if (confCheck) {
                    if (interval > 0L) {
                        this.recheckInterval = interval;
                        this.crtRecheckInterval = interval;
                    } else {
                        this.recheckInterval = 600L;
                        this.crtRecheckInterval = 600L;
                    }
                    val = 1;
                } else if (!this.jobMonitoring && !this.sysMonitoring) {
                    val = 0;
                }
            }
        }
        if (val == 1) {
            this.setBackgroundThread(true);
            return;
        }
        if (val == 0) {
            this.setBackgroundThread(false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecheckInterval() {
        long val;
        Object object = this.mutexBack;
        synchronized (object) {
            val = this.recheckInterval;
        }
        return val;
    }

    public void setRecheckInterval(long val) {
        if (val > 0L) {
            this.setConfRecheck(true, val);
        } else {
            this.setConfRecheck(false, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCrtRecheckInterval() {
        long val;
        Object object = this.mutexBack;
        synchronized (object) {
            val = this.crtRecheckInterval;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCrtRecheckInterval(long val) {
        Object object = this.mutexBack;
        synchronized (object) {
            this.crtRecheckInterval = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJobMonitoring(boolean jobMonitoring, long interval) {
        int val = -1;
        if (jobMonitoring) {
            logger.info("Enabling job monitoring, time interval " + interval + " s");
        } else {
            logger.info("Disabling job monitoring...");
        }
        Object object = this.mutexBack;
        synchronized (object) {
            this.jobMonitoring = jobMonitoring;
            this.jobMonChanged = true;
            if (jobMonitoring) {
                this.jobMonitorInterval = interval > 0L ? interval : 20L;
                val = 1;
            } else if (!this.sysMonitoring && !this.confCheck) {
                val = 0;
            }
        }
        if (val == 1) {
            this.setBackgroundThread(true);
            return;
        }
        if (val == 0) {
            this.setBackgroundThread(false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getJobMonitorInterval() {
        long val;
        Object object = this.mutexBack;
        synchronized (object) {
            val = this.jobMonitorInterval;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJobMonitoring() {
        boolean val;
        Object object = this.mutexBack;
        synchronized (object) {
            val = this.jobMonitoring;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSysMonitoring(boolean sysMonitoring, long interval) {
        int val = -1;
        if (sysMonitoring) {
            logger.info("Enabling system monitoring, time interval " + interval + " s");
        } else {
            logger.info("Disabling system monitoring...");
        }
        Object object = this.mutexBack;
        synchronized (object) {
            this.sysMonitoring = sysMonitoring;
            this.sysMonChanged = true;
            if (sysMonitoring) {
                this.sysMonitorInterval = interval > 0L ? interval : 20L;
                val = 1;
            } else if (!this.jobMonitoring && !this.confCheck) {
                val = 0;
            }
        }
        if (val == 1) {
            this.setBackgroundThread(true);
            return;
        }
        if (val == 0) {
            this.setBackgroundThread(false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSysMonitorInterval() {
        long val;
        Object object = this.mutexBack;
        synchronized (object) {
            val = this.sysMonitorInterval;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSysMonitoring() {
        boolean val;
        Object object = this.mutexBack;
        synchronized (object) {
            val = this.sysMonitoring;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenMonitoring(boolean genMonitoring, int nIntervals) {
        logger.info("Setting general information monitoring to " + genMonitoring);
        Object object = this.mutexBack;
        synchronized (object) {
            this.genMonitoring = genMonitoring;
            this.recheckChanged = true;
            if (genMonitoring) {
                this.genMonitorIntervals = nIntervals > 0 ? nIntervals : 100;
            }
        }
        if (genMonitoring && !this.sysMonitoring) {
            this.setSysMonitoring(true, 20L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getGenMonitoring() {
        boolean val;
        Object object = this.mutexBack;
        synchronized (object) {
            val = this.genMonitoring;
        }
        return val;
    }

    public Double getSystemParameter(String paramName) {
        if (this.bkThread == null) {
            logger.info("The background thread is not started - returning null");
            return null;
        }
        if (this.bkThread.monitor == null) {
            logger.info("No HostPropertiesMonitor defined - returning null");
            return null;
        }
        HashMap hms = this.bkThread.monitor.getHashParams();
        if (hms == null) {
            logger.info("No parameters map defined - returning null");
            return null;
        }
        Long paramId = (Long)ApMonMonitoringConstants.HT_SYS_NAMES_TO_CONSTANTS.get("sys_" + paramName);
        if (paramId == null) {
            logger.info("The parameter " + paramName + " does not exist.");
            return null;
        }
        String paramValue = (String)hms.get(paramId);
        double dVal = -1.0;
        try {
            dVal = Double.parseDouble(paramValue);
        }
        catch (Exception e) {
            logger.info("Could not obtain parameter value from the map: " + paramName);
            return null;
        }
        return new Double(dVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBackgroundThread(boolean val) {
        boolean stoppedThread = false;
        Object object = this.mutexCond;
        synchronized (object) {
            this.condChanged = false;
            if (val) {
                if (!this.bkThreadStarted) {
                    this.bkThreadStarted = true;
                    this.bkThread = new BkThread(this);
                    this.bkThread.start();
                } else {
                    this.condChanged = true;
                    this.mutexCond.notify();
                }
            }
            if (!val && this.bkThreadStarted) {
                this.bkThread.stopIt();
                this.condChanged = true;
                this.mutexCond.notify();
                stoppedThread = true;
                logger.info("[Stopping the thread for configuration reloading...]\n");
            }
        }
        if (stoppedThread) {
            try {
                this.bkThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bkThreadStarted = false;
        }
    }

    public void setMaxMsgRate(int maxRate) {
        this.maxMsgRate = maxRate;
    }

    public void stopIt() {
        if (this.bkThreadStarted && this.jobMonitoring) {
            logger.info("Sending last job monitoring packet...");
            this.bkThread.sendJobInfo();
        }
        this.dgramSocket.close();
        if (this.bkThread != null) {
            this.bkThread.monitor.stopIt();
        }
        this.setBackgroundThread(false);
    }

    void initMonitoring() {
        this.autoDisableMonitoring = true;
        this.sysMonitoring = false;
        this.jobMonitoring = false;
        this.genMonitoring = false;
        this.confCheck = false;
        this.recheckInterval = 600L;
        this.crtRecheckInterval = 600L;
        this.jobMonitorInterval = 20L;
        this.sysMonitorInterval = 20L;
        this.sysMonitorParams = 0L;
        this.sysMonitorParams |= 0x80L;
        this.sysMonitorParams |= 1L;
        this.sysMonitorParams |= 2L;
        this.sysMonitorParams |= 4L;
        this.sysMonitorParams |= 8L;
        this.sysMonitorParams |= 0x10L;
        this.sysMonitorParams |= 0x20L;
        this.sysMonitorParams |= 0x40L;
        this.sysMonitorParams |= 0x100L;
        this.sysMonitorParams |= 0x400L;
        this.sysMonitorParams |= 0x200L;
        this.sysMonitorParams |= 0x800L;
        this.sysMonitorParams |= 0x1000L;
        this.sysMonitorParams |= 0x2000L;
        this.sysMonitorParams |= 0x4000L;
        this.sysMonitorParams |= 0x80000L;
        this.sysMonitorParams |= 0x100000L;
        this.sysMonitorParams |= 0x200000L;
        this.sysMonitorParams |= 0x20000L;
        this.sysMonitorParams |= 0x10000L;
        this.sysMonitorParams |= 0x40000L;
        this.sysMonitorParams |= 0x8000L;
        this.sysMonitorParams |= 0x400000L;
        this.genMonitorParams = 0L;
        this.genMonitorParams |= 1L;
        this.genMonitorParams |= 2L;
        if (osName.indexOf("Linux") >= 0) {
            this.genMonitorParams |= 4L;
            this.genMonitorParams |= 8L;
            this.genMonitorParams |= 0x10L;
            this.genMonitorParams |= 0x20L;
            this.genMonitorParams |= 0x40L;
            this.genMonitorParams |= 0x80L;
            this.genMonitorParams |= 0x100L;
            this.genMonitorParams |= 0x200L;
            this.genMonitorParams |= 0x400L;
        }
        this.jobMonitorParams = 0L;
        this.jobMonitorParams |= 1L;
        this.jobMonitorParams |= 2L;
        this.jobMonitorParams |= 4L;
        this.jobMonitorParams |= 8L;
        this.jobMonitorParams |= 0x10L;
        this.jobMonitorParams |= 0x20L;
        this.jobMonitorParams |= 0x40L;
        this.jobMonitorParams |= 0x80L;
        this.jobMonitorParams |= 0x100L;
        this.jobMonitorParams |= 0x200L;
        this.jobMonitorParams |= 0x400L;
        this.jobMonitorParams |= 0x800L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseXApMonLine(String line) {
        boolean found;
        boolean flag = false;
        String tmp = line.replaceFirst("xApMon_", "");
        StringTokenizer st = new StringTokenizer(tmp, " \t=");
        String param = st.nextToken();
        String value = st.nextToken();
        if (value.equals("on")) {
            flag = true;
        }
        if (value.equals("off")) {
            flag = false;
        }
        Object object = this.mutexBack;
        synchronized (object) {
            found = false;
            if (param.equals("job_monitoring")) {
                this.jobMonitoring = flag;
                found = true;
            }
            if (param.equals("sys_monitoring")) {
                this.sysMonitoring = flag;
                found = true;
            }
            if (param.equals("job_interval")) {
                this.jobMonitorInterval = Long.parseLong(value);
                found = true;
            }
            if (param.equals("sys_interval")) {
                this.sysMonitorInterval = Long.parseLong(value);
                found = true;
            }
            if (param.equals("general_info")) {
                this.genMonitoring = flag;
                found = true;
            }
            if (param.equals("conf_recheck")) {
                this.confCheck = flag;
                found = true;
            }
            if (param.equals("recheck_interval")) {
                this.recheckInterval = this.crtRecheckInterval = Long.parseLong(value);
                found = true;
            }
            if (param.equals("maxMsgRate")) {
                this.maxMsgRate = Integer.parseInt(value);
                found = true;
            }
            if (param.equals("auto_disable")) {
                this.autoDisableMonitoring = flag;
                found = true;
            }
        }
        if (found) {
            return;
        }
        object = this.mutexBack;
        synchronized (object) {
            found = false;
            Long val = null;
            if (param.startsWith("sys")) {
                val = ApMonMonitoringConstants.getSysIdx(param);
                long lval = val;
                this.sysMonitorParams = flag ? (this.sysMonitorParams |= lval) : (this.sysMonitorParams &= lval ^ 0xFFFFFFFFFFFFFFFFL);
            } else if (param.startsWith("job")) {
                val = ApMonMonitoringConstants.getJobIdx(param);
                long lval = val;
                this.jobMonitorParams = flag ? (this.jobMonitorParams |= lval) : (this.jobMonitorParams &= lval ^ 0xFFFFFFFFFFFFFFFFL);
            }
            if (val == null) {
                logger.warning("Invalid parameter name in the configuration file: " + param);
            } else {
                found = true;
            }
        }
        if (!found) {
            logger.warning("Invalid parameter name in the configuration file: " + param);
        }
    }

    void setSenderRef(Hashtable s) {
        this.sender = s;
    }

    void initSenderRef() {
        this.sender.put("SEQ_NR", new Integer(0));
        this.sender.put("INSTANCE_ID", new Integer(new Random().nextInt(Integer.MAX_VALUE)));
    }

    void updateSEQ_NR() {
        Integer seq_nr = (Integer)this.sender.get("SEQ_NR");
        this.sender.put("SEQ_NR", new Integer((seq_nr + 1) % 2000000000));
    }

    String printParameters(Vector paramNames, Vector paramValues) {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < paramNames.size(); ++i) {
            String name = (String)paramNames.get(i);
            res.append(name).append(paramValues.get(i));
        }
        return res.toString();
    }

    public boolean shouldSend() {
        long now = new Date().getTime() / 1000L;
        if (now != this.crtTime) {
            this.prvSent = this.hWeight * this.prvSent + (1.0 - this.hWeight) * (double)this.crtSent / (double)(now - this.crtTime);
            this.prvTime = this.crtTime;
            logger.log(Level.FINE, "previously sent: " + this.crtSent + " dropped: " + this.crtDrop);
            this.crtTime = now;
            this.crtSent = 0L;
            this.crtDrop = 0L;
        }
        int valSent = (int)(this.prvSent * this.hWeight + (double)this.crtSent * (1.0 - this.hWeight));
        boolean doSend = true;
        int level = this.maxMsgRate - this.maxMsgRate / 10;
        if (valSent > this.maxMsgRate - level) {
            boolean bl = doSend = new Random().nextInt(this.maxMsgRate / 10) < this.maxMsgRate - valSent;
        }
        if (doSend) {
            ++this.crtSent;
        } else {
            ++this.crtDrop;
        }
        return doSend;
    }

    public String getMyHostname() {
        return this.myHostname;
    }

    static {
        block8: {
            osName = System.getProperty("os.name");
            logger = Logger.getLogger("apmon");
            mValueTypes = new HashMap();
            try {
                LogManager logManager = LogManager.getLogManager();
                if (logManager.getProperty("handlers") == null) {
                    try {
                        FileHandler fh = null;
                        try {
                            fh = new FileHandler("apmon.log");
                            fh.setFormatter(new SimpleFormatter());
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        logger.setUseParentHandlers(false);
                        logger.addHandler(fh);
                        logger.setLevel(Level.INFO);
                    }
                    catch (Throwable t) {
                        System.err.println("[ ApMon ] [ static init ] [ logging ] Unable to load default logger props. Cause:");
                        t.printStackTrace();
                    }
                    break block8;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "[ ApMon ] [ static init ] [ logging ] uses predefined logging properties");
                }
            }
            catch (Throwable t) {
                System.err.println("[ ApMon ] [ static init ] [ logging ] Unable to check/load default logger props. Cause:");
                t.printStackTrace();
            }
        }
        mValueTypes.put(String.class.getName(), new Integer(0));
        mValueTypes.put(Short.class.getName(), new Integer(2));
        mValueTypes.put(Integer.class.getName(), new Integer(2));
        mValueTypes.put(Float.class.getName(), new Integer(5));
        mValueTypes.put(Double.class.getName(), new Integer(5));
    }
}

