/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.net;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.TldPatterns;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class InternetDomainName {
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final Joiner DOT_JOINER = Joiner.on('.');
    private static final int NO_TLD_FOUND = -1;
    private static final String DOT_REGEX = "\\.";
    private final String name;
    private final ImmutableList<String> parts;
    private final int tldIndex;
    private static final String NORMAL_PART = "[A-Za-z0-9]([A-Za-z0-9_-]*[A-Za-z0-9])?";
    private static final String FINAL_PART = "[A-Za-z]([A-Za-z0-9_-]*[A-Za-z0-9])?";
    private static final int MAX_DOMAIN_PART_LENGTH = 63;

    private InternetDomainName(String name) {
        this.name = name;
        this.parts = ImmutableList.copyOf(DOT_SPLITTER.split(name));
        Preconditions.checkArgument(InternetDomainName.validateSyntax(this.parts), "Not a valid domain name: '%s'", name);
        this.tldIndex = this.findTld();
    }

    private InternetDomainName(List<String> parts) {
        Preconditions.checkArgument(!parts.isEmpty());
        this.parts = ImmutableList.copyOf(parts);
        this.name = DOT_JOINER.join(parts);
        this.tldIndex = this.findTld();
    }

    private int findTld() {
        int partsSize = this.parts.size();
        for (int i = 0; i < partsSize; ++i) {
            String ancestorName = DOT_JOINER.join(this.parts.subList(i, partsSize));
            if (!InternetDomainName.isTldInternal(ancestorName)) continue;
            return i;
        }
        return -1;
    }

    public static InternetDomainName from(String domain) {
        return new InternetDomainName(domain.toLowerCase());
    }

    private static boolean validateSyntax(List<String> parts) {
        int lastIndex = parts.size() - 1;
        if (!InternetDomainName.validatePart(parts.get(lastIndex), FINAL_PART)) {
            return false;
        }
        for (int i = 0; i < lastIndex; ++i) {
            String part = parts.get(i);
            if (InternetDomainName.validatePart(part, NORMAL_PART)) continue;
            return false;
        }
        return true;
    }

    private static boolean validatePart(String part, String pattern) {
        return part.length() <= 63 && part.matches(pattern);
    }

    public String name() {
        return this.name;
    }

    public ImmutableList<String> parts() {
        return this.parts;
    }

    public boolean isRecognizedTld() {
        return this.tldIndex == 0;
    }

    public boolean isUnderRecognizedTld() {
        return this.tldIndex > 0;
    }

    public boolean hasRecognizedTld() {
        return this.tldIndex != -1;
    }

    public InternetDomainName recognizedTld() {
        return this.hasRecognizedTld() ? this.ancestor(this.tldIndex) : null;
    }

    public boolean isImmediatelyUnderTld() {
        return this.tldIndex == 1;
    }

    public String rightmostNonTldPart() {
        return this.tldIndex >= 1 ? (String)this.parts.get(this.tldIndex - 1) : null;
    }

    public InternetDomainName topCookieDomain() {
        if (this.isImmediatelyUnderTld()) {
            return this;
        }
        if (!this.isUnderRecognizedTld()) {
            throw new IllegalStateException("Not under TLD: " + this.name);
        }
        return this.ancestor(this.tldIndex - 1);
    }

    public boolean hasParent() {
        return this.parts.size() > 1;
    }

    public InternetDomainName parent() {
        Preconditions.checkState(this.hasParent(), "Domain '%s' has no parent", this.name);
        return this.ancestor(1);
    }

    private InternetDomainName ancestor(int levels) {
        return new InternetDomainName(this.parts.subList(levels, this.parts.size()));
    }

    public InternetDomainName child(String leftParts) {
        Preconditions.checkNotNull(leftParts);
        return InternetDomainName.from(leftParts + "." + this.name);
    }

    public static boolean isValid(String name) {
        try {
            InternetDomainName.from(name);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isTldInternal(String domain) {
        return TldPatterns.EXACT.contains(domain) || !TldPatterns.EXCLUDED.contains(domain) && InternetDomainName.isSubTld(domain);
    }

    private static boolean isSubTld(String domain) {
        String[] pieces = domain.split(DOT_REGEX, 2);
        return pieces.length == 2 && TldPatterns.UNDER.contains(pieces[1]);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.name).toString();
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InternetDomainName) {
            InternetDomainName that = (InternetDomainName)object;
            return this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

