/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.hosts;

import com.sshtools.common.hosts.AbstractHostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleHostKeyVerification
extends AbstractHostKeyVerification {
    public ConsoleHostKeyVerification() throws InvalidHostFileException {
    }

    public ConsoleHostKeyVerification(String hostFile) throws InvalidHostFileException {
        super(hostFile);
    }

    @Override
    public void onDeniedHost(String hostname) {
        System.out.println("Access to the host " + hostname + " is denied from this system");
    }

    @Override
    public void onHostKeyMismatch(String host, String fingerprint, String actual) {
        try {
            System.out.println("The host key supplied by " + host + " is: " + actual);
            System.out.println("The current allowed key for " + host + " is: " + fingerprint);
            this.getResponse(host, actual);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onUnknownHost(String host, String fingerprint) {
        try {
            System.out.println("The host " + host + " is currently unknown to the system");
            System.out.println("The host key fingerprint is: " + fingerprint);
            this.getResponse(host, fingerprint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getResponse(String host, String fingerprint) throws InvalidHostFileException, IOException {
        String response = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (!(response.equalsIgnoreCase("YES") || response.equalsIgnoreCase("NO") || response.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable())) {
            String options;
            String string = options = this.isHostFileWriteable() ? "Yes|No|Always" : "Yes|No";
            if (!this.isHostFileWriteable()) {
                System.out.println("Always option disabled, host file is not writeable");
            }
            System.out.print("Do you want to allow this host key? [" + options + "]: ");
            response = reader.readLine();
        }
        if (response.equalsIgnoreCase("YES")) {
            this.allowHost(host, fingerprint, false);
        }
        if (response.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable()) {
            this.allowHost(host, fingerprint, true);
        }
    }
}

