/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PreferencesStore {
    protected static Log log = LogFactory.getLog(PreferencesStore.class);
    private static File file;
    private static boolean storeAvailable;
    private static Properties preferences;
    private static Properties userDefaults;
    private static Properties defaultPreferences;

    public static void saveTableMetrics(JTable table, String pref) {
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            int w = table.getColumnModel().getColumn(i).getWidth();
            PreferencesStore.put(pref + ".column." + i + ".width", String.valueOf(w));
            PreferencesStore.put(pref + ".column." + i + ".position", String.valueOf(table.convertColumnIndexToModel(i)));
        }
    }

    public static void restoreTableMetrics(JTable table, String pref, int[] defaultWidths) {
        if (table.getAutoResizeMode() != 0) {
            throw new IllegalArgumentException("Table AutoResizeMode must be JTable.AUTO_RESIZE_OFF");
        }
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            try {
                table.moveColumn(table.convertColumnIndexToView(PreferencesStore.getInt(pref + ".column." + i + ".position", i)), i);
                table.getColumnModel().getColumn(i).setPreferredWidth(PreferencesStore.getInt(pref + ".column." + i + ".width", defaultWidths == null ? table.getColumnModel().getColumn(i).getPreferredWidth() : defaultWidths[i]));
                continue;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
    }

    public static boolean isStoreAvailable() {
        return storeAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File file) {
        PreferencesStore.file = file;
        File dir = file.getParentFile();
        if (!dir.exists()) {
            log.info("Creating SSHTerm preferences directory " + dir.getAbsolutePath());
            if (!dir.mkdirs()) {
                log.error("Preferences directory " + dir.getAbsolutePath() + " could not be created. " + "Preferences will not be stored");
            }
        }
        storeAvailable = dir.exists();
        try {
            log.info("loading default.properties");
            InputStream is = PreferencesStore.class.getResourceAsStream("/default.properties");
            if (is != null) {
                defaultPreferences.load(is);
                is.close();
                log.info("loaded default.properties");
            } else {
                log.info("no default.properties");
            }
        }
        catch (IOException ioe) {
            log.error(ioe);
        }
        try {
            log.info("loading user defaults");
            File up = new File(dir, "GSI-SSHTerm_for_PRACE_EGI_LRZ.settings");
            FileInputStream is = new FileInputStream(up);
            if (is != null) {
                userDefaults.load(is);
                ((InputStream)is).close();
                log.info("loaded user defaults");
            } else {
                log.info("no user defaults");
            }
        }
        catch (IOException ioe) {
            log.warn("Could not load user defaults: " + ioe);
        }
        if (storeAvailable) {
            if (file.exists()) {
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    preferences.load(in);
                    storeAvailable = true;
                }
                catch (IOException ioe) {
                    log.error(ioe);
                }
                finally {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                PreferencesStore.savePreferences();
            }
        } else {
            log.warn("Preferences store not available.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePreferences() {
        if (file == null) {
            log.error("Preferences not saved as PreferencesStore has not been initialise.");
        } else {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                preferences.store(out, "SSHTerm preferences");
                log.info("Preferences written to " + file.getAbsolutePath());
                storeAvailable = true;
            }
            catch (IOException ioe) {
                log.error(ioe);
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static String get(String name, String def) {
        String a = preferences.getProperty(name, null);
        if (a == null) {
            a = userDefaults.getProperty(name, null);
        }
        if (a == null) {
            return defaultPreferences.getProperty(name, def);
        }
        return a;
    }

    public static String get(String name) {
        return PreferencesStore.get(name, null);
    }

    public static void put(String name, String val) {
        preferences.put(name, val);
    }

    public static Rectangle getRectangle(String name, Rectangle def) {
        String s = PreferencesStore.get(name);
        if (s == null || s.equals("")) {
            return def;
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        Rectangle r = new Rectangle();
        try {
            r.x = Integer.parseInt(st.nextToken());
            r.y = Integer.parseInt(st.nextToken());
            r.width = Integer.parseInt(st.nextToken());
            r.height = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException nfe) {
            log.warn("Preference is " + name + " is badly formatted", nfe);
        }
        return r;
    }

    public static void putRectangle(String name, Rectangle val) {
        preferences.put(name, val == null ? "" : val.x + "," + val.y + "," + val.width + "," + val.height);
    }

    public static int getInt(String name, int def) {
        String s = PreferencesStore.get(name);
        if (s != null && !s.equals("")) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                log.warn("Preference is " + name + " is badly formatted", nfe);
            }
        }
        return def;
    }

    public static double getDouble(String name, double def) {
        String s = PreferencesStore.get(name);
        if (s != null && !s.equals("")) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                log.warn("Preference is " + name + " is badly formatted", nfe);
            }
        }
        return def;
    }

    public static void putInt(String name, int val) {
        preferences.put(name, String.valueOf(val));
    }

    public static void putDouble(String name, double val) {
        preferences.put(name, String.valueOf(val));
    }

    public static boolean getBoolean(String name, boolean def) {
        return PreferencesStore.get(name, String.valueOf(def)).equals("true");
    }

    public static void putBoolean(String name, boolean val) {
        preferences.put(name, String.valueOf(val));
    }

    public static boolean preferenceExists(String name) {
        return preferences.containsKey(name) || defaultPreferences.containsKey(name) || userDefaults.containsKey(name);
    }

    public static boolean removePreference(String name) {
        boolean exists = PreferencesStore.preferenceExists(name);
        preferences.remove(name);
        return exists;
    }

    static {
        userDefaults = new Properties();
        preferences = new Properties();
        defaultPreferences = new Properties();
    }
}

