/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.authentication.AuthenticationDialog;
import com.sshtools.common.authentication.KBIRequestHandlerDialog;
import com.sshtools.common.authentication.PasswordAuthenticationDialog;
import com.sshtools.common.authentication.PasswordChange;
import com.sshtools.common.authentication.PublicKeyAuthenticationPrompt;
import com.sshtools.common.automate.RemoteIdentification;
import com.sshtools.common.automate.RemoteIdentificationException;
import com.sshtools.common.automate.RemoteIdentificationFactory;
import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.hosts.DialogKnownHostsKeyVerification;
import com.sshtools.common.ui.HostsTab;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionCallback;
import com.sshtools.common.ui.OptionsDialog;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshEventAdapter;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.agent.AgentAuthenticationClient;
import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.SshAgentClient;
import com.sshtools.j2ssh.authentication.GSSAPIKeyexAuthenticationClient;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.sshterm.emulation.TerminalEmulation;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.EOFException;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationClientPanel
extends SshToolsApplicationPanel {
    public static final String PREF_CONNECTION_FILE_DIRECTORY = "sshapps.connectionFile.directory";
    public static final int BANNER_TIMEOUT = 200;
    protected static AbstractKnownHostsKeyVerification ver;
    protected Log log = LogFactory.getLog(SshToolsApplicationClientPanel.class);
    protected HostKeyVerification hostKeyVerification;
    protected File currentConnectionFile;
    protected boolean needSave;
    protected SshToolsConnectionProfile currentConnectionProfile;
    protected FileFilter connectionFileFilter = new ConnectionFileFilter();
    protected SshClient ssh;
    protected TerminalEmulation emulation;
    protected Thread thread;

    public SshToolsApplicationClientPanel() {
    }

    public SshToolsApplicationClientPanel(LayoutManager mgr) {
        super(mgr);
    }

    public abstract SshToolsConnectionTab[] getAdditionalConnectionTabs();

    public HostKeyVerification getHostKeyVerification() {
        return this.hostKeyVerification;
    }

    public void setHostHostVerification(HostKeyVerification hostKeyVerification) {
        this.hostKeyVerification = hostKeyVerification;
    }

    @Override
    public void init(SshToolsApplication application) throws SshToolsApplicationException {
        super.init(application);
        try {
            ver = new DialogKnownHostsKeyVerification(this);
            this.setHostHostVerification(ver);
            if (ver.isHostFileWriteable()) {
                application.addAdditionalOptionsTab(new HostsTab(ver));
            }
        }
        catch (InvalidHostFileException uhfe) {
            this.log.warn("Host key verification will be DISABLED.", uhfe);
        }
    }

    public void editConnection() {
        JFileChooser fileDialog = new JFileChooser(PreferencesStore.get(PREF_CONNECTION_FILE_DIRECTORY, System.getProperty("sshtools.home", System.getProperty("user.home"))));
        fileDialog.setFileFilter(this.connectionFileFilter);
        int ret = fileDialog.showOpenDialog(this);
        if (ret == 0) {
            PreferencesStore.put(PREF_CONNECTION_FILE_DIRECTORY, fileDialog.getCurrentDirectory().getAbsolutePath());
            File f = fileDialog.getSelectedFile();
            SshToolsConnectionProfile p = new SshToolsConnectionProfile();
            try {
                p.open(f);
                if (this.editConnection(p)) {
                    this.saveConnection(false, f, p);
                }
            }
            catch (IOException ioe) {
                SshToolsApplicationClientPanel.showErrorMessage(this, "Failed to load connection profile.", "Error", ioe);
            }
        }
    }

    public SshToolsConnectionProfile newConnectionProfile(SshToolsConnectionProfile profile) {
        return SshToolsConnectionPanel.showConnectionDialog(this, profile, this.getAdditionalConnectionTabs());
    }

    public void open() {
        String prefsDir = super.getApplication().getApplicationPreferencesDirectory().getAbsolutePath();
        JFileChooser fileDialog = new JFileChooser(prefsDir);
        fileDialog.setFileFilter(this.connectionFileFilter);
        int ret = fileDialog.showOpenDialog(this);
        if (ret == 0) {
            PreferencesStore.put(PREF_CONNECTION_FILE_DIRECTORY, fileDialog.getCurrentDirectory().getAbsolutePath());
            File f = fileDialog.getSelectedFile();
            this.open(f);
        }
    }

    public void open(File f) {
        this.log.debug("Opening connection file " + f);
        if (this.isConnected()) {
            Option optNew = new Option("New", "New create a new window", 110);
            Option optClose = new Option("Close", "Close current connection", 108);
            Option optCancel = new Option("Cancel", "Cancel the opening of this connection", 99);
            OptionsDialog dialog = OptionsDialog.createOptionDialog(this, new Option[]{optNew, optClose, optCancel}, "You already have a connection open. Select\nClose to close the current connection, New\nto create a new terminal or Cancel to abort.", "Existing connection", optNew, null, UIManager.getIcon("OptionPane.warningIcon"));
            UIUtil.positionComponent(0, dialog);
            dialog.setVisible(true);
            Option opt = dialog.getSelectedOption();
            if (opt == null || opt == optCancel) {
                return;
            }
            if (opt == optNew) {
                try {
                    SshToolsApplicationContainer c = this.application.newContainer();
                    ((SshToolsApplicationClientPanel)c.getApplicationPanel()).open(f);
                    return;
                }
                catch (SshToolsApplicationException stae) {
                    this.log.error(stae);
                }
            } else {
                this.closeConnection(true);
            }
        }
        if (this.getApplication().getMRUModel() != null) {
            this.getApplication().getMRUModel().add(f);
        }
        if (f != null) {
            SshToolsConnectionProfile profile = new SshToolsConnectionProfile();
            try {
                profile.open(f.getAbsolutePath());
                this.setNeedSave(false);
                this.currentConnectionFile = f;
                this.connect(profile, false);
            }
            catch (InvalidProfileFileException fnfe) {
                this.showExceptionMessage(fnfe.getMessage(), "Open Connection");
            }
            catch (SshException e) {
                e.printStackTrace();
                this.showExceptionMessage("An unexpected error occured!", "Open Connection");
            }
        } else {
            this.showExceptionMessage("Invalid file specified", "Open Connection");
        }
    }

    public void connect(SshToolsConnectionProfile profile, boolean newProfile) {
        this.connect(profile, newProfile, null);
    }

    public void connect(SshToolsConnectionProfile profile, final boolean newProfile, final SshEventAdapter evt) {
        this.ssh = new SshClient();
        this.setCurrentConnectionProfile(profile);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SshToolsApplicationClientPanel.this.getStatusBar().setStatusText("Connecting");
                SshToolsApplicationClientPanel.this.getStatusBar().setHost(SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getHost(), SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getPort());
                SshToolsApplicationClientPanel.this.getStatusBar().setUser(SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getUsername());
                try {
                    SshToolsApplicationClientPanel.this.log.info("Connecting to " + SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getHost() + " as " + SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getUsername());
                    SshToolsConnectionProfile cProfile = SshToolsApplicationClientPanel.this.getCurrentConnectionProfile();
                    cProfile.setWindow(SshToolsApplicationClientPanel.this.getContainer().getWindow());
                    if (evt != null) {
                        SshToolsApplicationClientPanel.this.ssh.addEventHandler(evt);
                    }
                    SshToolsApplicationClientPanel.this.ssh.connect(cProfile, SshToolsApplicationClientPanel.this.getHostKeyVerification() == null ? new SinkHostKeyVerification() : SshToolsApplicationClientPanel.this.getHostKeyVerification());
                    try {
                        RemoteIdentification rid = RemoteIdentificationFactory.getInstance(SshToolsApplicationClientPanel.this.ssh.getServerId(), SshToolsApplicationClientPanel.this.ssh.getConnectionProperties().getHost());
                        SshToolsApplicationClientPanel.this.getStatusBar().setRemoteId(rid.getName(SshToolsApplicationClientPanel.this.ssh.getServerId()));
                    }
                    catch (RemoteIdentificationException ex) {
                        SshToolsApplicationClientPanel.this.getStatusBar().setRemoteId("Unknown");
                    }
                    if (SshToolsApplicationClientPanel.this.postConnection()) {
                        if (!SshToolsApplicationClientPanel.this.authenticateUser(newProfile)) {
                            SshToolsApplicationClientPanel.this.closeConnection(false);
                        } else {
                            SshToolsApplicationClientPanel.this.setAvailableActions();
                        }
                    }
                }
                catch (IOException sshe) {
                    if (!sshe.getMessage().equals("Canceled by user.")) {
                        sshe.printStackTrace();
                        SshToolsApplicationClientPanel.this.log.error("Thrown (IOException): " + sshe);
                        SshToolsApplicationClientPanel.this.showExceptionMessage("Connection Failed", sshe.getMessage() + "\nPlease check that the hostname and port are valid. \nIf you have specified a username, please ensure that you have an account with that username on the remote system.");
                    }
                    SshToolsApplicationClientPanel.this.ssh = null;
                    if (sshe.getMessage().indexOf("Canceled by user") < 0) {
                        // empty if block
                    }
                    SshToolsApplicationClientPanel.this.closeConnection(false);
                }
                catch (SecurityException se) {
                    SshToolsApplicationClientPanel.this.log.error("Thrown (SecurityException): " + se);
                    SshToolsApplicationClientPanel.this.ssh = null;
                    SshToolsApplicationPanel.showErrorMessage(SshToolsApplicationClientPanel.this, "Error", se);
                    SshToolsApplicationClientPanel.this.closeConnection(false);
                }
                catch (Throwable t) {
                    SshToolsApplicationClientPanel.this.log.error("Thrown (Thowable): " + t);
                    StringWriter sbw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sbw);
                    pw.println("Error: ");
                    t.printStackTrace(pw);
                    SshToolsApplicationClientPanel.this.log.error(sbw.toString());
                }
            }
        };
        this.thread = new SshThread(r, this.application.getApplicationName() + " connection", true);
        this.thread.start();
    }

    public void connect(SshClient ssh, SshToolsConnectionProfile profile) throws IOException {
        this.ssh = ssh;
        this.setCurrentConnectionProfile(profile);
        if (!ssh.isAuthenticated()) {
            this.authenticateUser(false);
        }
        this.authenticationComplete(false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean authenticateUser(boolean newProfile) throws IOException {
        try {
            int result = 1;
            boolean authenticated = false;
            List auths = SshAuthenticationClientFactory.getSupportedMethods();
            List supported = null;
            supported = this.ssh.getAvailableAuthMethods(this.getCurrentConnectionProfile().getUsername());
            if (supported == null) {
                throw new IOException("There are no authentication methods which both the server and client understand.\n Cannot connect.");
            }
            if (this.emulation != null) {
                OutputStream os = this.emulation.getTerminalOutputStream();
                String string = this.ssh.getAuthenticationBanner(200);
                try {
                    String[] lines = string.split("\r|\n", -1);
                    for (int i = 0; i < lines.length; ++i) {
                        byte[] bytes = lines[i].getBytes();
                        os.write(bytes, 0, bytes.length);
                        os.write("\r\n".getBytes(), 0, "\r\n".getBytes().length);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (supported.contains("gssapi-keyex")) {
                GSSAPIKeyexAuthenticationClient aa = new GSSAPIKeyexAuthenticationClient();
                aa.setProperties(this.getCurrentConnectionProfile());
                aa.setUsername(this.getCurrentConnectionProfile().getUsername());
                result = this.ssh.authenticate(aa, this.getCurrentConnectionProfile().getHost());
                if (result == 4) {
                    this.authenticationComplete(newProfile);
                    return true;
                }
            }
            if (supported.contains("publickey") && System.getProperty("sshtools.agent") != null) {
                try {
                    SshAgentClient agent = SshAgentClient.connectLocalAgent("SSHTerm", System.getProperty("sshtools.agent"));
                    AgentAuthenticationClient agentAuthenticationClient = new AgentAuthenticationClient();
                    agentAuthenticationClient.setAgent(agent);
                    agentAuthenticationClient.setUsername(this.getCurrentConnectionProfile().getUsername());
                    result = this.ssh.authenticate(agentAuthenticationClient, this.getCurrentConnectionProfile().getHost());
                    agent.close();
                }
                catch (AgentNotAvailableException ex) {
                    this.log.info("No agent was available for authentication");
                }
                if (result == 4) {
                    this.authenticationComplete(newProfile);
                    return true;
                }
            }
            ArrayList display = new ArrayList();
            Iterator iterator = supported.iterator();
            LinkedList allowed = new LinkedList();
            while (iterator.hasNext() && !authenticated) {
                Object obj = iterator.next();
                if (!auths.contains(obj)) continue;
                display.add(obj);
                allowed.add(obj);
            }
            Map authMethods = (Map)((HashMap)this.getCurrentConnectionProfile().getAuthenticationMethods()).clone();
            Iterator iterator2 = authMethods.entrySet().iterator();
            boolean completed = false;
            String msg = null;
            while (!completed && this.ssh.getConnectionState().getValue() != 5) {
                void var7_15;
                SshAuthenticationClient auth = null;
                if (var7_15.hasNext()) {
                    Object obj = var7_15.next();
                    if (obj instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)obj;
                        auth = (SshAuthenticationClient)entry.getValue();
                    } else {
                        if (!(obj instanceof String)) {
                            this.closeConnection(true);
                            throw new IOException("Iterator of Map or List of String expected");
                        }
                        auth = SshAuthenticationClientFactory.newInstance((String)obj, this.getCurrentConnectionProfile());
                        auth.setUsername(this.getCurrentConnectionProfile().getUsername());
                    }
                } else {
                    List selected = AuthenticationDialog.showAuthenticationDialog(this, display, msg == null ? "" : msg);
                    if (selected.size() <= 0) {
                        this.closeConnection(true);
                        return false;
                    }
                    Iterator iterator3 = selected.iterator();
                }
                if (auth != null && !allowed.contains(auth.getMethodName())) {
                    auth = null;
                }
                if (auth == null) continue;
                try {
                    result = this.showAuthenticationPrompt(auth);
                }
                catch (IllegalArgumentException e) {
                    allowed.remove(auth);
                }
                if (result == 2) {
                    msg = auth.getMethodName() + " authentication failed, try again?";
                }
                if (result == 3) {
                    this.getCurrentConnectionProfile().addAuthenticationMethod(auth);
                    msg = auth.getMethodName() + " authentication succeeded but another is required";
                }
                if (result == 4) {
                    authenticated = true;
                    this.getCurrentConnectionProfile().addAuthenticationMethod(auth);
                    completed = true;
                    this.authenticationComplete(newProfile);
                }
                if (result != 5) continue;
                this.ssh.disconnect();
                return false;
            }
            return authenticated;
        }
        catch (EOFException e) {
            throw new IOException("The remote host has closed the connection.\n\nAs you are authenticating this probably means the server has given up authenticating you.");
        }
        catch (MessageStoreEOFException e) {
            throw new IOException("The remote host has closed the connection.\n\nAs you are authenticating this probably means the server has given up authenticating you.");
        }
    }

    protected int showAuthenticationPrompt(SshAuthenticationClient instance) throws IOException, IllegalArgumentException {
        instance.setUsername(this.getCurrentConnectionProfile().getUsername());
        if (instance instanceof PasswordAuthenticationClient) {
            PasswordAuthenticationDialog dialog = new PasswordAuthenticationDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this));
            instance.setAuthenticationPrompt(dialog);
            ((PasswordAuthenticationClient)instance).setPasswordChangePrompt(PasswordChange.getInstance());
            PasswordChange.getInstance().setParentComponent(this);
        } else if (instance instanceof PublicKeyAuthenticationClient) {
            PublicKeyAuthenticationPrompt prompt = new PublicKeyAuthenticationPrompt(this);
            instance.setAuthenticationPrompt(prompt);
        } else if (instance instanceof KBIAuthenticationClient) {
            KBIAuthenticationClient kbi = new KBIAuthenticationClient();
            ((KBIAuthenticationClient)instance).setKBIRequestHandler(new KBIRequestHandlerDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this)));
        }
        return this.ssh.authenticate(instance, this.getCurrentConnectionProfile().getHost());
    }

    public abstract boolean postConnection();

    public abstract void authenticationComplete(boolean var1) throws SshException, IOException;

    @Override
    public void setContainerTitle(String host) {
        String verString = ConfigurationLoader.getVersionString(this.application.getApplicationName(), this.application.getApplicationVersion());
        if (this.container != null) {
            this.container.setContainerTitle(host == null ? verString : verString + " [" + host + "]");
        }
    }

    public void setNeedSave(boolean needSave) {
        if (needSave != this.needSave) {
            this.needSave = needSave;
            this.setAvailableActions();
        }
    }

    public void setCurrentConnectionFile(File file) {
        this.currentConnectionFile = file;
    }

    public File getCurrentConnectionFile() {
        return this.currentConnectionFile;
    }

    public void setCurrentConnectionProfile(SshToolsConnectionProfile profile) {
        this.currentConnectionProfile = profile;
    }

    public SshToolsConnectionProfile getCurrentConnectionProfile() {
        return this.currentConnectionProfile;
    }

    public boolean isNeedSave() {
        return this.needSave;
    }

    @Override
    public boolean isConnected() {
        return this.ssh != null && this.ssh.isConnected();
    }

    public void connect() throws SshException {
        if (this.getCurrentConnectionProfile() == null) {
            throw new SshException("Can't connect, no connection profile have been set.");
        }
        this.connect(this.getCurrentConnectionProfile(), false);
    }

    public void closeConnection(boolean disconnect) {
        if (this.isNeedSave() && this.currentConnectionFile != null) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
                    if (JOptionPane.showConfirmDialog(this, "You have unsaved changes to the connection " + (this.currentConnectionFile == null ? "<Untitled>" : this.currentConnectionFile.getName()) + ".\nDo you want to save the changes now?", "Unsaved changes", 0, 3) == 0) {
                        this.saveConnection(false, this.getCurrentConnectionFile(), this.getCurrentConnectionProfile());
                        this.setNeedSave(false);
                    }
                }
            }
            catch (AccessControlException ace) {
                this.log.warn("Changes made to connection, but security manager won't allow saving of files.");
            }
        }
    }

    protected boolean allowConnectionSettingsEditing() {
        return true;
    }

    public boolean editConnection(SshToolsConnectionProfile profile) {
        final SshToolsConnectionPanel panel = new SshToolsConnectionPanel(this.allowConnectionSettingsEditing());
        SshToolsConnectionTab[] tabs = this.getAdditionalConnectionTabs();
        for (int i = 0; tabs != null && i < tabs.length; ++i) {
            tabs[i].setConnectionProfile(profile);
            panel.addTab(tabs[i]);
        }
        panel.setConnectionProfile(profile);
        final Option ok = new Option("Ok", "Apply the settings and close this dialog", 111);
        Option cancel = new Option("Cancel", "Close this dialog without applying the settings", 99);
        OptionCallback callback = new OptionCallback(){

            @Override
            public boolean canClose(OptionsDialog dialog, Option option) {
                if (option == ok) {
                    return panel.validateTabs();
                }
                return true;
            }
        };
        OptionsDialog od = OptionsDialog.createOptionDialog(this, new Option[]{ok, cancel}, panel, "Connection Settings", ok, callback, null);
        od.pack();
        UIUtil.positionComponent(0, od);
        od.setVisible(true);
        if (od.getSelectedOption() == ok) {
            panel.applyTabs();
            if (profile == this.getCurrentConnectionProfile()) {
                this.setNeedSave(true);
            }
            return true;
        }
        return false;
    }

    public File saveConnection(boolean saveAs, File file, SshToolsConnectionProfile profile) {
        if (profile != null) {
            if (file == null || saveAs) {
                String prefsDir = super.getApplication().getApplicationPreferencesDirectory().getAbsolutePath();
                JFileChooser fileDialog = new JFileChooser(prefsDir);
                fileDialog.setFileFilter(this.connectionFileFilter);
                int ret = fileDialog.showSaveDialog(this);
                if (ret == 1) {
                    return null;
                }
                file = fileDialog.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(file.getAbsolutePath() + ".xml");
                }
            }
            try {
                if (saveAs && file.exists() && JOptionPane.showConfirmDialog(this, "File already exists. Are you sure?", "File exists", 0, 2) == 1) {
                    return null;
                }
                if (file != null) {
                    this.log.debug("Saving connection to " + file.getAbsolutePath());
                    profile.save(file.getAbsolutePath());
                    if (profile == this.getCurrentConnectionProfile()) {
                        this.log.debug("Current connection saved, disabling save action.");
                        this.setNeedSave(false);
                    }
                    return file;
                }
                this.showExceptionMessage("The file specified is invalid!", "Save Connection");
            }
            catch (InvalidProfileFileException e) {
                this.showExceptionMessage(e.getMessage(), "Save Connection");
            }
        }
        return null;
    }

    class SinkHostKeyVerification
    implements HostKeyVerification {
        SinkHostKeyVerification() {
        }

        @Override
        public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
            SshToolsApplicationClientPanel.this.log.warn("Accepting host " + host + " as host key verification is disabled.");
            return true;
        }
    }

    class ConnectionFileFilter
    extends FileFilter {
        ConnectionFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return "Connection files (*.xml)";
        }
    }

    class MenuItemActionComparator
    implements Comparator {
        MenuItemActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("menuItemGroup")).compareTo((Integer)((StandardAction)o2).getValue("menuItemGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("menuItemWeight")).compareTo((Integer)((StandardAction)o2).getValue("menuItemWeight")) : i;
        }
    }

    class ToolBarActionComparator
    implements Comparator {
        ToolBarActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("toolBarGroup")).compareTo((Integer)((StandardAction)o2).getValue("toolBarGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("toolBarWeight")).compareTo((Integer)((StandardAction)o2).getValue("toolBarWeight")) : i;
        }
    }

    public static class ActionMenu
    implements Comparable {
        int weight;
        int mnemonic;
        String name;
        String displayName;

        public ActionMenu(String name, String displayName, int mnemonic, int weight) {
            this.name = name;
            this.displayName = displayName;
            this.mnemonic = mnemonic;
            this.weight = weight;
        }

        public int compareTo(Object o) {
            int i = new Integer(this.weight).compareTo(new Integer(((ActionMenu)o).weight));
            return i == 0 ? this.displayName.compareTo(((ActionMenu)o).displayName) : i;
        }
    }
}

