/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.vomanagementtool.VOAuthenticationDialogPrompt;
import com.sshtools.common.vomanagementtool.common.ConfigHelper;
import com.sshtools.common.vomanagementtool.common.VOHelper;
import com.sshtools.j2ssh.authentication.GridProxyInitPrompt;
import com.sshtools.j2ssh.authentication.MozillaPrompt;
import com.sshtools.j2ssh.authentication.MyProxyPrompt;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.sshterm.ProxyHelper;
import com.sshtools.sshterm.SshTerminalPanel;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import javax.security.auth.login.FailedLoginException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.commons.ssl.Util;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PasswordFinder;
import org.globus.common.CoGProperties;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.CertificateUtil;
import org.globus.myproxy.GetParams;
import org.globus.myproxy.MyProxy;
import org.globus.util.ConfigUtil;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import uk.ac.rl.esc.browser.Browser;

public class UserGridCredential {
    public static final String DEFAULT_MYPROXY_SERVER_K = "myproxy-sso.grid-support.ac.uk";
    public static final String DEFAULT_MYPROXY_SERVER = "myproxy.lrz.de";
    public static final String DEFAULT_MYPROXY_PORT_K = "7513";
    public static final String DEFAULT_MYPROXY_PORT = "7512";
    public static final String DEFAULT_MYPROXY_CACERT_URL = "https://winnetou.sara.nl/prace/certs/globuscerts.tar.gz";
    public static final String DEFAULT_VOMS_CONFIG_URL = "https://www.lrz.de/services/compute/grid_res/misc/voms/config.tar.gz";
    public static final String DEFAULT_VOMS_LOCATION = System.getProperty("user.home") + File.separator + ".glite";
    private static boolean SAVE_MYPROXY_PROXY = false;
    private static boolean SAVE_GRID_PROXY_INIT_PROXY = false;
    private static boolean SAVE_PKCS12_PROXY = false;
    private static boolean SAVE_BROWSER_PROXY = false;
    private static String MYPROXY_CACERT_URL = "https://winnetou.sara.nl/prace/certs/globuscerts.tar.gz";
    private static boolean SAVE_VOMS_PROXY = false;
    private static boolean VOMS_SUPPORT = false;
    private static String VOMS_CONFIG_URL = "https://www.lrz.de/services/compute/grid_res/misc/voms/config.tar.gz";
    private static String VOMS_LOCATION = DEFAULT_VOMS_LOCATION;
    private static int VOMSENABLE = 1;
    private static String paramGSSCredential = "";
    private static UserGridCredential thisDummy = new UserGridCredential();
    private static VOAuthenticationDialogPrompt voAuthPrompt;
    private static Log log;
    private static GridProxyInitPrompt gridProxyInitPrompt;
    private static MyProxyPrompt myProxyPrompt;

    private static void untar(InputStream in, String untarDir) throws IOException {
        TarArchiveInputStream tin = new TarArchiveInputStream(in);
        TarArchiveEntry entry = tin.getNextTarEntry();
        if (new File(untarDir).exists()) {
            while (entry != null) {
                if (!entry.isSymbolicLink()) {
                    File destPath = new File(untarDir + File.separatorChar + entry.getName());
                    if (!entry.isDirectory()) {
                        FileOutputStream fout = new FileOutputStream(destPath);
                        IOUtils.copy(tin, fout);
                        fout.close();
                    } else if (!destPath.exists()) {
                        destPath.mkdir();
                    }
                }
                entry = tin.getNextTarEntry();
            }
            tin = new TarArchiveInputStream(in);
            entry = tin.getNextTarEntry();
            while (entry != null) {
                if (entry.isSymbolicLink()) {
                    File srcPath = new File(untarDir + File.separatorChar + entry.getLinkName());
                    File destPath = new File(untarDir + File.separatorChar + entry.getName());
                    UserGridCredential.copyFile(srcPath, destPath);
                }
                entry = tin.getNextTarEntry();
            }
        } else {
            throw new IOException("Couldn't find directory: " + untarDir);
        }
        tin.close();
    }

    public static void checkVOMSConfigFiles() throws IOException {
        VOHelper.checkUpdateVOMSConfigFiles();
    }

    public static void checkCACertificates(CoGProperties cogproperties) throws IOException {
        String caCertLocations;
        File caCertLocationsF;
        String globusDir = System.getProperty("user.home") + "/.globus";
        if (!new File(globusDir).exists()) {
            boolean success = new File(globusDir).mkdir();
            if (!success) {
                throw new IOException("Couldn't create directory: " + globusDir);
            }
            try {
                UserGridCredential.Chmod(false, "755", globusDir);
            }
            catch (IOException ioe) {
                throw new IOException("Cannot change directory permission of " + globusDir + ".");
            }
        }
        if (!(caCertLocationsF = new File(caCertLocations = globusDir + "/certificates")).exists()) {
            boolean success = new File(caCertLocations).mkdir();
            if (!success) {
                throw new IOException("Couldn't create directory: " + caCertLocations);
            }
            try {
                UserGridCredential.Chmod(false, "744", caCertLocations);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, "Cannot change directory permission of " + caCertLocations + ".", "Automatic CA certificates update", 2);
            }
        }
        if (!caCertLocationsF.isDirectory()) {
            throw new IOException("Location: " + caCertLocations + " is not a directory");
        }
        String caCertURLString = PreferencesStore.get("sshterm.myproxy.cacert.url", MYPROXY_CACERT_URL);
        URL cacertURL = new URL(caCertURLString);
        try {
            GZIPInputStream in = new GZIPInputStream(cacertURL.openStream());
            UserGridCredential.untar(in, caCertLocations);
            UserGridCredential.Chmod(true, "go-w", caCertLocations);
        }
        catch (FileNotFoundException fnf) {
            JOptionPane.showMessageDialog(null, "Unable to download/update CA certificates. \nURL: " + caCertURLString + " does not exists. ", "Automatic CA certificates update", 2);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Unable to download/update CA certificates from " + cacertURL.getPath() + "\n" + ioe.getMessage(), "Automatic CA certificates update", 2);
        }
    }

    public static void Chmod(boolean recursive, String permission, String directoryFile) throws IOException {
        String osName = System.getProperty("os.name");
        String command = "chmod";
        if (recursive) {
            command = command + " -R";
        }
        if (osName.startsWith("Mac OS")) {
            Runtime.getRuntime().exec(command + " " + permission + " " + directoryFile);
        } else if (!osName.startsWith("Windows")) {
            Runtime.getRuntime().exec(command + " " + permission + " " + directoryFile);
        }
    }

    public static GSIConstants.CertificateType determineProxyType(int certType, String delegationType) {
        GSIConstants.CertificateType proxyType = GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY;
        if (certType == GSIConstants.CertificateType.GSI_2_PROXY.getCode()) {
            proxyType = delegationType.equals("full") ? GSIConstants.CertificateType.GSI_2_PROXY : (delegationType.equals("limited") ? GSIConstants.CertificateType.GSI_2_LIMITED_PROXY : GSIConstants.CertificateType.GSI_2_PROXY);
        } else if (certType == GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY.getCode()) {
            if (delegationType.equals("full")) {
                proxyType = GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY;
            } else if (delegationType.equals("limited")) {
                proxyType = GSIConstants.CertificateType.GSI_3_LIMITED_PROXY;
            } else if (delegationType.equals("none")) {
                proxyType = GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY;
            }
        } else if (delegationType.equals("full")) {
            proxyType = GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY;
        } else if (delegationType.equals("limited")) {
            proxyType = GSIConstants.CertificateType.GSI_4_LIMITED_PROXY;
        } else if (delegationType.equals("none")) {
            proxyType = GSIConstants.CertificateType.GSI_4_INDEPENDENT_PROXY;
        }
        return proxyType;
    }

    public static GSSCredential getUserCredential(SshConnectionProperties properties) throws Exception {
        CertificateUtil.init();
        SAVE_MYPROXY_PROXY = ((SshToolsConnectionProfile)properties).getApplicationPropertyBoolean("sshterm.proxy.save", SAVE_MYPROXY_PROXY);
        SAVE_GRID_PROXY_INIT_PROXY = ((SshToolsConnectionProfile)properties).getApplicationPropertyBoolean("sshterm.proxy.save", SAVE_GRID_PROXY_INIT_PROXY);
        SAVE_PKCS12_PROXY = ((SshToolsConnectionProfile)properties).getApplicationPropertyBoolean("sshterm.proxy.save", SAVE_PKCS12_PROXY);
        SAVE_BROWSER_PROXY = ((SshToolsConnectionProfile)properties).getApplicationPropertyBoolean("sshterm.proxy.save", SAVE_BROWSER_PROXY);
        MYPROXY_CACERT_URL = ((SshToolsConnectionProfile)properties).getApplicationProperty("sshterm.myproxy.cacert.url", MYPROXY_CACERT_URL);
        myProxyPrompt = MyProxyPrompt.getInstance();
        myProxyPrompt.setProperties(properties);
        gridProxyInitPrompt = GridProxyInitPrompt.getInstance();
        gridProxyInitPrompt.setTitle("Enter your grid certificate passphrase");
        CoGProperties cogproperties = CoGProperties.getDefault();
        UserGridCredential.checkCACertificates(cogproperties);
        GSIConstants.CertificateType proxyType = GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY;
        try {
            String cur = ((SshToolsConnectionProfile)properties).getApplicationProperty("sshterm.proxyType", Integer.toString(GSIConstants.CertificateType.GSI_4_IMPERSONATION_PROXY.getCode()));
            String delegationType = ((SshToolsConnectionProfile)properties).getApplicationProperty("sshterm.delegationType", "full");
            proxyType = UserGridCredential.determineProxyType(Integer.parseInt(cur), delegationType);
        }
        catch (Exception e) {
            throw new Error("Programming Error", e);
        }
        int lifetimeHours = 12;
        try {
            String cur = ((SshToolsConnectionProfile)properties).getApplicationProperty("sshterm.proxyLength", "12");
            lifetimeHours = Integer.parseInt(cur);
        }
        catch (Exception e) {
            throw new Error("Programming Error", e);
        }
        VOMS_SUPPORT = ((SshToolsConnectionProfile)properties).getApplicationPropertyBoolean("sshterm.voms.support", VOMS_SUPPORT);
        if (VOMS_SUPPORT) {
            VOMS_CONFIG_URL = ((SshToolsConnectionProfile)properties).getApplicationProperty("sshterm.voms.config.url", VOMS_CONFIG_URL);
            SAVE_VOMS_PROXY = ((SshToolsConnectionProfile)properties).getApplicationPropertyBoolean("sshterm.proxy.save", SAVE_VOMS_PROXY);
        }
        String order = PreferencesStore.get("sshterm.auth.order", "param,proxy,cert,other");
        if (properties instanceof SshToolsConnectionProfile) {
            SshToolsConnectionProfile profile = (SshToolsConnectionProfile)properties;
            order = profile.getApplicationProperty("sshterm.auth.order", order);
        }
        String[] meths = order.split("(,|\\s)");
        log.debug("Loading grid proxy - also save proxy depending on above flags.");
        GSSCredential gsscredential = null;
        while (gsscredential == null) {
            for (int i = 0; i < meths.length && gsscredential == null; ++i) {
                String m = meths[i];
                if (meths[i].equals("")) continue;
                if (meths[i].equals("proxy")) {
                    gsscredential = UserGridCredential.loadExistingProxy();
                    continue;
                }
                if (meths[i].equals("param")) {
                    gsscredential = UserGridCredential.loadProxyFromParam();
                    continue;
                }
                if (meths[i].equals("other")) {
                    gsscredential = UserGridCredential.retrieveRemoteProxy(properties, proxyType, lifetimeHours);
                    continue;
                }
                if (meths[i].equals("cert")) {
                    gsscredential = UserGridCredential.createProxy(proxyType, lifetimeHours, properties);
                    continue;
                }
                if (meths[i].equals("browser")) {
                    gsscredential = UserGridCredential.chooseCert(proxyType, lifetimeHours, properties);
                    continue;
                }
                if (meths[i].equals("krb")) {
                    gsscredential = UserGridCredential.saslProxy(properties, lifetimeHours);
                    continue;
                }
                JOptionPane.showMessageDialog(properties.getWindow(), "Method '" + meths[i] + "' is an unknown authentication method, skipping.", "GSI-SSHTerm Authentication", 0);
            }
        }
        if (VOMS_SUPPORT) {
            GSSCredential defensivecopy;
            GSIConstants.CertificateType curProxyType = ((GlobusGSSCredentialImpl)gsscredential).getX509Credential().getProxyType();
            if (curProxyType.equals((Object)GSIConstants.CertificateType.GSI_3_IMPERSONATION_PROXY) || curProxyType.equals((Object)GSIConstants.CertificateType.GSI_3_LIMITED_PROXY) || curProxyType.equals((Object)GSIConstants.CertificateType.GSI_3_INDEPENDENT_PROXY) || curProxyType.equals((Object)GSIConstants.CertificateType.GSI_3_RESTRICTED_PROXY)) {
                JOptionPane.showMessageDialog(null, "Pre-RFC Impersonation proxy is not supported.\nPlease change the selected 'Proxy Type:' in Advanced->Host.", "VOMS Error", 0);
                throw new IOException("VOMS generation failure. Unsupported GSI 3 proxy type.");
            }
            JLabel question = new JLabel("Authentication with VOs before logging in?");
            VOMSENABLE = JOptionPane.showConfirmDialog(null, question, "Enable VOMS ?", 0);
            if (VOMSENABLE == 0 && (defensivecopy = UserGridCredential.vomsEnable(gsscredential)) != null) {
                gsscredential = defensivecopy;
            }
        }
        return gsscredential;
    }

    public static GSSCredential vomsEnable(GSSCredential gsscredential) {
        GSSCredential useThisGSSCred = gsscredential;
        ConfigHelper.setGssCred(gsscredential);
        voAuthPrompt = VOAuthenticationDialogPrompt.getInstance();
        VOAuthenticationDialogPrompt.VOAuthenticationDialog dialog = voAuthPrompt.getVOMSAuthenticated();
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        UIUtil.positionComponent(0, dialog);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        return ConfigHelper.getVomsCredential();
    }

    private static void rmPass(StringBuffer password) {
        for (int i = 0; i < password.length(); ++i) {
            password.replace(i, i + 1, "*");
        }
        password = new StringBuffer();
    }

    private static GSSCredential chooseCert(GSIConstants.CertificateType proxyType, int lifetimeHours, SshConnectionProperties props) throws IOException, IllegalArgumentException, IllegalStateException {
        int ret;
        Object profile;
        String dProfile = PreferencesStore.get("sshterm.browser.profile", null);
        String dDN = PreferencesStore.get("sshterm.browser.dn", null);
        if (props instanceof SshToolsConnectionProfile) {
            profile = (SshToolsConnectionProfile)props;
            dProfile = ((SshToolsConnectionProfile)profile).getApplicationProperty("sshterm.browser.profile", dProfile);
            dDN = ((SshToolsConnectionProfile)profile).getApplicationProperty("sshterm.browser.dn", dDN);
        }
        if ((profile = Browser.getCurrentBrowser()) == null) {
            String[] profiles = Browser.getBrowserList();
            if (profiles == null) {
                return null;
            }
            if (profiles.length == 0) {
                JOptionPane.showMessageDialog(props.getWindow(), "No browsers found", "GSI-SSHTerm Authentication", 0);
                return null;
            }
            if (profiles.length == 1) {
                Browser.setBrowser(profiles[0]);
            } else {
                boolean chosen = false;
                if (dProfile != null) {
                    for (String p : profiles) {
                        if (!p.equals(dProfile)) continue;
                        chosen = true;
                        Browser.setBrowser(p);
                    }
                }
                if (!chosen) {
                    JComboBox<String> combo = new JComboBox<String>(profiles);
                    ret = JOptionPane.showOptionDialog(props.getWindow(), "Please choose browser to use:", "Grid Authentication", 0, 3, null, new Object[]{combo, "OK"}, null);
                    if (ret == -1) {
                        new IOException("Canceled by user.");
                    }
                    Browser.setBrowser(profiles[combo.getSelectedIndex()]);
                }
            }
            profile = Browser.getCurrentBrowser();
        }
        String[] dnlist = null;
        try {
            dnlist = Browser.getDNlist(new PasswordPrompt(props));
        }
        catch (IOException e) {
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not access keystore in profile: " + (String)profile, e);
            log.debug("Could not access keystore in profile: " + (String)profile + " : " + e);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not access keystore in profile: " + (String)profile, e);
            log.debug("Could not access keystore in profile: " + (String)profile + " : " + e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not access keystore in profile: " + (String)profile, e);
            log.debug("Could not access keystore in profile: " + (String)profile + " : " + e);
        }
        catch (CertificateException e) {
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not access keystore in profile: " + (String)profile, e);
            log.debug("Could not access keystore in profile: " + (String)profile + " : " + e);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not access keystore in profile: " + (String)profile, e);
            log.debug("Could not access keystore in profile: " + (String)profile + " : " + e);
        }
        catch (FailedLoginException e) {
            JOptionPane.showMessageDialog(props.getWindow(), e.getMessage(), "Incorrect Password", 0);
            return null;
        }
        catch (GeneralSecurityException e) {
            if (e.getMessage().indexOf("version>=1.5") >= 0) {
                JOptionPane.showMessageDialog(props.getWindow(), e.getMessage(), "GSI-SSHTerm Authentication", 0);
            }
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not access keystore in profile: " + (String)profile, e);
            log.debug("Could not access keystore in profile: " + (String)profile + " : " + e);
        }
        if (dnlist == null) {
            return null;
        }
        int index = -1;
        if (dnlist.length == 0) {
            return null;
        }
        if (dnlist.length == 1) {
            index = 0;
        } else {
            if (dDN != null) {
                for (int i = 0; i < dnlist.length; ++i) {
                    if (!dnlist[i].equals(dDN)) continue;
                    index = i;
                }
            }
            if (index == -1) {
                JComboBox<String> dnCombo = new JComboBox<String>(dnlist);
                ret = JOptionPane.showOptionDialog(props.getWindow(), "Please choose certificate to use:", "GSI-SSHTerm Authentication", 0, 3, null, new Object[]{dnCombo, "OK"}, null);
                if (ret == -1) {
                    new IOException("Canceled by user.");
                }
                index = dnCombo.getSelectedIndex();
            }
        }
        try {
            GSSCredential gssproxy = Browser.getGridProxy(dnlist[index], proxyType.getCode(), lifetimeHours);
            if (SAVE_BROWSER_PROXY) {
                X509Credential proxy = ((GlobusGSSCredentialImpl)gssproxy).getX509Credential();
                ProxyHelper.saveProxy(proxy, props);
            }
            return gssproxy;
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not load certificate from profile: " + (String)profile, e);
            log.debug("Could not load certificate from browser: " + e);
        }
        catch (GlobusCredentialException e) {
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not load certificate from profile: " + (String)profile, e);
            log.debug("Could not load certificate from browser: " + e);
        }
        catch (GSSException e) {
            e.printStackTrace();
            UserGridCredential.errorReport(props.getWindow(), "Could not load certificate from profile: " + (String)profile, e);
            log.debug("Could not load certificate from browser: " + e);
        }
        return null;
    }

    private static void errorReport(final Component comp, final String message, final Exception ex) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SshToolsApplicationPanel.showErrorMessage(comp, message, "GSI-SSHTerm Authentication", ex);
                }
            });
        }
        catch (Exception ex1) {
            log.info("Failed to invoke message box through SwingUtilities", ex1);
        }
    }

    private static GSSCredential createProxy(GSIConstants.CertificateType proxyType, int lifetimeHours, SshConnectionProperties props) throws IOException {
        GSSCredential gssCred = null;
        X509Credential x509Cred = null;
        CoGProperties cogproperties = CoGProperties.getDefault();
        String usercredP12Loc = System.getProperty("user.home") + System.getProperty("file.separator") + ".globus" + System.getProperty("file.separator") + "usercred.p12";
        if (new File(cogproperties.getUserKeyFile()).exists() && new File(cogproperties.getUserCertFile()).exists()) {
            while (x509Cred == null) {
                StringBuffer stringbuffer = new StringBuffer();
                boolean flag = gridProxyInitPrompt.getGridPassword(props.getWindow(), stringbuffer, "PEM");
                if (flag) {
                    throw new IOException("Canceled by user.");
                }
                if (gridProxyInitPrompt.getUseAnother()) {
                    return null;
                }
                try {
                    x509Cred = UserGridCredential.createProxy(stringbuffer.toString(), proxyType, lifetimeHours);
                }
                catch (Exception exception) {
                    UserGridCredential.errorReport(props.getWindow(), "Could not load your certificate", exception);
                    exception.printStackTrace();
                    StringWriter stringwriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringwriter));
                    log.debug(stringwriter);
                    gridProxyInitPrompt.setTitle(exception.getMessage());
                }
            }
            if (x509Cred != null) {
                if (SAVE_GRID_PROXY_INIT_PROXY) {
                    ProxyHelper.saveProxy(x509Cred, props);
                }
                try {
                    x509Cred.verify();
                    gssCred = new GlobusGSSCredentialImpl(x509Cred, 1);
                }
                catch (Exception exception1) {
                    exception1.printStackTrace();
                    StringWriter stringwriter1 = new StringWriter();
                    exception1.printStackTrace(new PrintWriter(stringwriter1));
                    log.debug(stringwriter1);
                    if (exception1.getMessage().indexOf("Expired credentials") >= 0) {
                        JOptionPane.showMessageDialog(props.getWindow(), "Your certificate has expired, please renew your certificate or try another method for authentication.", "GSI-SSHTerm Authentication", 0);
                        return null;
                    }
                    UserGridCredential.errorReport(props.getWindow(), "Could not load your certificate", exception1);
                    return null;
                }
            }
        } else if (new File(usercredP12Loc).exists()) {
            while (gssCred == null) {
                StringBuffer stringBufferPassphrase = new StringBuffer();
                boolean flag = gridProxyInitPrompt.getGridPassword(props.getWindow(), stringBufferPassphrase, "usercred.p12");
                if (flag) {
                    throw new IOException("Canceled by user.");
                }
                if (gridProxyInitPrompt.getUseAnother()) {
                    return null;
                }
                gssCred = UserGridCredential.createCredentialFromPKCS12(props, proxyType, lifetimeHours, new StringBuffer(usercredP12Loc), stringBufferPassphrase);
            }
        }
        return gssCred;
    }

    private static GSSCredential saslProxy(SshConnectionProperties properties, int lengthHours) throws IOException {
        return UserGridCredential.saslProxy(properties, null, lengthHours);
    }

    private static GSSCredential saslProxy(SshConnectionProperties properties, String password, int lengthHours) throws IOException {
        String hostname_k = DEFAULT_MYPROXY_SERVER_K;
        hostname_k = PreferencesStore.get("sshterm.krb5myproxy.hostname", hostname_k);
        String username = System.getProperty("user.name");
        String realm = System.getenv("USERDNSDOMAIN");
        String kdc = System.getenv("USERDNSDOMAIN");
        String port_S = DEFAULT_MYPROXY_PORT_K;
        boolean use = true;
        if (properties != null) {
            if (!(properties instanceof SshToolsConnectionProfile)) {
                return null;
            }
            SshToolsConnectionProfile profile = (SshToolsConnectionProfile)properties;
            hostname_k = profile.getApplicationProperty("sshterm.krb5myproxy.hostname", hostname_k);
            username = profile.getApplicationProperty("sshterm.krb5myproxy.username", username);
            realm = profile.getApplicationProperty("sshterm.krb5myproxy.relam", realm);
            kdc = profile.getApplicationProperty("sshterm.krb5myproxy.kdc", kdc);
            use = profile.getApplicationPropertyBoolean("sshterm.krb5myproxy.enabled", use);
        }
        boolean bl = use = use && SshTerminalPanel.PREF_KRB5_MYPROXY_ENABLED;
        if (!use) {
            return null;
        }
        port_S = PreferencesStore.get("sshterm.krb5myproxy.port", port_S);
        int port = 7513;
        try {
            port = Integer.parseInt(port_S);
        }
        catch (NumberFormatException e) {
            log.warn("Could not parse the port number from defaults file (property namesshterm.krb5myproxy.port, property value= " + port_S + ").");
        }
        GSSCredential cred = null;
        CoGProperties cogproperties = CoGProperties.getDefault();
        MyProxy myproxy = new MyProxy(hostname_k, port);
        try {
            GetParams getRequest = new GetParams();
            getRequest.setUserName(username);
            getRequest.setLifetime(lengthHours * 3600);
            getRequest.setPassphrase(password);
            cred = myproxy.get(null, getRequest);
            if (SAVE_MYPROXY_PROXY) {
                X509Credential proxy = ((GlobusGSSCredentialImpl)cred).getX509Credential();
                ProxyHelper.saveProxy(proxy, properties);
            }
            log.debug("A proxy has been received for user " + username);
        }
        catch (IllegalArgumentException exception) {
            exception.printStackTrace();
            StringWriter stringwriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringwriter));
            log.debug(stringwriter);
            myProxyPrompt.setError("MyProxy: " + exception.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            StringWriter stringwriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringwriter));
            log.debug(stringwriter);
        }
        return cred;
    }

    private static GSSCredential retrieveRemoteProxy(SshConnectionProperties properties, GSIConstants.CertificateType proxyType, int lifetimeHours) throws IOException {
        Object x509Cred = null;
        GSSCredential gssCred = null;
        CoGProperties cogproperties = CoGProperties.getDefault();
        String myproxyHostname = DEFAULT_MYPROXY_SERVER;
        myproxyHostname = PreferencesStore.get("sshterm.myproxy.defaults.hostname", myproxyHostname);
        String username = System.getProperty("user.name");
        username = PreferencesStore.get("sshterm.myproxy.defaults.username", username);
        String voname = PreferencesStore.get("sshterm.myproxy.voname", "");
        if (properties instanceof SshToolsConnectionProfile) {
            SshToolsConnectionProfile profile = (SshToolsConnectionProfile)properties;
            myproxyHostname = profile.getApplicationProperty("sshterm.myproxy.defaults.hostname", myproxyHostname);
            username = profile.getApplicationProperty("sshterm.myproxy.defaults.username", username);
            voname = profile.getApplicationProperty("sshterm.myproxy.voname", voname);
        }
        while (true) {
            StringBuffer stringbuffer = new StringBuffer();
            StringBuffer stringbuffer1 = new StringBuffer();
            StringBuffer stringbuffer2 = new StringBuffer();
            StringBuffer stringbuffer3 = new StringBuffer();
            if (myProxyPrompt != null) {
                myProxyPrompt.setHost(myproxyHostname);
                myProxyPrompt.setAccountName(username);
                myProxyPrompt.setVOName(voname);
                boolean flag1 = myProxyPrompt.doGet(properties.getWindow(), stringbuffer, stringbuffer1, stringbuffer2, stringbuffer3);
                myProxyPrompt.setError("");
                if (flag1) {
                    throw new IOException("Canceled by user.");
                }
                if (myProxyPrompt.getAnother()) {
                    return null;
                }
                StringBuffer stringbufferF = new StringBuffer();
                StringBuffer stringbufferP = new StringBuffer();
                if (myProxyPrompt.getBrowser()) {
                    gssCred = UserGridCredential.chooseCert(proxyType, lifetimeHours, properties);
                    if (gssCred == null) continue;
                    return gssCred;
                }
                if (myProxyPrompt.keyBased(stringbufferF, stringbufferP)) {
                    gssCred = UserGridCredential.createCredentialFromPKCS12(properties, proxyType, lifetimeHours, stringbufferF, stringbufferP);
                    if (gssCred == null) continue;
                    return gssCred;
                }
            }
            if (!stringbuffer1.toString().equals(username)) {
                PreferencesStore.put("sshterm.myproxy.last.username", stringbuffer1.toString());
            }
            String port_S = DEFAULT_MYPROXY_PORT;
            port_S = PreferencesStore.get("sshterm.myproxy.defaults.port", port_S);
            if (properties instanceof SshToolsConnectionProfile) {
                SshToolsConnectionProfile profile = (SshToolsConnectionProfile)properties;
                port_S = profile.getApplicationProperty("sshterm.myproxy.defaults.port", port_S);
            }
            int port = 7512;
            try {
                port = Integer.parseInt(port_S);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse the port number from defaults file (property namesshterm.myproxy.defaults.port, property value= " + port_S + ").");
            }
            MyProxy myproxy = null;
            myproxy = new MyProxy(stringbuffer.toString(), port);
            try {
                GetParams getRequest = new GetParams();
                getRequest.setUserName(stringbuffer1.toString());
                getRequest.setLifetime(lifetimeHours * 3600);
                getRequest.setPassphrase(stringbuffer2.toString());
                String voName = stringbuffer3.toString();
                if (voName != null && !voName.trim().equals("")) {
                    ArrayList<String> vonames = new ArrayList<String>();
                    vonames.add(voName);
                    getRequest.setVoname(vonames);
                }
                gssCred = myproxy.get(null, getRequest);
                if (SAVE_MYPROXY_PROXY) {
                    X509Credential downloadedProxy = ((GlobusGSSCredentialImpl)gssCred).getX509Credential();
                    ProxyHelper.saveProxy(downloadedProxy, properties);
                }
                log.debug("A proxy has been received for user " + stringbuffer1);
                return gssCred;
            }
            catch (Exception exception) {
                StringWriter stringwriter;
                if (exception.getMessage().indexOf("Credentials do not exist") >= 0) {
                    exception.printStackTrace();
                    stringwriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringwriter));
                    log.debug(stringwriter);
                    myProxyPrompt.setError("MyProxy: No credentials on server (wrong username?)");
                    continue;
                }
                if (exception.getMessage().indexOf("Bad password") >= 0) {
                    exception.printStackTrace();
                    stringwriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringwriter));
                    log.debug(stringwriter);
                    myProxyPrompt.setError("MyProxy: Bad username and/or password");
                    continue;
                }
                if (exception.getMessage().indexOf("Failed to map username too DN via grid-mapfile CA failed to map user") >= 0) {
                    exception.printStackTrace();
                    stringwriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringwriter));
                    log.debug(stringwriter);
                    myProxyPrompt.setError("MyProxy: Bad username/password");
                    continue;
                }
                if (exception.getMessage().indexOf("PAM authentication failed") >= 0) {
                    exception.printStackTrace();
                    stringwriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringwriter));
                    log.debug(stringwriter);
                    myProxyPrompt.setError("MyProxy: Bad username/password");
                    continue;
                }
                if (exception.getMessage().indexOf("credentials have expired") >= 0) {
                    exception.printStackTrace();
                    stringwriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringwriter));
                    log.debug(stringwriter);
                    myProxyPrompt.setError("MyProxy: Credentials on server has expired");
                    continue;
                }
                if (exception.getMessage().indexOf(stringbuffer.toString()) >= 0) {
                    exception.printStackTrace();
                    stringwriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringwriter));
                    log.debug(stringwriter);
                    myProxyPrompt.setError("MyProxy: Could not connect to MyProxy server");
                    continue;
                }
                if (exception.getMessage().indexOf("Password must be at least 6 characters long") >= 0) {
                    exception.printStackTrace();
                    stringwriter = new StringWriter();
                    exception.printStackTrace(new PrintWriter(stringwriter));
                    log.debug(stringwriter);
                    myProxyPrompt.setError("MyProxy: Password must be at least 6 characters long.");
                    continue;
                }
                exception.printStackTrace();
                stringwriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringwriter));
                log.debug(stringwriter);
                UserGridCredential.errorReport(properties.getWindow(), "Unknown problem while accessing MyProxy", exception);
                continue;
            }
            break;
        }
    }

    public static void setParamGSSCredential(String gsscredential) {
        paramGSSCredential = gsscredential;
    }

    private static GSSCredential loadProxyFromParam() throws Exception {
        GlobusGSSCredentialImpl cred = null;
        X509Credential proxy = null;
        if (paramGSSCredential.length() > 0) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(paramGSSCredential.getBytes());
                proxy = new X509Credential(bais);
                cred = new GlobusGSSCredentialImpl(proxy, 1);
                proxy.verify();
            }
            catch (CredentialException ce) {
                throw new Exception("Credential from param is not a valid X509 credential.", ce);
            }
            catch (GSSException gsse) {
                throw new Exception("Credential from param cannot be verified", gsse);
            }
        }
        if (VOMS_SUPPORT && VOMSENABLE == 0) {
            return UserGridCredential.vomsEnable(cred);
        }
        return cred;
    }

    public static GSSCredential loadExistingProxy() throws Exception {
        GSSCredential cred = null;
        X509Credential proxy = null;
        String proxyLoc = ConfigUtil.discoverProxyLocation();
        try {
            if (!new File(proxyLoc).exists()) {
                return null;
            }
            proxy = new X509Credential(proxyLoc);
            proxy = new X509Credential(proxyLoc);
            cred = proxy.getProxyType().equals((Object)GSIConstants.CertificateType.EEC) ? UserGridCredential.createCredentialFromEndEntityProxy(proxyLoc, (int)Math.ceil(proxy.getTimeLeft() / 3600L)) : new GlobusGSSCredentialImpl(proxy, 1);
            proxy.verify();
        }
        catch (CredentialException ce) {
            if (proxy.getTimeLeft() <= 0L) {
                File file = new File(proxyLoc);
                file.delete();
                cred = null;
            }
            throw new Exception("Credential from proxy file '" + proxyLoc + "' is not a valid X509 credential.", ce);
        }
        catch (GSSException gsse) {
            throw new Exception("Credential from proxy file '" + proxyLoc + "' cannot be verified", gsse);
        }
        return cred;
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static void convertPEMTOPKCS12(String passphrase, String usercredP12Loc) throws Exception {
        CoGProperties props = CoGProperties.getDefault();
        X509Certificate userCert = CertificateLoadUtil.loadCertificate(props.getUserCertFile());
        FileInputStream in = new FileInputStream(props.getUserKeyFile());
        byte[] bytes = Util.streamToBytes(in);
        PKCS8Key key = new PKCS8Key(bytes, passphrase.toCharArray());
        byte[] decrypted = key.getDecryptedBytes();
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decrypted);
        PrivateKey userKey = null;
        if (key.isDSA()) {
            userKey = KeyFactory.getInstance("DSA").generatePrivate(spec);
        } else if (key.isRSA()) {
            userKey = KeyFactory.getInstance("RSA").generatePrivate(spec);
        }
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(null, passphrase.toCharArray());
        KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(passphrase.toCharArray());
        Certificate[] certChain = new Certificate[]{userCert};
        KeyStore.PrivateKeyEntry pkEntry = new KeyStore.PrivateKeyEntry(userKey, certChain);
        ks.setEntry("keypair", pkEntry, protParam);
        FileOutputStream fos = new FileOutputStream(usercredP12Loc);
        ks.store(fos, passphrase.toCharArray());
        fos.close();
        UserGridCredential.Chmod(false, "600", usercredP12Loc);
    }

    public static X509Credential createProxy(String passphrase, GSIConstants.CertificateType proxyType, int lifetimeHours) throws Exception {
        CoGProperties props = CoGProperties.getDefault();
        X509Certificate userCert = CertificateLoadUtil.loadCertificate(props.getUserCertFile());
        FileInputStream in = new FileInputStream(props.getUserKeyFile());
        byte[] bytes = Util.streamToBytes(in);
        PKCS8Key key = new PKCS8Key(bytes, passphrase.toCharArray());
        byte[] decrypted = key.getDecryptedBytes();
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decrypted);
        PrivateKey userKey = null;
        if (key.isDSA()) {
            userKey = KeyFactory.getInstance("DSA").generatePrivate(spec);
        } else if (key.isRSA()) {
            userKey = KeyFactory.getInstance("RSA").generatePrivate(spec);
        }
        BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
        int bits = 2048;
        return factory.createCredential(new X509Certificate[]{userCert}, userKey, bits, lifetimeHours * 3600, proxyType);
    }

    public static GSSCredential createCredentialFromPKCS12(SshConnectionProperties properties, GSIConstants.CertificateType proxyType, int lifetimeHours, StringBuffer stringbufferCredentialFile, StringBuffer stringbufferPassphrase) {
        GlobusGSSCredentialImpl cred = null;
        X509Credential proxy = null;
        String passphrase = stringbufferPassphrase.toString();
        File keyfile = new File(stringbufferCredentialFile.toString());
        Security.addProvider(new BouncyCastleProvider());
        try {
            KeyStore store = KeyStore.getInstance("PKCS12", "BC");
            FileInputStream in = new FileInputStream(keyfile);
            store.load(in, passphrase.toCharArray());
            Enumeration<String> enumeration = store.aliases();
            Key key = null;
            Certificate cert = null;
            if (!enumeration.hasMoreElements()) {
                JOptionPane.showMessageDialog(properties.getWindow(), "GSI Exception: Could not access your certificate: No certificates found in file '" + stringbufferCredentialFile.toString() + "'", "GSI-SSHTerm Authentication", 0);
                return null;
            }
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                key = store.getKey(alias, passphrase.toCharArray());
                if (key == null || !(key instanceof PrivateKey)) continue;
                cert = store.getCertificate(alias);
                break;
            }
            if (!(cert instanceof X509Certificate)) {
                JOptionPane.showMessageDialog(properties.getWindow(), "GSI Exception: Could not access your certificate: bad certificate type", "GSI-SSHTerm Authentication", 0);
                return null;
            }
            if (!(key instanceof PrivateKey)) {
                JOptionPane.showMessageDialog(properties.getWindow(), "GSI Exception: Could not access your certificate: bad key type", "GSI-SSHTerm Authentication", 0);
                return null;
            }
            BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
            try {
                int bits = 2048;
                proxy = factory.createCredential(new X509Certificate[]{(X509Certificate)cert}, (PrivateKey)key, bits, lifetimeHours * 3600, proxyType);
                cred = new GlobusGSSCredentialImpl(proxy, 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(properties.getWindow(), "Failed to create a proxy:" + ex.getMessage(), "GSI-SSHTerm Authentication", 0);
                return null;
            }
            in.close();
        }
        catch (KeyStoreException e) {
            JOptionPane.showMessageDialog(properties.getWindow(), "Unable to get an instance type \"PKCS12\" in BouncyCastleProvider.\n" + e.getMessage(), "GSI-SSHTerm Authentication", 0);
            return null;
        }
        catch (NoSuchProviderException e) {
            JOptionPane.showMessageDialog(properties.getWindow(), "No such provider \"PKCS12\".\n" + e.getMessage(), "GSI-SSHTerm Authentication", 0);
            return null;
        }
        catch (IOException ioe) {
            if (ioe.getMessage().indexOf("Illegal key size") >= 0) {
                JOptionPane.showMessageDialog(properties.getWindow(), "GSI Exception: To use this PKCS#12 file you need to install the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files.", "GSI-SSHTerm Authentication", 0);
                return null;
            }
            JOptionPane.showMessageDialog(properties.getWindow(), "Wrong password or other security error", "GSI-SSHTerm Authentication", 0);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            JOptionPane.showMessageDialog(properties.getWindow(), "No Such Algorithm Error. \n" + e.getMessage(), "GSI-SSHTerm Authentication", 0);
            return null;
        }
        catch (CertificateException e) {
            JOptionPane.showMessageDialog(properties.getWindow(), "Certificate Exception in PKCS12 keystore. \n" + e.getMessage(), "GSI-SSHTerm Authentication", 0);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            JOptionPane.showMessageDialog(properties.getWindow(), "Unable to recover key with passphrase from PKCS12 keystore.\n" + e.getMessage(), "GSI-SSHTerm Authentication", 0);
            return null;
        }
        return cred;
    }

    private static GSSCredential createCredentialFromEndEntityProxy(String filename, int lifetimeHours) throws Exception {
        GlobusGSSCredentialImpl cred = null;
        X509Credential proxy = null;
        try {
            proxy = UserGridCredential.createX509CredentialFromEndEntityProxy(filename, lifetimeHours);
            cred = new GlobusGSSCredentialImpl(proxy, 1);
            System.out.println("Credential successfully created.");
        }
        catch (Exception e) {
            throw new Exception("Failed to create a proxy:" + e.getMessage());
        }
        return cred;
    }

    private static X509Credential createX509CredentialFromEndEntityProxy(String filename, int lifetimeHours) throws Exception {
        String line;
        X509Credential proxy = null;
        X509Certificate[] userCerts = null;
        PrivateKey userKey = null;
        String keyContent = "";
        String certContent = "";
        boolean isCertContent = false;
        boolean isKeyContent = false;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("-----") && line.contains("BEGIN") && line.contains("CERTIFICATE")) {
                certContent = certContent + line + "\n";
                isCertContent = true;
                continue;
            }
            if (line.startsWith("-----") && line.contains("END") && line.contains("CERTIFICATE")) {
                certContent = certContent + line + "\n";
                isCertContent = false;
            } else {
                if (line.startsWith("-----") && line.contains("BEGIN") && line.contains("PRIVATE") && line.contains("KEY")) {
                    keyContent = keyContent + line + "\n";
                    isKeyContent = true;
                    continue;
                }
                if (line.startsWith("-----") && line.contains("END") && line.contains("PRIVATE") && line.contains("KEY")) {
                    keyContent = keyContent + line + "\n";
                    isKeyContent = false;
                }
            }
            if (isCertContent) {
                certContent = certContent + line + "\n";
            }
            if (!isKeyContent) continue;
            keyContent = keyContent + line + "\n";
        }
        br.close();
        try {
            ByteArrayInputStream inKey = new ByteArrayInputStream(keyContent.getBytes());
            BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(inKey);
            userKey = key.getPrivateKey();
        }
        catch (IOException e) {
            throw new Exception("Error: Failed to load key", e);
        }
        try {
            ByteArrayInputStream inCert = new ByteArrayInputStream(certContent.getBytes());
            X509Certificate cert = CertificateLoadUtil.readCertificate(new BufferedReader(new StringReader(certContent)));
            userCerts = new X509Certificate[]{cert};
        }
        catch (IOException e) {
            throw new Exception("Error: Failed to load cert", e);
        }
        catch (GeneralSecurityException e) {
            throw new Exception("Error: Unable to load user certificate", e);
        }
        BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
        int bits = 2048;
        try {
            proxy = factory.createCredential(userCerts, userKey, bits, lifetimeHours * 3600, GSIConstants.DelegationType.FULL);
        }
        catch (Exception e) {
            throw new Exception("Failed to create a proxy:" + e.getMessage());
        }
        return proxy;
    }

    static {
        log = LogFactory.getLog(UserGridCredential.class);
    }

    private static class DefaultPasswordFinder
    implements PasswordFinder {
        private final char[] password;

        private DefaultPasswordFinder(char[] password) {
            this.password = password;
        }

        @Override
        public char[] getPassword() {
            return Arrays.copyOf(this.password, this.password.length);
        }
    }

    private static class PasswordPrompt
    implements Browser.PasswordCallback {
        final SshConnectionProperties properties;

        @Override
        public char[] prompt(String promptString) {
            StringBuffer passwordstringbuffer = new StringBuffer();
            boolean flag = MozillaPrompt.getInstance().getGridPassword(this.properties.getWindow(), passwordstringbuffer, "Mozilla/Firefox");
            if (flag) {
                return null;
            }
            char[] pass = passwordstringbuffer.toString().toCharArray();
            UserGridCredential.rmPass(passwordstringbuffer);
            return pass;
        }

        public PasswordPrompt(SshConnectionProperties properties) {
            this.properties = properties;
        }
    }
}

