/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingSocketX11Channel
extends ForwardingSocketChannel {
    private static Log log = LogFactory.getLog(ForwardingSocketX11Channel.class);
    private String authType;
    private String fakeAuthData;
    private String realAuthData;
    private boolean firstPacket = true;
    private byte[] dataSoFar = null;

    public ForwardingSocketX11Channel(String forwardType, String name, String hostToConnectOrBind, int portToConnectOrBind, String originatingHost, int originatingPort, String authType, String fakeAuthData, String realAuthData) throws ForwardingConfigurationException {
        super(forwardType, name, hostToConnectOrBind, portToConnectOrBind, originatingHost, originatingPort);
        this.authType = authType;
        this.fakeAuthData = fakeAuthData;
        this.realAuthData = realAuthData;
    }

    private boolean allDataCheckSubst() throws IOException {
        int dlen;
        int plen;
        if (this.dataSoFar.length < 12) {
            return false;
        }
        if (this.dataSoFar[0] == 66) {
            plen = 256 * this.dataSoFar[6] + this.dataSoFar[7];
            dlen = 256 * this.dataSoFar[8] + this.dataSoFar[9];
        } else if (this.dataSoFar[0] == 108) {
            plen = 256 * this.dataSoFar[7] + this.dataSoFar[6];
            dlen = 256 * this.dataSoFar[9] + this.dataSoFar[8];
        } else {
            throw new IOException("Bad initial X11 packet: bad byte order byte: " + this.dataSoFar[0]);
        }
        if (this.dataSoFar.length < 12 + (plen + 3 & 0xFFFFFFFC) + (dlen + 3 & 0xFFFFFFFC)) {
            return false;
        }
        if (plen != this.authType.length()) {
            throw new IOException("X11 connection uses different authentication protocol.");
        }
        if (!this.authType.equals(new String(this.dataSoFar, 12, plen, "US-ASCII"))) {
            throw new IOException("X11 connection uses different authentication protocol.");
        }
        if (this.fakeAuthData.length() != this.realAuthData.length()) {
            throw new IOException("fake and real X11 authentication data differ in length.");
        }
        int len = this.fakeAuthData.length() / 2;
        byte[] newdata = new byte[len];
        if (dlen != len) {
            throw new IOException("X11 connection used wrong authentication data.");
        }
        for (int i = 0; i < len; ++i) {
            byte data = (byte)Integer.parseInt(this.fakeAuthData.substring(i * 2, i * 2 + 2), 16);
            if (data != this.dataSoFar[i + (12 + (plen + 3 & 0xFFFFFFFC))]) {
                throw new IOException("X11 connection used wrong authentication data.");
            }
            newdata[i] = (byte)Integer.parseInt(this.realAuthData.substring(i * 2, i * 2 + 2), 16);
        }
        System.arraycopy(newdata, 0, this.dataSoFar, 12 + (plen + 3 & 0xFFFFFFFC), dlen);
        return true;
    }

    @Override
    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        if (this.firstPacket) {
            if (this.dataSoFar == null) {
                this.dataSoFar = msg.getChannelData();
            } else {
                byte[] newData = msg.getChannelData();
                byte[] data = new byte[this.dataSoFar.length + newData.length];
                System.arraycopy(this.dataSoFar, 0, data, 0, this.dataSoFar.length);
                System.arraycopy(newData, 0, data, this.dataSoFar.length, newData.length);
                this.dataSoFar = data;
            }
            if (this.allDataCheckSubst()) {
                this.firstPacket = false;
                this.socket.getOutputStream().write(this.dataSoFar);
            }
        } else {
            try {
                this.socket.getOutputStream().write(msg.getChannelData());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

