/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.kex.DhGroup1Sha1;
import com.sshtools.j2ssh.transport.kex.GssGroup1Sha1;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.util.encoders.Base64;
import org.globus.gsi.gssapi.GSSConstants;

public class SshKeyExchangeFactory {
    private static Map kexs;
    private static Map kexsNF;
    private static String defaultAlgorithm;
    private static String defaultAlgorithmNotFirst;
    private static Log log;

    protected SshKeyExchangeFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultKeyExchange() {
        return defaultAlgorithm;
    }

    public static String getDefaultKeyExchange(boolean firstExch) {
        if (firstExch) {
            return defaultAlgorithm;
        }
        return defaultAlgorithmNotFirst;
    }

    public static List getSupportedKeyExchanges() {
        return new ArrayList(kexs.keySet());
    }

    public static List getSupportedKeyExchanges(boolean firstExch) {
        if (firstExch) {
            return new ArrayList(kexs.keySet());
        }
        return new ArrayList(kexsNF.keySet());
    }

    public static SshKeyExchange newInstance(String methodName, SshConnectionProperties properties) throws AlgorithmNotSupportedException {
        try {
            SshKeyExchange n = (SshKeyExchange)((Class)kexs.get(methodName)).newInstance();
            n.setProperties(properties);
            return n;
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(methodName + " is not supported!");
        }
    }

    static {
        log = LogFactory.getLog(SshKeyExchangeFactory.class);
        kexs = new HashMap();
        kexsNF = new HashMap();
        log.info("Loading key exchange methods");
        defaultAlgorithm = "diffie-hellman-group1-sha1";
        defaultAlgorithmNotFirst = "diffie-hellman-group1-sha1";
        try {
            String hash = new String(Base64.encode(MessageDigest.getInstance("MD5").digest(GSSConstants.MECH_OID.getDER())), "US-ASCII");
            kexs.put("gss-group1-sha1-" + hash, GssGroup1Sha1.class);
            kexsNF.put("gss-group1-sha1-" + hash, GssGroup1Sha1.class);
            defaultAlgorithm = "gss-group1-sha1-" + hash;
            defaultAlgorithmNotFirst = "gss-group1-sha1-" + hash;
        }
        catch (Exception e) {
            log.warn("Could not load gss-group1-sha1-* encoding:\n" + e);
        }
        kexs.put("diffie-hellman-group1-sha1", DhGroup1Sha1.class);
        kexsNF.put("diffie-hellman-group1-sha1", DhGroup1Sha1.class);
    }
}

