/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.math.BigInteger;

public class SshMsgKexGssInit
extends SshMessage {
    protected static final int SSH_MSG_KEXGSS_INIT = 30;
    private BigInteger e;
    private byte[] token;

    public SshMsgKexGssInit(BigInteger e, byte[] token) {
        super(30);
        this.e = e;
        this.token = token;
    }

    public SshMsgKexGssInit() {
        super(30);
    }

    public BigInteger getE() {
        return this.e;
    }

    public byte[] getToken() {
        return this.token;
    }

    @Override
    public String getMessageName() {
        return "SSH_MSG_KEXGSS_INIT";
    }

    @Override
    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeBinaryString(this.token);
            baw.writeBigInteger(this.e);
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error writing message data: " + ioe.getMessage());
        }
    }

    @Override
    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.token = bar.readBinaryString();
            this.e = bar.readBigInteger();
        }
        catch (IOException ioe) {
            throw new InvalidMessageException("Error reading message data: " + ioe.getMessage());
        }
    }
}

