/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshterm;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.SshToolsApplicationApplet;
import com.sshtools.common.ui.SshToolsApplicationClientApplet;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.util.ShutdownHooks;
import com.sshtools.j2ssh.authentication.UserGridCredential;
import com.sshtools.sshterm.SshTerm;
import com.sshtools.sshterm.SshTerminalPanel;
import java.io.IOException;

public class SshTermApplet
extends SshToolsApplicationClientApplet {
    public static final String[][] SSHTERM_PARAMETER_INFO = new String[][]{{"sshterm.ui.scrollBar", "boolean", "Enable / Disable the menu bar"}, {"sshterm.ui.autoHide", "boolean", "Enable / Disable auto-hiding of the tool bar, menu bar, status bar and scroll bar"}, {"sshterm.gsscredential", "string", "String consisting of a proxy credential"}, {"sshterm.autoconnect.host", "string", "Connect to this host..."}, {"sshterm.autoconnect.port", "integer", "...on this port..."}, {"sshterm.autoconnect.username", "string", "...with this username."}};
    private boolean scrollBar;
    private boolean autoHide;

    @Override
    public void initApplet() throws IOException {
        super.initApplet();
        this.scrollBar = this.getParameter("sshterm.ui.scrollBar", "true").equals("true");
        this.autoHide = this.getParameter("sshterm.ui.autoHide", "false").equals("true");
        this.readGSSCredentialFromParam();
    }

    private void readGSSCredentialFromParam() {
        String gsscredential = this.getParameter("sshterm.gsscredential");
        if (gsscredential != null && gsscredential.length() > 0) {
            StringBuffer sb = new StringBuffer(gsscredential);
            String dashes = "-----";
            String newline = System.getProperty("line.separator");
            boolean foundOpeningDashes = false;
            int fromIndex = 0;
            while (fromIndex >= 0) {
                if ((fromIndex = sb.indexOf(dashes, fromIndex)) < 0) continue;
                if (foundOpeningDashes) {
                    sb.insert(fromIndex + dashes.length(), newline);
                } else if (fromIndex > 0) {
                    sb.insert(fromIndex, newline);
                }
                fromIndex += dashes.length();
                foundOpeningDashes = !foundOpeningDashes;
            }
            UserGridCredential.setParamGSSCredential(sb.toString());
        }
    }

    @Override
    public void stop() {
        ShutdownHooks.exit(false);
        this.applicationPanel.getApplication().exit(false);
    }

    @Override
    public String[][] getParameterInfo() {
        String[][] s = super.getParameterInfo();
        String[][] x = new String[s.length + SSHTERM_PARAMETER_INFO.length][];
        System.arraycopy(s, 0, x, 0, s.length);
        System.arraycopy(SSHTERM_PARAMETER_INFO, 0, x, s.length, SSHTERM_PARAMETER_INFO.length);
        return x;
    }

    @Override
    public String getAppletInfo() {
        return "SSHTerm";
    }

    @Override
    public SshToolsApplicationPanel createApplicationPanel() throws SshToolsApplicationException {
        SshTerm term = null;
        try {
            term = new SshTerm();
            term.init(new String[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SshToolsApplicationApplet.SshToolsApplicationAppletContainer container = new SshToolsApplicationApplet.SshToolsApplicationAppletContainer();
        term.newContainer(container);
        SshTerminalPanel panel = (SshTerminalPanel)container.getApplicationPanel();
        panel.setScrollBarVisible(this.scrollBar);
        panel.setAutoHideTools(this.autoHide);
        panel.setToolsVisible(true);
        this.autoConnect(panel);
        return panel;
    }

    public void autoConnect(SshTerminalPanel sshTP) {
        String host = this.getParameter("sshterm.autoconnect.host");
        String port = this.getParameter("sshterm.autoconnect.port");
        String username = this.getParameter("sshterm.autoconnect.username");
        if (host == null || port == null || username == null) {
            return;
        }
        SshToolsConnectionProfile p = new SshToolsConnectionProfile();
        p.setHost(host);
        p.setPort(Integer.valueOf(port));
        p.setUsername(username);
        sshTP.connect(p, true);
    }
}

