/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sshvnc;

import com.sshtools.common.configuration.XmlConfigurationContext;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.sshvnc.SshVNCFrame;
import com.sshtools.sshvnc.SshVNCPanel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JOptionPane;

public class SshVNC
extends SshToolsApplication {
    public static File PREF_DIR;

    public SshVNC() {
        super(SshVNCPanel.class, SshVNCFrame.class);
    }

    @Override
    public File getApplicationPreferencesDirectory() {
        return PREF_DIR;
    }

    @Override
    public String getApplicationName() {
        return "SSHVnc";
    }

    @Override
    public String getApplicationVersion() {
        return "sshvnc.properties";
    }

    @Override
    public Icon getApplicationLargeIcon() {
        return new ResourceIcon("/com/sshtools/shift/largeshift.png");
    }

    public OptionsTab[] getAdditionalOptionTabs() {
        return null;
    }

    @Override
    public String getAboutLicenseDetails() {
        return "SSHVnc is Licensed under the GPL (http://www.gnu.org/licenses)\n";
    }

    @Override
    public String getAboutURL() {
        return "http://www.sshtools.com";
    }

    @Override
    public String getAboutAuthors() {
        return "Lee David Painter\nRichard Pernavas\nBrett Smith";
    }

    public static final void main(String[] args) {
        try {
            if (System.getProperty("log4j.properties") != null) {
                try {
                    Properties properties = new Properties();
                    properties.load(ConfigurationLoader.loadFile(System.getProperty("log4j.properties")));
                    try {
                        Class<?> cls = Class.forName("org.apache.log4j.PropertyConfigurator");
                        Object obj = cls.newInstance();
                        Method method = cls.getMethod("configure", Properties.class);
                        method.invoke(obj, properties);
                    }
                    catch (Throwable ex) {
                    }
                }
                catch (IOException ex) {
                    SshVNC.configureBasicLogging();
                }
            } else {
                SshVNC.configureBasicLogging();
            }
            XmlConfigurationContext context = new XmlConfigurationContext();
            context.setAutomationConfigurationResource("automation.xml");
            context.setFailOnError(false);
            ConfigurationLoader.initialize(false, context);
            SshVNC sshvnc = new SshVNC();
            sshvnc.init(args);
            sshvnc.newContainer();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            System.exit(0);
        }
    }

    private static void configureBasicLogging() {
        try {
            Class<?> cls = Class.forName("org.apache.log4j.BasicConfigurator");
            Method method = cls.getMethod("configure", new Class[]{null});
            method.invoke(null, new Object[]{null});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        String val = ConfigurationLoader.checkAndGetProperty("user.home", null);
        if (val != null) {
            PREF_DIR = new File(val + File.separator + ".sshvnc");
        }
    }
}

