/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.common.ui.NumericTextField;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PortForwardEditorPane
extends JPanel
implements ActionListener {
    private static int id = 1000;
    private NumericTextField listenPortI;
    private NumericTextField destPortI;
    private NumericTextField listenPortO;
    private NumericTextField destPortO;
    private XTextField destHostI;
    private XTextField destHostO;
    private XTextField name;
    private JTabbedPane tabbedPane;
    private ForwardingConfiguration config;

    public PortForwardEditorPane() {
        super(new GridBagLayout());
        this.init();
    }

    public PortForwardEditorPane(ForwardingConfiguration config) {
        super(new GridBagLayout());
        this.config = config;
        this.init();
        this.name.setText(config.getName());
        if (config instanceof ForwardingClient.ClientForwardingListener) {
            this.tabbedPane.setSelectedIndex(1);
        } else {
            this.tabbedPane.setSelectedIndex(0);
        }
        this.listenPortI.setValue(new Integer(config.getPortToBind()));
        this.listenPortO.setValue(new Integer(config.getPortToBind()));
        this.destPortI.setValue(new Integer(config.getPortToConnect()));
        this.destPortO.setValue(new Integer(config.getPortToConnect()));
        this.destHostI.setText(config.getHostToConnect());
        this.destHostO.setText(config.getHostToConnect());
    }

    void init() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        Insets normal = new Insets(2, 2, 2, 2);
        Insets indented = new Insets(2, 26, 2, 2);
        gbc.insets = normal;
        gbc.fill = 2;
        gbc.weightx = 0.0;
        UIUtil.jGridBagAdd(this, new JLabel("Name "), gbc, -1);
        gbc.weightx = 1.0;
        this.name = new XTextField(this.getNextAutoId(), 10);
        UIUtil.jGridBagAdd(this, this.name, gbc, 0);
        this.tabbedPane = new JTabbedPane();
        JPanel pIncoming = new JPanel(new GridBagLayout());
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(pIncoming, new JLabel("Listening Port (remote server): "), gbc, -1);
        gbc.weightx = 0.0;
        this.listenPortI = new NumericTextField(new Integer(0), new Integer(65535), new Integer(0));
        UIUtil.jGridBagAdd(pIncoming, this.listenPortI, gbc, 0);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(pIncoming, new JLabel("Destination Host: "), gbc, -1);
        gbc.weightx = 0.0;
        this.destHostI = new XTextField("localhost", 10);
        UIUtil.jGridBagAdd(pIncoming, this.destHostI, gbc, 0);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(pIncoming, new JLabel("Destination Port: "), gbc, -1);
        gbc.weightx = 0.0;
        this.destPortI = new NumericTextField(new Integer(0), new Integer(65535), new Integer(0));
        UIUtil.jGridBagAdd(pIncoming, this.destPortI, gbc, 0);
        this.tabbedPane.addTab("Incoming", null, pIncoming, "Tunnel from remote host to local host");
        this.tabbedPane.setMnemonicAt(0, 73);
        JPanel pOutgoing = new JPanel(new GridBagLayout());
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(pOutgoing, new JLabel("Listening Port (local): "), gbc, -1);
        gbc.weightx = 0.0;
        this.listenPortO = new NumericTextField(new Integer(0), new Integer(65535), new Integer(0));
        UIUtil.jGridBagAdd(pOutgoing, this.listenPortO, gbc, 0);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(pOutgoing, new JLabel("Destination Host: "), gbc, -1);
        gbc.weightx = 0.0;
        this.destHostO = new XTextField("localhost", 10);
        UIUtil.jGridBagAdd(pOutgoing, this.destHostO, gbc, 0);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(pOutgoing, new JLabel("Destination Port: "), gbc, -1);
        gbc.weightx = 0.0;
        this.destPortO = new NumericTextField(new Integer(0), new Integer(65535), new Integer(0));
        UIUtil.jGridBagAdd(pOutgoing, this.destPortO, gbc, 0);
        this.tabbedPane.addTab("Outgoing", null, pOutgoing, "Tunnel from local host to remote host");
        this.tabbedPane.setMnemonicAt(1, 79);
        gbc.gridwidth = 2;
        UIUtil.jGridBagAdd(this, this.tabbedPane, gbc, 0);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
    }

    protected String getNextAutoId() {
        return "#".concat(String.valueOf(++id));
    }

    public boolean isLocal() {
        return this.tabbedPane.getSelectedIndex() == 1;
    }

    public boolean isRemote() {
        return this.tabbedPane.getSelectedIndex() == 0;
    }

    public String getForwardName() {
        return this.name.getText();
    }

    public int getLocalPort() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            return (Integer)this.listenPortI.getValue();
        }
        return (Integer)this.listenPortO.getValue();
    }

    public String getBindAddress() {
        return "127.0.0.1";
    }

    public int getRemotePort() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            return (Integer)this.destPortI.getValue();
        }
        return (Integer)this.destPortO.getValue();
    }

    public String getHost() {
        if (this.tabbedPane.getSelectedIndex() == 0) {
            return this.destHostI.getText();
        }
        return this.destHostO.getText();
    }
}

