/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.util.StartStopState;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class PortForwardingModel
extends AbstractTableModel {
    private Vector forwards = new Vector();
    private ForwardingClient client;

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return StartStopState.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    public void setClient(ForwardingClient client) {
        this.client = client;
        this.refresh();
    }

    public void refresh() {
        this.forwards.removeAllElements();
        if (this.client != null) {
            for (int it = 0; it < 3; ++it) {
                ForwardingConfiguration f;
                Map map = this.client.getLocalForwardings();
                for (String key : map.keySet()) {
                    f = (ForwardingConfiguration)map.get(key);
                    if (f.getState().getValue() == 1 && it == 0) {
                        this.forwards.addElement(map.get(key));
                    }
                    if (f.getState().getValue() == 2 && it == 1) {
                        this.forwards.addElement(map.get(key));
                    }
                    if (f.getState().getValue() != 3 || it != 2) continue;
                    this.forwards.addElement(map.get(key));
                }
                map = this.client.getRemoteForwardings();
                for (String key : map.keySet()) {
                    f = (ForwardingConfiguration)map.get(key);
                    if (f.getState().getValue() == 1 && it == 0) {
                        this.forwards.addElement(map.get(key));
                    }
                    if (f.getState().getValue() == 2 && it == 1) {
                        this.forwards.addElement(map.get(key));
                    }
                    if (f.getState().getValue() != 3 || it != 2) continue;
                    this.forwards.addElement(map.get(key));
                }
            }
            ForwardingConfiguration x11 = this.client.getX11ForwardingConfiguration();
            if (x11 != null) {
                this.forwards.addElement(x11);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int c) {
        switch (c) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Listening On";
            }
            case 4: {
                return "Forwarded To";
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.forwards.size();
    }

    public ForwardingConfiguration getForwardingConfigurationAt(int r) {
        return (ForwardingConfiguration)this.forwards.elementAt(r);
    }

    @Override
    public Object getValueAt(int r, int c) {
        ForwardingConfiguration conf = this.getForwardingConfigurationAt(r);
        switch (c) {
            case 0: {
                if (conf.getName().equals("x11")) {
                    return new StartStopState(1);
                }
                return conf.getState();
            }
            case 1: {
                return conf.getName();
            }
            case 2: {
                if (conf instanceof ForwardingClient.ClientForwardingListener) {
                    return "Outgoing";
                }
                return "Incoming";
            }
            case 3: {
                if (conf.getName().equals("x11")) {
                    return new String(":" + String.valueOf(conf.getPortToBind()));
                }
                if (conf instanceof ForwardingClient.ClientForwardingListener) {
                    return new String("local:" + String.valueOf(conf.getPortToBind()));
                }
                return new String("remote:" + String.valueOf(conf.getPortToBind()));
            }
            case 4: {
                return new String(conf.getHostToConnect() + ":" + String.valueOf(conf.getPortToConnect()));
            }
        }
        return null;
    }
}

