/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.tunnel;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.tunnel.TunnelEditorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

public class TunnelingPropertiesPanel
extends JPanel
implements SshToolsConnectionTab {
    static final int INCOMING = 0;
    static final int OUTGOING = 1;
    private SshToolsConnectionProfile profile = null;
    private TunnelsListPanel outgoingPanel = null;
    private TunnelsListPanel incomingPanel = null;
    private ResourceIcon icon = new ResourceIcon(TunnelingPropertiesPanel.class, "");
    private boolean initialized = false;
    private Vector outgoingTunnels = new Vector();
    private Vector incomingTunnels = new Vector();

    public TunnelingPropertiesPanel() {
        this.init();
    }

    public void init() {
        this.setLayout(new GridLayout(2, 1));
        this.outgoingPanel = new TunnelsListPanel(1, this.outgoingTunnels, "Outgoing tunnels");
        this.outgoingPanel.init();
        this.add(this.outgoingPanel);
        this.incomingPanel = new TunnelsListPanel(0, this.incomingTunnels, "Incoming tunnels");
        this.incomingPanel.init();
        this.add(this.incomingPanel);
        this.setPreferredSize(new Dimension(400, 300));
        this.initialized = true;
    }

    @Override
    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void refreshControls() {
        this.outgoingPanel.refreshControls();
        this.incomingPanel.refreshControls();
    }

    public void populateControls() {
        this.refreshControls();
    }

    public void populateProperties() {
    }

    public String validateProperties() {
        return null;
    }

    @Override
    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        this.outgoingTunnels.clear();
        this.incomingTunnels.clear();
        for (ForwardingConfiguration config : profile.getLocalForwardings().values()) {
            this.outgoingTunnels.add(config);
        }
        for (ForwardingConfiguration config : profile.getRemoteForwardings().values()) {
            this.incomingTunnels.add(config);
        }
    }

    @Override
    public SshToolsConnectionProfile getConnectionProfile() {
        return this.profile;
    }

    @Override
    public String getTabContext() {
        return "Options";
    }

    @Override
    public Icon getTabIcon() {
        return this.icon;
    }

    @Override
    public String getTabTitle() {
        return "Secure Tunneling";
    }

    @Override
    public String getTabToolTipText() {
        return "Here you may configure secure TCP/IP tunneling properties to allow you to make use of SSH port forwarding";
    }

    @Override
    public int getTabMnemonic() {
        return 116;
    }

    @Override
    public Component getTabComponent() {
        return this;
    }

    @Override
    public boolean validateTab() {
        return true;
    }

    @Override
    public void applyTab() {
        this.profile.setApplicationProperty("tunneling.configured", true);
        this.profile.removeAllForwardings();
        Iterator it = this.outgoingTunnels.iterator();
        while (it.hasNext()) {
            this.profile.addLocalForwarding((ForwardingConfiguration)it.next());
        }
        it = this.incomingTunnels.iterator();
        while (it.hasNext()) {
            this.profile.addRemoteForwarding((ForwardingConfiguration)it.next());
        }
    }

    @Override
    public void tabSelected() {
    }

    public class TunnelsListPanel
    extends JPanel {
        private int direction;
        private String stringDirection;
        private String title;
        private JTable tunnelTable;
        private List tunnels;
        JScrollPane tunnelScrollPane;
        JButton addBtn;
        JButton editBtn;
        JButton removeBtn;

        public TunnelsListPanel(int direction, List tunnels, String title) {
            this.direction = direction;
            this.tunnels = tunnels;
            this.stringDirection = direction == 1 ? "outgoing" : "incoming";
            this.title = title != null ? title : "Tunneling";
        }

        public void init() {
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), this.title));
            this.tunnelTable = new JTable(new TunnelsModel());
            TableColumnModel colModel = this.tunnelTable.getColumnModel();
            colModel.getColumn(0).setPreferredWidth(140);
            colModel.getColumn(1).setPreferredWidth(100);
            colModel.getColumn(2).setPreferredWidth(200);
            this.tunnelTable.setShowGrid(false);
            this.tunnelTable.setSelectionMode(0);
            this.tunnelTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    TunnelsListPanel.this.refreshButtons();
                }
            });
            this.tunnelTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        TunnelsListPanel.this.doEditBtn();
                    }
                }
            });
            this.tunnelScrollPane = new JScrollPane();
            this.tunnelScrollPane.getViewport().add((Component)this.tunnelTable, null);
            this.add((Component)this.tunnelScrollPane, "Center");
            JPanel eastPanel = new JPanel(){

                @Override
                public Insets getInsets() {
                    return new Insets(0, 5, 0, 0);
                }
            };
            eastPanel.setLayout(new BorderLayout());
            JPanel actionPanel = new JPanel();
            eastPanel.add((Component)actionPanel, "North");
            actionPanel.setLayout(new GridLayout(3, 1, 2, 2));
            this.addBtn = new JButton("Add...");
            this.addBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TunnelsListPanel.this.doAddBtn();
                }
            });
            actionPanel.add(this.addBtn);
            this.editBtn = new JButton("Edit...");
            this.editBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TunnelsListPanel.this.doEditBtn();
                }
            });
            actionPanel.add(this.editBtn);
            this.removeBtn = new JButton("Remove");
            this.removeBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TunnelsListPanel.this.doRemoveBtn();
                }
            });
            actionPanel.add(this.removeBtn);
            this.add((Component)eastPanel, "East");
            this.refreshButtons();
        }

        @Override
        public Insets getInsets() {
            return new Insets(20, 14, 14, 14);
        }

        public void refreshControls() {
            this.tunnelTable.updateUI();
            this.refreshButtons();
        }

        public void doAddBtn() {
            TunnelEditorPane editor = new TunnelEditorPane();
            editor.setMode(this.direction == 1);
            int option = JOptionPane.showConfirmDialog(this, editor, "Add " + (this.direction == 1 ? "Outgoing" : "Incoming") + " Tunnel", 2, 3);
            if (option != 2) {
                this.tunnels.add(new ForwardingConfiguration(editor.getForwardName(), editor.getAddressToBind(), editor.getPortToBind(), editor.getHostToConnect(), editor.getPortToConnect()));
                this.refreshControls();
            }
        }

        public void doEditBtn() {
            ForwardingConfiguration cf = this.getSelectedTunnel();
            TunnelEditorPane editor = new TunnelEditorPane();
            editor.setMode(this.direction == 1);
            editor.setForwardName(cf.getName());
            editor.setHostToConnect(cf.getHostToConnect());
            editor.setPortToConnect(cf.getPortToConnect());
            editor.setAddressToBind(cf.getAddressToBind());
            editor.setPortToBind(cf.getPortToBind());
            int option = JOptionPane.showConfirmDialog(this, editor, "Edit " + (this.direction == 1 ? "Outgoing" : "Incoming") + " Tunnel", 2, 3);
            if (option != 2) {
                this.tunnels.add(new ForwardingConfiguration(editor.getForwardName(), editor.getAddressToBind(), editor.getPortToBind(), editor.getHostToConnect(), editor.getPortToConnect()));
                this.refreshControls();
            }
        }

        public void doRemoveBtn() {
            int selectedRow = this.tunnelTable.getSelectedRow();
            this.tunnels.remove(this.getSelectedTunnel());
            this.tunnelTable.updateUI();
            this.tunnelTable.changeSelection(selectedRow - 1, 0, false, false);
            this.refreshButtons();
        }

        public ForwardingConfiguration getSelectedTunnel() {
            int selectedRow = this.tunnelTable.getSelectedRow();
            return (ForwardingConfiguration)this.tunnelTable.getModel().getValueAt(selectedRow, 3);
        }

        public void refreshButtons() {
            boolean hasRowSelected = this.tunnelTable.getSelectedRow() >= 0 && this.tunnelTable.getModel().getRowCount() > 0;
            this.editBtn.setEnabled(hasRowSelected);
            this.removeBtn.setEnabled(hasRowSelected);
        }

        private class TunnelsModel
        extends AbstractTableModel {
            final String[] columnNames = new String[]{"Name", "Listening on", "Forwarded to"};

            private TunnelsModel() {
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public int getRowCount() {
                return TunnelsListPanel.this.tunnels.size();
            }

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                ForwardingConfiguration fc = this.getTunnelAt(row);
                switch (col) {
                    case 0: {
                        return fc.getName();
                    }
                    case 1: {
                        return fc.getAddressToBind() + ":" + String.valueOf(fc.getPortToBind());
                    }
                    case 2: {
                        return fc.getHostToConnect() + ":" + fc.getPortToConnect();
                    }
                    case 3: {
                        return fc;
                    }
                }
                return null;
            }

            private ForwardingConfiguration getTunnelAt(int row) {
                return (ForwardingConfiguration)TunnelsListPanel.this.tunnels.get(row);
            }
        }
    }
}

