/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1Null;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1SequenceParser;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1StreamParser;
import edu.illinois.ncsa.bouncycastle.asn1.BERSequenceGenerator;
import edu.illinois.ncsa.bouncycastle.asn1.DEREncodable;
import edu.illinois.ncsa.bouncycastle.asn1.DERInteger;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DERSequenceGenerator;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ASN1SequenceParserTest
extends TestCase {
    private static final byte[] seqData = Hex.decode("3006020100060129");
    private static final byte[] nestedSeqData = Hex.decode("300b0201000601293003020101");
    private static final byte[] expTagSeqData = Hex.decode("a1083006020100060129");
    private static final byte[] implTagSeqData = Hex.decode("a106020100060129");
    private static final byte[] nestedSeqExpTagData = Hex.decode("300d020100060129a1053003020101");
    private static final byte[] nestedSeqImpTagData = Hex.decode("300b020100060129a103020101");
    private static final byte[] berSeqData = Hex.decode("30800201000601290000");
    private static final byte[] berDERNestedSeqData = Hex.decode("308002010006012930030201010000");
    private static final byte[] berNestedSeqData = Hex.decode("3080020100060129308002010100000000");
    private static final byte[] berExpTagSeqData = Hex.decode("a180308002010006012900000000");
    private static final byte[] berSeqWithDERNullData = Hex.decode("308005000201000601290000");

    public void testDERWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(byteArrayOutputStream);
        dERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        dERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        dERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"basic DER writing test failed.", (boolean)Arrays.equals(seqData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedDERWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(byteArrayOutputStream);
        dERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        dERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        DERSequenceGenerator dERSequenceGenerator2 = new DERSequenceGenerator(dERSequenceGenerator.getRawOutputStream());
        dERSequenceGenerator2.addObject(new DERInteger(BigInteger.valueOf(1L)));
        dERSequenceGenerator2.close();
        dERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"nested DER writing test failed.", (boolean)Arrays.equals(nestedSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testDERExplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(byteArrayOutputStream, 1, true);
        dERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        dERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        dERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"explicit tag writing test failed.", (boolean)Arrays.equals(expTagSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testDERImplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(byteArrayOutputStream, 1, false);
        dERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        dERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        dERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"implicit tag writing test failed.", (boolean)Arrays.equals(implTagSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedExplicitTagDERWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(byteArrayOutputStream);
        dERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        dERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        DERSequenceGenerator dERSequenceGenerator2 = new DERSequenceGenerator(dERSequenceGenerator.getRawOutputStream(), 1, true);
        dERSequenceGenerator2.addObject(new DERInteger(BigInteger.valueOf(1L)));
        dERSequenceGenerator2.close();
        dERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"nested explicit tagged DER writing test failed.", (boolean)Arrays.equals(nestedSeqExpTagData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedImplicitTagDERWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(byteArrayOutputStream);
        dERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        dERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        DERSequenceGenerator dERSequenceGenerator2 = new DERSequenceGenerator(dERSequenceGenerator.getRawOutputStream(), 1, false);
        dERSequenceGenerator2.addObject(new DERInteger(BigInteger.valueOf(1L)));
        dERSequenceGenerator2.close();
        dERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"nested implicit tagged DER writing test failed.", (boolean)Arrays.equals(nestedSeqImpTagData, byteArrayOutputStream.toByteArray()));
    }

    public void testBERWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(byteArrayOutputStream);
        bERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        bERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        bERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"basic BER writing test failed.", (boolean)Arrays.equals(berSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedBERDERWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(byteArrayOutputStream);
        bERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        bERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        DERSequenceGenerator dERSequenceGenerator = new DERSequenceGenerator(bERSequenceGenerator.getRawOutputStream());
        dERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(1L)));
        dERSequenceGenerator.close();
        bERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"nested BER/DER writing test failed.", (boolean)Arrays.equals(berDERNestedSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testNestedBERWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(byteArrayOutputStream);
        bERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        bERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream());
        bERSequenceGenerator2.addObject(new DERInteger(BigInteger.valueOf(1L)));
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"nested BER writing test failed.", (boolean)Arrays.equals(berNestedSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testDERReading() throws Exception {
        DEREncodable dEREncodable;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(seqData);
        ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)aSN1StreamParser.readObject();
        int n = 0;
        ASN1SequenceParserTest.assertNotNull((String)"null sequence returned", (Object)aSN1SequenceParser);
        while ((dEREncodable = aSN1SequenceParser.readObject()) != null) {
            switch (n) {
                case 0: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof DERInteger));
                    break;
                }
                case 1: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof DERObjectIdentifier));
                }
            }
            ++n;
        }
        ASN1SequenceParserTest.assertEquals((String)"wrong number of objects in sequence", (int)2, (int)n);
    }

    private void testNestedReading(byte[] byArray) throws Exception {
        DEREncodable dEREncodable;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(byArray);
        ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)aSN1StreamParser.readObject();
        int n = 0;
        ASN1SequenceParserTest.assertNotNull((String)"null sequence returned", (Object)aSN1SequenceParser);
        while ((dEREncodable = aSN1SequenceParser.readObject()) != null) {
            switch (n) {
                case 0: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof DERInteger));
                    break;
                }
                case 1: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof DERObjectIdentifier));
                    break;
                }
                case 2: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof ASN1SequenceParser));
                    ASN1SequenceParser aSN1SequenceParser2 = (ASN1SequenceParser)dEREncodable;
                    while (aSN1SequenceParser2.readObject() != null) {
                    }
                    break;
                }
            }
            ++n;
        }
        ASN1SequenceParserTest.assertEquals((String)"wrong number of objects in sequence", (int)3, (int)n);
    }

    public void testNestedDERReading() throws Exception {
        this.testNestedReading(nestedSeqData);
    }

    public void testBERReading() throws Exception {
        DEREncodable dEREncodable;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(berSeqData);
        ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)aSN1StreamParser.readObject();
        int n = 0;
        ASN1SequenceParserTest.assertNotNull((String)"null sequence returned", (Object)aSN1SequenceParser);
        while ((dEREncodable = aSN1SequenceParser.readObject()) != null) {
            switch (n) {
                case 0: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof DERInteger));
                    break;
                }
                case 1: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof DERObjectIdentifier));
                }
            }
            ++n;
        }
        ASN1SequenceParserTest.assertEquals((String)"wrong number of objects in sequence", (int)2, (int)n);
    }

    public void testNestedBERDERReading() throws Exception {
        this.testNestedReading(berDERNestedSeqData);
    }

    public void testNestedBERReading() throws Exception {
        this.testNestedReading(berNestedSeqData);
    }

    public void testBERExplicitTaggedSequenceWriting() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(byteArrayOutputStream, 1, true);
        bERSequenceGenerator.addObject(new DERInteger(BigInteger.valueOf(0L)));
        bERSequenceGenerator.addObject(new DERObjectIdentifier("1.1"));
        bERSequenceGenerator.close();
        ASN1SequenceParserTest.assertTrue((String)"explicit BER tag writing test failed.", (boolean)Arrays.equals(berExpTagSeqData, byteArrayOutputStream.toByteArray()));
    }

    public void testSequenceWithDERNullReading() throws Exception {
        this.testParseWithNull(berSeqWithDERNullData);
    }

    private void testParseWithNull(byte[] byArray) throws IOException {
        DEREncodable dEREncodable;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(byArray);
        ASN1SequenceParser aSN1SequenceParser = (ASN1SequenceParser)aSN1StreamParser.readObject();
        int n = 0;
        ASN1SequenceParserTest.assertNotNull((String)"null sequence returned", (Object)aSN1SequenceParser);
        while ((dEREncodable = aSN1SequenceParser.readObject()) != null) {
            switch (n) {
                case 0: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof ASN1Null));
                    break;
                }
                case 1: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof DERInteger));
                    break;
                }
                case 2: {
                    ASN1SequenceParserTest.assertTrue((boolean)(dEREncodable instanceof DERObjectIdentifier));
                }
            }
            ++n;
        }
        ASN1SequenceParserTest.assertEquals((String)"wrong number of objects in sequence", (int)3, (int)n);
    }

    public static Test suite() {
        return new TestSuite(ASN1SequenceParserTest.class);
    }
}

