/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1EncodableVector;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.DERSet;
import edu.illinois.ncsa.bouncycastle.asn1.cms.Attribute;
import edu.illinois.ncsa.bouncycastle.asn1.cms.AttributeTable;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.util.Hashtable;

public class AttributeTableUnitTest
extends SimpleTest {
    private static final DERObjectIdentifier type1 = new DERObjectIdentifier("1.1.1");
    private static final DERObjectIdentifier type2 = new DERObjectIdentifier("1.1.2");
    private static final DERObjectIdentifier type3 = new DERObjectIdentifier("1.1.3");

    public String getName() {
        return "AttributeTable";
    }

    public void performTest() throws Exception {
        Hashtable hashtable;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new Attribute(type1, new DERSet(type1)));
        aSN1EncodableVector2.add(new Attribute(type2, new DERSet(type2)));
        AttributeTable attributeTable = new AttributeTable(aSN1EncodableVector2);
        Attribute attribute = attributeTable.get(type1);
        if (attribute == null) {
            this.fail("type1 attribute not found.");
        }
        if (!attribute.getAttrValues().equals(new DERSet(type1))) {
            this.fail("wrong value retrieved for type1!");
        }
        if ((attribute = attributeTable.get(type2)) == null) {
            this.fail("type2 attribute not found.");
        }
        if (!attribute.getAttrValues().equals(new DERSet(type2))) {
            this.fail("wrong value retrieved for type2!");
        }
        if ((attribute = attributeTable.get(type3)) != null) {
            this.fail("type3 attribute found when none expected.");
        }
        if ((aSN1EncodableVector = attributeTable.getAll(type1)).size() != 1) {
            this.fail("wrong vector size for type1.");
        }
        if ((aSN1EncodableVector = attributeTable.getAll(type3)).size() != 0) {
            this.fail("wrong vector size for type3.");
        }
        if ((aSN1EncodableVector = attributeTable.toASN1EncodableVector()).size() != 2) {
            this.fail("wrong vector size for single.");
        }
        if ((hashtable = attributeTable.toHashtable()).size() != 2) {
            this.fail("hashtable wrong size.");
        }
        aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(new Attribute(type1, new DERSet(type1)));
        aSN1EncodableVector2.add(new Attribute(type1, new DERSet(type2)));
        aSN1EncodableVector2.add(new Attribute(type1, new DERSet(type3)));
        aSN1EncodableVector2.add(new Attribute(type2, new DERSet(type2)));
        attributeTable = new AttributeTable(aSN1EncodableVector2);
        attribute = attributeTable.get(type1);
        if (!attribute.getAttrValues().equals(new DERSet(type1))) {
            this.fail("wrong value retrieved for type1 multi get!");
        }
        if ((aSN1EncodableVector = attributeTable.getAll(type1)).size() != 3) {
            this.fail("wrong vector size for multiple type1.");
        }
        if (!(attribute = (Attribute)aSN1EncodableVector.get(0)).getAttrValues().equals(new DERSet(type1))) {
            this.fail("wrong value retrieved for type1(0)!");
        }
        if (!(attribute = (Attribute)aSN1EncodableVector.get(1)).getAttrValues().equals(new DERSet(type2))) {
            this.fail("wrong value retrieved for type1(1)!");
        }
        if (!(attribute = (Attribute)aSN1EncodableVector.get(2)).getAttrValues().equals(new DERSet(type3))) {
            this.fail("wrong value retrieved for type1(2)!");
        }
        if ((aSN1EncodableVector = attributeTable.getAll(type2)).size() != 1) {
            this.fail("wrong vector size for multiple type2.");
        }
        if ((aSN1EncodableVector = attributeTable.toASN1EncodableVector()).size() != 4) {
            this.fail("wrong vector size for multiple.");
        }
    }

    public static void main(String[] stringArray) {
        AttributeTableUnitTest.runTest(new AttributeTableUnitTest());
    }
}

