/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1Sequence;
import edu.illinois.ncsa.bouncycastle.asn1.DERObjectIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.ess.OtherCertID;
import edu.illinois.ncsa.bouncycastle.asn1.ess.OtherSigningCertificate;
import edu.illinois.ncsa.bouncycastle.asn1.test.ASN1UnitTest;
import edu.illinois.ncsa.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;

public class OtherSigningCertificateUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "OtherSigningCertificate";
    }

    public void performTest() throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.2.3"));
        byte[] byArray = new byte[20];
        OtherCertID otherCertID = new OtherCertID(algorithmIdentifier, byArray);
        OtherSigningCertificate otherSigningCertificate = new OtherSigningCertificate(otherCertID);
        this.checkConstruction(otherSigningCertificate, otherCertID);
        otherSigningCertificate = OtherSigningCertificate.getInstance(null);
        if (otherSigningCertificate != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            OtherCertID.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(OtherSigningCertificate otherSigningCertificate, OtherCertID otherCertID) throws IOException {
        this.checkValues(otherSigningCertificate, otherCertID);
        otherSigningCertificate = OtherSigningCertificate.getInstance(otherSigningCertificate);
        this.checkValues(otherSigningCertificate, otherCertID);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(otherSigningCertificate.toASN1Object().getEncoded());
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        otherSigningCertificate = OtherSigningCertificate.getInstance(aSN1Sequence);
        this.checkValues(otherSigningCertificate, otherCertID);
    }

    private void checkValues(OtherSigningCertificate otherSigningCertificate, OtherCertID otherCertID) {
        if (otherSigningCertificate.getCerts().length != 1) {
            this.fail("getCerts() length wrong");
        }
        this.checkMandatoryField("getCerts()[0]", otherCertID, otherSigningCertificate.getCerts()[0]);
    }

    public static void main(String[] stringArray) {
        OtherSigningCertificateUnitTest.runTest(new OtherSigningCertificateUnitTest());
    }
}

