/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.asn1.test;

import edu.illinois.ncsa.bouncycastle.asn1.ASN1InputStream;
import edu.illinois.ncsa.bouncycastle.asn1.ASN1OctetString;
import edu.illinois.ncsa.bouncycastle.asn1.DERObject;
import edu.illinois.ncsa.bouncycastle.asn1.DEROutputStream;
import edu.illinois.ncsa.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import edu.illinois.ncsa.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import edu.illinois.ncsa.bouncycastle.asn1.x509.AlgorithmIdentifier;
import edu.illinois.ncsa.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import edu.illinois.ncsa.bouncycastle.asn1.x9.X962NamedCurves;
import edu.illinois.ncsa.bouncycastle.asn1.x9.X962Parameters;
import edu.illinois.ncsa.bouncycastle.asn1.x9.X9ECParameters;
import edu.illinois.ncsa.bouncycastle.asn1.x9.X9ECPoint;
import edu.illinois.ncsa.bouncycastle.asn1.x9.X9IntegerConverter;
import edu.illinois.ncsa.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import edu.illinois.ncsa.bouncycastle.math.ec.ECFieldElement;
import edu.illinois.ncsa.bouncycastle.math.ec.ECPoint;
import edu.illinois.ncsa.bouncycastle.util.encoders.Base64;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class X9Test
extends SimpleTest {
    private byte[] namedPub = Base64.decode("MBowEwYHKoZIzj0CAQYIKoZIzj0DAQEDAwADAQ==");
    private byte[] expPub = Base64.decode("MIHfMIHXBgcqhkjOPQIBMIHLAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQEDAwADAQ==");
    private byte[] namedPriv = Base64.decode("MCICAQAwEwYHKoZIzj0CAQYIKoZIzj0DAQEECDAGAgEBBAEK");
    private byte[] expPriv = Base64.decode("MIHnAgEAMIHXBgcqhkjOPQIBMIHLAgEBMCkGByqGSM49AQECHn///////////////3///////4AAAAAAAH///////zBXBB5///////////////9///////+AAAAAAAB///////wEHiVXBfoqMGZUsfTLA9anUKMMJQEC1JiHF9m6FattPgMVAH1zdBaP/jRxtgqFdoahlHXTv6L/BB8DZ2iujhi7ks/PAFyUmqLG2UhT0OZgu/hUsclQX+laAh5///////////////9///+XXetBs6YFfDxDIUZSZVECAQEECDAGAgEBBAEU");

    private void encodePublicKey() throws Exception {
        ASN1InputStream aSN1InputStream;
        DERObject dERObject;
        ASN1OctetString aSN1OctetString;
        X962Parameters x962Parameters;
        SubjectPublicKeyInfo subjectPublicKeyInfo;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X9IntegerConverter x9IntegerConverter = new X9IntegerConverter();
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        if (x9IntegerConverter.getByteLength(x9ECParameters.getCurve()) != 30) {
            this.fail("wrong byte length reported for curve");
        }
        if (x9ECParameters.getCurve().getFieldSize() != 239) {
            this.fail("wrong field size reported for curve");
        }
        if (!this.areEqual((subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters = new X962Parameters(X9ObjectIdentifiers.prime192v1)), (aSN1OctetString = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(x9ECParameters.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)), true)).getDERObject()).getOctets())).getEncoded(), this.namedPub)) {
            this.fail("failed public named generation");
        }
        if (!subjectPublicKeyInfo.equals(dERObject = (aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.namedPub))).readObject())) {
            this.fail("failed public named equality");
        }
        if (!this.areEqual((subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters = new X962Parameters(x9ECParameters)), aSN1OctetString.getOctets())).getEncoded(), this.expPub)) {
            this.fail("failed public explicit generation");
        }
        if (!subjectPublicKeyInfo.equals(dERObject = (aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.expPub))).readObject())) {
            this.fail("failed public explicit equality");
        }
    }

    private void encodePrivateKey() throws Exception {
        ASN1InputStream aSN1InputStream;
        DERObject dERObject;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        X9ECParameters x9ECParameters = X962NamedCurves.getByOID(X9ObjectIdentifiers.prime239v3);
        X962Parameters x962Parameters = new X962Parameters(X9ObjectIdentifiers.prime192v1);
        ASN1OctetString aSN1OctetString = (ASN1OctetString)new X9ECPoint(new ECPoint.Fp(x9ECParameters.getCurve(), new ECFieldElement.Fp(BigInteger.valueOf(2L), BigInteger.valueOf(1L)), new ECFieldElement.Fp(BigInteger.valueOf(4L), BigInteger.valueOf(3L)), true)).getDERObject();
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), new ECPrivateKeyStructure(BigInteger.valueOf(10L)).getDERObject());
        if (!this.areEqual(privateKeyInfo.getEncoded(), this.namedPriv)) {
            this.fail("failed private named generation");
        }
        if (!privateKeyInfo.equals(dERObject = (aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.namedPriv))).readObject())) {
            this.fail("failed private named equality");
        }
        if (!this.areEqual((privateKeyInfo = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters = new X962Parameters(x9ECParameters)), new ECPrivateKeyStructure(BigInteger.valueOf(20L)).toASN1Object())).getEncoded(), this.expPriv)) {
            this.fail("failed private explicit generation");
        }
        if (!privateKeyInfo.equals(dERObject = (aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.expPriv))).readObject())) {
            this.fail("failed private explicit equality");
        }
    }

    public void performTest() throws Exception {
        this.encodePublicKey();
        this.encodePrivateKey();
    }

    public String getName() {
        return "X9";
    }

    public static void main(String[] stringArray) {
        X9Test.runTest(new X9Test());
    }
}

