/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.digests.SHA224Digest;
import edu.illinois.ncsa.bouncycastle.crypto.macs.HMac;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTestResult;
import edu.illinois.ncsa.bouncycastle.util.test.Test;
import edu.illinois.ncsa.bouncycastle.util.test.TestResult;

public class SHA224HMacTest
implements Test {
    static final String[] keys = new String[]{"0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b", "4a656665", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "0102030405060708090a0b0c0d0e0f10111213141516171819", "0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"};
    static final String[] digests = new String[]{"896fb1128abbdf196832107cd49df33f47b4b1169912ba4f53684b22", "a30e01098bc6dbbf45690f3a7e9e6d0f8bbea2a39e6148008fd05e44", "7fb3cb3588c6c1f6ffa9694d7d6ad2649365b0c1f65d69d1ec8333ea", "6c11506874013cac6a2abc1bb382627cec6a90d86efc012de7afec5a", "0e2aea68a90c8d37c988bcdb9fca6fa8099cd857c7ec4a1815cac54c", "95e9a0db962095adaebe9b2d6f0dbce2d499f112f2d2b7273fa6870e", "3a854166ac5d9f023f54d517d0b39dbd946770db9c2b95c9f6f565d1"};
    static final String[] messages = new String[]{"Hi There", "what do ya want for nothing?", "0xdddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd", "0xcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcdcd", "Test With Truncation", "Test Using Larger Than Block-Size Key - Hash Key First", "This is a test using a larger than block-size key and a larger than block-size data. The key needs to be hashed before being used by the HMAC algorithm."};

    public String getName() {
        return "SHA224HMac";
    }

    public TestResult perform() {
        byte[] byArray;
        int n;
        HMac hMac = new HMac(new SHA224Digest());
        byte[] byArray2 = new byte[hMac.getMacSize()];
        for (n = 0; n < messages.length; ++n) {
            byArray = messages[n].getBytes();
            if (messages[n].startsWith("0x")) {
                byArray = Hex.decode(messages[n].substring(2));
            }
            hMac.init(new KeyParameter(Hex.decode(keys[n])));
            hMac.update(byArray, 0, byArray.length);
            hMac.doFinal(byArray2, 0);
            if (Arrays.areEqual(byArray2, Hex.decode(digests[n]))) continue;
            return new SimpleTestResult(false, this.getName() + ": Vector " + n + " failed got -" + new String(Hex.encode(byArray2)));
        }
        n = 0;
        byArray = messages[n].getBytes();
        if (messages[n].startsWith("0x")) {
            byArray = Hex.decode(messages[n].substring(2));
        }
        hMac.init(new KeyParameter(Hex.decode(keys[n])));
        hMac.update(byArray, 0, byArray.length);
        hMac.doFinal(byArray2, 0);
        hMac.reset();
        hMac.update(byArray, 0, byArray.length);
        hMac.doFinal(byArray2, 0);
        if (!Arrays.areEqual(byArray2, Hex.decode(digests[n]))) {
            return new SimpleTestResult(false, this.getName() + "Reset with vector " + n + " failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        SHA224HMacTest sHA224HMacTest = new SHA224HMacTest();
        TestResult testResult = sHA224HMacTest.perform();
        System.out.println(testResult);
    }
}

