/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.test;

import edu.illinois.ncsa.bouncycastle.crypto.macs.VMPCMac;
import edu.illinois.ncsa.bouncycastle.crypto.params.KeyParameter;
import edu.illinois.ncsa.bouncycastle.crypto.params.ParametersWithIV;
import edu.illinois.ncsa.bouncycastle.util.Arrays;
import edu.illinois.ncsa.bouncycastle.util.encoders.Hex;
import edu.illinois.ncsa.bouncycastle.util.test.SimpleTest;

public class VMPCMacTest
extends SimpleTest {
    static byte[] output1 = Hex.decode("9BDA16E2AD0E284774A3ACBC8835A8326C11FAAD");

    public String getName() {
        return "VMPC-MAC";
    }

    public static void main(String[] stringArray) {
        VMPCMacTest.runTest(new VMPCMacTest());
    }

    public void performTest() throws Exception {
        KeyParameter keyParameter = new KeyParameter(Hex.decode("9661410AB797D8A9EB767C21172DF6C7"));
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, Hex.decode("4B5C2F003E67F39557A8D26F3DA2B155"));
        byte[] byArray = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = (byte)i;
        }
        VMPCMac vMPCMac = new VMPCMac();
        vMPCMac.init(parametersWithIV);
        vMPCMac.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[20];
        vMPCMac.doFinal(byArray2, 0);
        if (!Arrays.areEqual(byArray2, output1)) {
            this.fail("Fail", new String(Hex.encode(output1)), new String(Hex.encode(byArray2)));
        }
    }
}

