/*
 * Decompiled with CFR 0.152.
 */
package edu.illinois.ncsa.bouncycastle.crypto.tls;

import edu.illinois.ncsa.bouncycastle.crypto.tls.Certificate;
import edu.illinois.ncsa.bouncycastle.crypto.tls.CertificateRequest;
import edu.illinois.ncsa.bouncycastle.crypto.tls.CertificateVerifyer;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsAuthentication;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsCredentials;
import edu.illinois.ncsa.bouncycastle.crypto.tls.TlsFatalAlert;
import java.io.IOException;

public class LegacyTlsAuthentication
implements TlsAuthentication {
    protected CertificateVerifyer verifyer;

    public LegacyTlsAuthentication(CertificateVerifyer certificateVerifyer) {
        this.verifyer = certificateVerifyer;
    }

    public void notifyServerCertificate(Certificate certificate) throws IOException {
        if (!this.verifyer.isValid(certificate.getCerts())) {
            throw new TlsFatalAlert(90);
        }
    }

    public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
        return null;
    }
}

