/*
 * Decompiled with CFR 0.152.
 */
package lia.gsi.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.CredentialException;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.JaasGssUtil;
import org.globus.gsi.gssapi.auth.GSSAuthorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.jaas.GlobusPrincipal;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.gsi.gssapi.net.impl.GSIGssSocket;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class GSIGssSocketFactory
extends GssSocketFactory {
    private static final int GSI_CONNECT_TIMEOUT = Integer.getInteger("GSI_CONNECT_TIMEOUT", 20000);
    private static final Log logger = LogFactory.getLog(GSIGssSocketFactory.class.getName());

    public static Socket createSocket(InetAddress inetAddress, int port, boolean doDelegation, boolean fullDelegation) throws IOException {
        Socket socket = null;
        try {
            String x509UserProxy;
            String x509CertDir = System.getProperty("X509_CERT_DIR");
            if (x509CertDir == null) {
                x509CertDir = System.getenv("X509_CERT_DIR");
                if (x509CertDir == null) {
                    x509CertDir = "/etc/grid-security/certificates";
                }
                System.setProperty("X509_CERT_DIR", x509CertDir);
            }
            if ((x509UserProxy = System.getenv("X509_USER_PROXY")) == null) {
                x509UserProxy = CoGProperties.getDefault().getProxyFile();
            }
            System.out.println("Trying " + x509UserProxy);
            GSSCredential credential = GSIGssSocketFactory.createUserCredential(x509UserProxy);
            if (credential == null) {
                throw new IOException("User credential not initialized !");
            }
            logger.info("createSocket() user credential is " + credential.getName());
            GSSManager manager = ExtendedGSSManager.getInstance();
            HostAuthorization gssAuth = HostAuthorization.getInstance();
            GSSName targetName = ((GSSAuthorization)gssAuth).getExpectedName(null, inetAddress.getCanonicalHostName());
            ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(targetName, GSSConstants.MECH_OID, credential, 0);
            context.setOption(GSSConstants.GSS_MODE, GSIConstants.MODE_GSI);
            context.requestCredDeleg(doDelegation);
            if (doDelegation) {
                if (fullDelegation) {
                    context.setOption(GSSConstants.DELEGATION_TYPE, GSIConstants.DELEGATION_TYPE_FULL);
                } else {
                    context.setOption(GSSConstants.DELEGATION_TYPE, GSIConstants.DELEGATION_TYPE_LIMITED);
                }
            }
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
            socket = new Socket();
            socket.connect(socketAddress, GSI_CONNECT_TIMEOUT);
            GSIGssSocket gsiSocket = new GSIGssSocket(socket, context);
            gsiSocket.setUseClientMode(true);
            gsiSocket.setAuthorization(gssAuth);
            gsiSocket.setWrapMode(1);
            gsiSocket.startHandshake();
            socket = gsiSocket;
        }
        catch (Throwable e) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new IOException(e);
        }
        return socket;
    }

    public static Subject getLocalSubject(Socket socket) throws GSSException {
        GlobusPrincipal nm;
        if (!(socket instanceof GssSocket)) {
            throw new GSSException(13);
        }
        GssSocket gssSocket = (GssSocket)socket;
        Subject mySubject = new Subject();
        try {
            nm = JaasGssUtil.toGlobusPrincipal(gssSocket.getContext().getSrcName());
        }
        catch (Throwable t) {
            throw new GSSException(13);
        }
        mySubject.getPrincipals().add(nm);
        return mySubject;
    }

    public static GSSCredential createUserCredential(String x509UserProxy) throws GlobusCredentialException, GSSException, CredentialException {
        if (x509UserProxy != null) {
            X509Credential gcred = new X509Credential(x509UserProxy);
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
            return cred;
        }
        X509Credential gcred = X509Credential.getDefaultCredential();
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
        return cred;
    }

    public static GSSCredential createUserCredential(String x509ServiceCert, String x509ServiceKey) throws GlobusCredentialException, GSSException, CredentialException, IOException {
        if (x509ServiceCert != null && x509ServiceKey != null) {
            X509Credential gcred = new X509Credential(x509ServiceCert, x509ServiceKey);
            GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
            return cred;
        }
        X509Credential gcred = X509Credential.getDefaultCredential();
        GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(gcred, 1);
        return cred;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, GSSContext context) {
        return new GSIGssSocket(s, context);
    }

    @Override
    public Socket createSocket(String host, int port, GSSContext context) throws IOException {
        return new GSIGssSocket(host, port, context);
    }
}

