/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.common;

import java.util.StringTokenizer;

public final class FDTVersion
implements Comparable<FDTVersion> {
    final int major;
    final int minor;
    final int maintenance;
    final String releaseDate;

    private FDTVersion(int major, int minor, int maintenance, String releaseDate) {
        this.major = major;
        this.minor = minor;
        this.maintenance = maintenance;
        this.releaseDate = releaseDate;
    }

    public static FDTVersion fromVersionString(String versionString) {
        if (versionString == null) {
            throw new NullPointerException("Null version string");
        }
        int rDateDelim = versionString.indexOf(45);
        String vString = rDateDelim > 0 ? versionString.substring(0, rDateDelim) : versionString;
        String rDate = rDateDelim < 0 ? "" : versionString.substring(rDateDelim + 1);
        StringTokenizer st = new StringTokenizer(vString, ".");
        int major = 0;
        int minor = 0;
        int maint = 0;
        if (st.hasMoreTokens()) {
            major = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            minor = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            maint = Integer.parseInt(st.nextToken());
        }
        return new FDTVersion(major, minor, maint, rDate);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FDTVersion [").append(this.major).append(".").append(this.minor).append(".").append(this.maintenance).append("-").append(this.releaseDate).append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(FDTVersion other) {
        int d = this.major - other.major;
        if (d == 0 && (d = this.minor - other.minor) == 0 && (d = this.maintenance - other.maintenance) == 0 && this.releaseDate != null && other.releaseDate != null) {
            return this.releaseDate.compareTo(other.releaseDate);
        }
        return d;
    }
}

