/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.util.concurrent.atomic.AtomicLong;
import lia.util.net.copy.Accountable;

public abstract class AccountableEntity
implements Accountable {
    AtomicLong totalProcessedBytes;
    AtomicLong totalUtilBytes;

    public AccountableEntity() {
        this(0L, 0L);
    }

    public AccountableEntity(long initialProcessedBytes, long initialUtilBytes) {
        this.totalProcessedBytes = new AtomicLong(initialProcessedBytes);
        this.totalUtilBytes = new AtomicLong(initialUtilBytes);
    }

    @Override
    public long addAndGetTotalBytes(long delta) {
        return this.totalProcessedBytes.addAndGet(delta);
    }

    @Override
    public long addAndGetUtilBytes(long delta) {
        return this.totalUtilBytes.addAndGet(delta);
    }

    @Override
    public long getTotalBytes() {
        return this.totalProcessedBytes.get();
    }

    @Override
    public long getUtilBytes() {
        return this.totalUtilBytes.get();
    }

    @Override
    public abstract long getSize();
}

