/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import apmon.ApMon;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import lia.util.net.common.AbstractFDTCloseable;
import lia.util.net.common.Config;
import lia.util.net.common.ControlStream;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.FDTCloseable;
import lia.util.net.common.FileChannelProviderFactory;
import lia.util.net.common.GSISSHControlStream;
import lia.util.net.common.HeaderBufferPool;
import lia.util.net.common.InvalidFDTParameterException;
import lia.util.net.common.SSHControlStream;
import lia.util.net.common.Utils;
import lia.util.net.copy.FDTServer;
import lia.util.net.copy.FDTSessionManager;
import lia.util.net.copy.monitoring.ApMonReportingTask;
import lia.util.net.copy.monitoring.ConsoleReportingTask;
import lia.util.net.copy.monitoring.FDTInternalMonitoringTask;
import lia.util.net.copy.monitoring.lisa.LISAReportingTask;
import lia.util.net.copy.transport.ControlChannel;
import lia.util.net.copy.transport.ControlChannelNotifier;
import lia.util.net.copy.transport.CtrlMsg;
import lia.util.net.copy.transport.FDTListFilesMsg;
import lia.util.net.copy.transport.FDTProcolException;
import lia.util.net.copy.transport.FDTSessionConfigMsg;
import lia.util.net.copy.transport.internal.SelectionManager;

public class FDT {
    public static final String MONALISA2_CERN_CH = "monalisa2.cern.ch:8884";
    public static final String RELEASE_DATE = "2021-03-31".replaceAll("-", "");
    public static final String FDT_FULL_VERSION = "0.26.3-" + RELEASE_DATE + "2247";
    public static final long UPDATE_PERIOD = 172800000L;
    private static final String name = "FDT";
    private static final Logger logger = Logger.getLogger(FDT.class.getName());
    private static String UPDATE_OWNER = "fast-data-transfer";
    private static String UPDATE_REPO = "fdt";
    public static String UPDATE_URL = "https://api.github.com/repos/" + UPDATE_OWNER + "/" + UPDATE_REPO + "/releases";
    private static Config config;
    private static Properties localProps;

    FDT() throws Exception {
        ControlChannel cc;
        String monitor;
        switch (monitor = config.getMonitor()) {
            case "APMON": {
                this.initApMon();
                break;
            }
            case "OPENTSDB": {
                FDT.initOpenTSDB(config);
                break;
            }
        }
        FDT.scheduleReportingTasks();
        if (config.isCoordinatorMode()) {
            cc = new ControlChannel(config.getHostName(), config.getPort(), UUID.randomUUID(), (ControlChannelNotifier)FDTSessionManager.getInstance());
            String sessionID = cc.sendCoordinatorMessage(new CtrlMsg(13, new FDTSessionConfigMsg(config)));
            if (sessionID.equals("-1")) {
                logger.log(Level.WARNING, "Message sent to: " + config.getHostName() + ":" + config.getPort() + " but no free transfer ports available");
            } else {
                logger.log(Level.INFO, "Message sent to: " + config.getHostName() + ":" + config.getPort() + " Remote Job Session ID: " + sessionID);
            }
            System.exit(0);
        } else if (config.isListFilesMode()) {
            cc = new ControlChannel(config.getHostName(), config.getPort(), UUID.randomUUID(), (ControlChannelNotifier)FDTSessionManager.getInstance());
            List<String> filesInDir = cc.sendListFilesMessage(new CtrlMsg(14, new FDTListFilesMsg(config.getListFilesFrom())));
            logger.log(Level.INFO, "Message sent to: " + config.getHostName() + ":" + config.getPort());
            FDT.printOutResults(filesInDir);
            System.exit(0);
        } else if (config.isThirdPartyCopyAgent()) {
            this.waitForTask();
        } else if (config.getHostName() != null) {
            config.setRemoteTransferPort(Utils.getFDTTransferPort(config));
            try {
                FDTSessionManager.getInstance().addFDTClientSession(config.getRemoteTransferPort());
            }
            catch (FileNotFoundException ex) {
                ControlChannel cc2 = new ControlChannel(config.getHostName(), config.getPort(), UUID.randomUUID(), (ControlChannelNotifier)FDTSessionManager.getInstance());
                cc2.sendCtrlMessage(new CtrlMsg(16, ex.getMessage()));
            }
        } else {
            if (!DirectByteBufferPool.initInstance(config.getByteBufferSize(), Config.getMaxTakePollIter())) {
                throw new FDTProcolException("The buffer pool cannot be already initialized");
            }
            FDTServer theServer = new FDTServer(config.getPort());
            theServer.doWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initOpenTSDB(Config config) throws Exception {
        config.initOpenTSDBMonitorClient();
        ApMon apmon = null;
        long lStart = System.currentTimeMillis();
        try {
            String node_name;
            String cluster_name;
            Vector<String> vHosts = new Vector<String>();
            Vector<Integer> vPorts = new Vector<Integer>();
            vHosts.add("127.0.0.1");
            vPorts.add(12345);
            ApMon.setLogLevel("WARNING");
            apmon = new ApMon(vHosts, vPorts);
            apmon.setConfRecheck(false, -1L);
            apmon.setGenMonitoring(true, 20);
            if (config.getHostName() != null) {
                cluster_name = "Clients";
                node_name = config.getHostName();
            } else {
                cluster_name = "Servers";
                node_name = apmon.getMyHostname();
            }
            apmon.setMonitorClusterNode(cluster_name, node_name);
            apmon.setSysMonitoring(true, 10L);
        }
        catch (Throwable ex) {
            try {
                logger.log(Level.WARNING, "Error initializing ApMon engine.", ex);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Utils.initApMonInstance(apmon);
            }
        }
        Utils.initApMonInstance(apmon);
        try {
            if (Utils.getApMon() != null) {
                ApMonReportingTask apmrt = new ApMonReportingTask();
                Utils.getMonitoringExecService().scheduleWithFixedDelay(apmrt, 1L, config.getApMonReportingInterval(), TimeUnit.SECONDS);
            } else {
                logger.log(Level.WARNING, "Cannot start ApMonReportingTask because apMon is null!");
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Cannot start ApMonReportingTask because got Exception.", t);
        }
        long lEnd = System.currentTimeMillis();
        logger.info("ApMon for OpenTSDB initialization took " + (lEnd - lStart) + " ms");
    }

    private static void scheduleReportingTasks() {
        Utils.getMonitoringExecService().scheduleWithFixedDelay(FDTInternalMonitoringTask.getInstance(), 1L, 5L, TimeUnit.SECONDS);
        long reportingTaskDelay = config.getReportingTaskDelay();
        if (reportingTaskDelay > 0L) {
            Utils.getMonitoringExecService().scheduleWithFixedDelay(ConsoleReportingTask.getInstance(), 0L, reportingTaskDelay, TimeUnit.SECONDS);
        }
    }

    private static void printOutResults(List<String> filesInDir) {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n");
        for (String entry : filesInDir) {
            sb.append(entry);
            sb.append("\r\n");
        }
        String files = sb.toString();
        logger.info(files);
    }

    private static void printHelp() {
        logger.log(Level.INFO, Config.getUsage());
    }

    private static void printVersion() {
        logger.info("FDT " + FDT_FULL_VERSION);
        logger.info("Contact: support-fdt@monalisa.cern.ch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int doWork() {
        FDTSessionManager fdtSessionManager;
        block37: {
            Exception e = null;
            fdtSessionManager = FDTSessionManager.getInstance();
            block27: while (true) {
                try {
                    while (true) {
                        try {}
                        catch (Throwable t) {
                            logger.log(Level.WARNING, "FDT Got exception in main loop", t);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    e = ex;
                    break block37;
                }
                while (true) {
                    Thread.sleep(1000L);
                    if (config.getHostName() != null && fdtSessionManager.isInited()) {
                        if (fdtSessionManager.sessionsNumber() == 0) break block37;
                        try {
                            fdtSessionManager.awaitTermination();
                            continue block27;
                        }
                        catch (InterruptedException ie) {
                            Thread.interrupted();
                            continue;
                        }
                    }
                    if (!config.isStandAlone() && fdtSessionManager.isInited() && fdtSessionManager.sessionsNumber() == 0 && !config.isThirdPartyCopyAgent()) break block27;
                }
                break;
            }
            SelectionManager.getInstance().stopIt();
            logger.info("Server started with -S flag set and all the sessions have finished ... FDT will stop now");
            break block37;
            finally {
                try {
                    logger.info(" [ " + new Date().toString() + " ] - GracefulStopper hook started ... Waiting for the cleanup to finish");
                    AtomicReference<GracefulStopper> stopper = new AtomicReference<GracefulStopper>(new GracefulStopper());
                    stopper.get().close(null, e);
                    while (!stopper.get().internalClosed) {
                        GracefulStopper gracefulStopper = stopper.get();
                        synchronized (gracefulStopper) {
                            if (stopper.get().internalClosed) {
                                break;
                            }
                            try {
                                stopper.get().wait();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }
                    logger.info(" [ " + new Date().toString() + " ]  - GracefulStopper hook finished!");
                }
                catch (Throwable gExc) {
                    logger.log(Level.WARNING, " [GracefulStopper] Got exception stopper", gExc);
                }
            }
        }
        Throwable tExit = fdtSessionManager.getLasDownCause();
        String mExit = fdtSessionManager.getLasDownMessage();
        if (tExit == null && mExit == null) {
            logger.info("\n [ " + new Date().toString() + " ]  FDT Session finished OK.\n");
            return 0;
        }
        logger.log(Level.WARNING, "\n [ " + new Date().toString() + " ]  FDT Session finished with errors: ");
        if (mExit != null) {
            logger.log(Level.WARNING, mExit + '\n');
        }
        if (tExit != null) {
            logger.log(Level.WARNING, Utils.getStackTrace(tExit) + '\n');
        }
        return 1;
    }

    private static void processSCPSyntax(String[] args) throws Exception {
        int iTransferConfiguration = config.getSSHConfig();
        if (iTransferConfiguration > 0) {
            int sshPort = config.getSSHPort();
            switch (iTransferConfiguration) {
                case 1: {
                    FDT.sshRemoteServerLocalClientPush(sshPort);
                    break;
                }
                case 2: {
                    FDT.sshRemoteServerLocalClientPull(sshPort);
                    break;
                }
                case 3: {
                    FDT.sshRemoteServerAndClientPush(args, sshPort);
                    break;
                }
            }
        }
    }

    private static void sshRemoteServerLocalClientPush(int sshPort) throws Exception {
        ControlStream sshConn;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SSH Mode] SSH_REMOTE_SERVER_LOCAL_CLIENT_PUSH. Remote ssh port: " + sshPort);
        }
        try {
            sshConn = config.isGSISSHModeEnabled() ? new GSISSHControlStream(config.getHostName(), config.getDestinationUser(), sshPort) : new SSHControlStream(config.getHostName(), config.getDestinationUser(), sshPort);
        }
        catch (NoClassDefFoundError t) {
            throw new Exception("GSI libraries not loaded. You should set CLASSPATH accordingly!");
        }
        sshConn.connect();
        String localAddresses = config.getLocalAddresses();
        StringBuilder remoteCmd = new StringBuilder(config.getRemoteCommand() + " -p " + config.getPort() + " -noupdates -silent -S -f " + localAddresses);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" [ CONFIG ] Starting FDT server over SSH using [ " + remoteCmd + " ]");
        }
        sshConn.startProgram(remoteCmd.toString());
        sshConn.waitForControlMessage("READY");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" [ CONFIG ] FDT server successfully started on [ " + config.getHostName() + " ]");
        }
    }

    private static void sshRemoteServerLocalClientPull(int sshPort) throws Exception {
        ControlStream sshConn;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SSH Mode] SSH_REMOTE_SERVER_LOCAL_CLIENT_PULL. Remote ssh port: " + sshPort);
        }
        String remoteServerHost = config.getSourceHosts()[0];
        String[] clients = config.getSourceUsers();
        String remoteServerUsername = clients != null && clients.length > 0 && clients[0] != null ? clients[0] : System.getProperty("user.name", "root");
        config.setPullMode(true);
        config.setHostName(remoteServerHost);
        try {
            sshConn = config.isGSISSHModeEnabled() ? new GSISSHControlStream(remoteServerHost, remoteServerUsername, sshPort) : new SSHControlStream(remoteServerHost, remoteServerUsername, sshPort);
        }
        catch (NoClassDefFoundError t) {
            throw new Exception("GSI libraries not loaded. You should set CLASSPATH accordingly!");
        }
        sshConn.connect();
        String localAddresses = config.getLocalAddresses();
        StringBuilder remoteCmd = new StringBuilder(config.getRemoteCommand() + " -p " + config.getPort() + " -noupdates -silent -S -f " + localAddresses);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" [ CONFIG ] Starting FDT server over SSH using [ " + remoteCmd + " ]");
        }
        sshConn.startProgram(remoteCmd.toString());
        sshConn.waitForControlMessage("READY");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" [ CONFIG ] FDT server successfully started on [ " + remoteServerHost + " ]");
        }
    }

    private static void sshRemoteServerAndClientPush(String[] args, int sshPort) throws Exception {
        String[] clients;
        ControlStream sshConn;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SSH Mode] SSH_REMOTE_SERVER_REMOTE_CLIENT_PUSH. Remote ssh port: " + sshPort);
        }
        String clientHost = config.getSourceHosts()[0];
        try {
            sshConn = config.isGSISSHModeEnabled() ? new GSISSHControlStream(config.getHostName(), config.getDestinationUser(), sshPort) : new SSHControlStream(config.getHostName(), config.getDestinationUser(), sshPort);
        }
        catch (NoClassDefFoundError t) {
            throw new Exception("GSI libraries not loaded. You should set CLASSPATH accordingly!");
        }
        StringBuilder remoteCmd = new StringBuilder(config.getRemoteCommand() + " -p " + config.getPort() + " -noupdates -silent -S -f " + clientHost);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" [ CONFIG ] Starting remote FDT server over SSH using [ " + remoteCmd + " ]");
        }
        sshConn.startProgram(remoteCmd.toString());
        sshConn.waitForControlMessage("READY");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" [ CONFIG ] FDT server successfully started on [ " + config.getHostName() + " ]");
        }
        String clientUser = (clients = config.getSourceUsers()) != null && clients.length > 0 && clients[0] != null ? clients[0] : System.getProperty("user.name", "root");
        try {
            sshConn = config.isGSISSHModeEnabled() ? new GSISSHControlStream(clientHost, clientUser, sshPort) : new SSHControlStream(clientHost, clientUser, sshPort);
        }
        catch (NoClassDefFoundError t) {
            throw new Exception("GSI libraries not loaded. You should set CLASSPATH accordingly!");
        }
        remoteCmd = new StringBuilder(config.getRemoteCommand());
        for (String arg : args) {
            if (arg.indexOf(58) >= 0) continue;
            remoteCmd.append(' ').append(arg);
        }
        remoteCmd.append(" -c ").append(config.getHostName());
        remoteCmd.append(" -d ").append(config.getDestinationDir());
        String[] files = (String[])config.getConfigMap().get("Files");
        remoteCmd.append(' ').append(files[0]);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" [ CONFIG ] Starting FDT client over SSH using [ " + remoteCmd + " ]");
        }
        sshConn.startProgram(remoteCmd.toString());
        sshConn.waitForControlMessage("DONE", true);
        System.exit(0);
    }

    private static void initManagement() throws Exception {
    }

    public static void main(String[] args) throws Exception {
        String logLevel = FDT.initLogging(args);
        Map<String, Object> argsMap = Utils.parseArguments(args, Config.SINGLE_CMDLINE_ARGS);
        FDT.checkMainParams(argsMap);
        boolean noLock = FDT.checkAdditionalParams(argsMap);
        FDT.updateOrSkip(logLevel, argsMap, noLock);
        logger.info("\n\nFDT [ " + FDT_FULL_VERSION + " ] STARTED ... \n\n");
        FDT.initConfig(argsMap, logLevel);
        if (!config.isCoordinatorMode() || !config.isRetrievingLogFile()) {
            logger.info("FDT uses" + (!config.isBlocking() ? " *non-" : " *") + "blocking* I/O mode.");
        }
        FDT.processSCPSyntax(args);
        HeaderBufferPool.initInstance();
        if (!config.isLisaDisabled()) {
            LISAReportingTask lrt = LISAReportingTask.initInstance(config.getLisaHost(), config.getLisaPort());
            Utils.getMonitoringExecService().scheduleWithFixedDelay(lrt, 1L, config.getLisaReportingInterval(), TimeUnit.SECONDS);
        }
        try {
            new FDT();
            FDT.initManagement();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to instantiate FDT", t);
            System.exit(1);
        }
        int exitCode = FDT.doWork();
        Utils.getMonitoringExecService().shutdownNow();
        try {
            FileChannelProviderFactory fcpf;
            if (config.massStorageType() != null && config.massStorageType().equals("dcache") && (fcpf = config.getFileChannelProviderFactory()) instanceof FDTCloseable) {
                ((FDTCloseable)((Object)fcpf)).close(null, null);
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "FDT got exception trying to close the dCapLayer. Cause:", t);
            System.exit(2502);
        }
        System.exit(exitCode);
    }

    private static boolean checkAdditionalParams(Map<String, Object> argsMap) throws Exception {
        boolean noLock;
        boolean bl = noLock = argsMap.get("-nolock") != null || argsMap.get("-nolocks") != null;
        if (argsMap.get("-h") != null || argsMap.get("-H") != null || argsMap.get("-help") != null || argsMap.get("--help") != null) {
            FDT.printHelp();
            System.exit(0);
        } else if (argsMap.get("-V") != null || argsMap.get("--version") != null || argsMap.get("-version") != null) {
            FDT.printVersion();
            System.exit(0);
        } else if (argsMap.get("-u") != null || argsMap.get("-U") != null || argsMap.get("-update") != null || argsMap.get("--update") != null) {
            FDT.updateIfAvailable(argsMap, noLock);
        }
        return noLock;
    }

    private static void initConfig(Map<String, Object> argsMap, String logLevel) {
        try {
            Config.initInstance(argsMap);
        }
        catch (InvalidFDTParameterException e) {
            logger.log(Level.WARNING, "Invalid parameters supplied: " + e.getMessage(), e);
            System.exit(1);
        }
        catch (Throwable t1) {
            logger.log(Level.WARNING, "got exception parsing command args", t1);
            System.exit(1);
        }
        config = Config.getInstance();
        config.setLogLevel(logLevel);
    }

    private static void updateOrSkip(String logLevel, Map<String, Object> argsMap, boolean noLock) {
        block8: {
            if (argsMap.get("-noupdates") == null) {
                Object urlS = argsMap.get("-U");
                String updateURL = UPDATE_URL;
                if (urlS != null && urlS instanceof String && (updateURL = (String)urlS).length() == 0) {
                    updateURL = UPDATE_URL;
                }
                try {
                    if (Utils.checkForUpdate(FDT_FULL_VERSION, updateURL, noLock) && argsMap.get("-silent") == null) {
                        System.out.print("\n\nAn update is available ... Do you want to upgrade to the new version? [Y/n]");
                        char car = (char)System.in.read();
                        logger.info("\n");
                        if (car == 'Y' || car == 'y' || car == '\n' || car == '\r') {
                            System.out.print("\nTrying to update FDT to the new version ... ");
                            if (Utils.updateFDT(FDT_FULL_VERSION, updateURL, true, noLock)) {
                                logger.info("\nThe update finished successfully\n");
                                System.exit(0);
                            } else {
                                logger.info("\nNo updates available\n");
                                System.exit(100);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    logger.info("Got exception checking for updates: " + t.getCause());
                    if (!logLevel.startsWith("FIN")) break block8;
                    t.printStackTrace();
                }
            }
        }
    }

    private static void updateIfAvailable(Map<String, Object> argsMap, boolean noLock) throws Exception {
        Object urlS = argsMap.get("-U");
        String updateURL = UPDATE_URL;
        if (urlS != null && urlS instanceof String && (updateURL = (String)urlS).length() == 0) {
            updateURL = UPDATE_URL;
        }
        if (Utils.updateFDT(FDT_FULL_VERSION, updateURL, true, noLock)) {
            logger.info("\nThe update finished successfully\n");
            System.exit(0);
        } else {
            logger.info("\nNo updates available\n");
            System.exit(100);
        }
    }

    private static void checkMainParams(Map<String, Object> argsMap) {
        if (argsMap.get("-c") != null) {
            if (argsMap.get("-d") == null && argsMap.get("-nettest") == null && argsMap.get("-ls") == null) {
                throw new IllegalArgumentException("No destination specified");
            }
            List lParams = (List)argsMap.get("LastParams");
            if (argsMap.get("-nettest") == null && argsMap.get("-fl") == null && (lParams == null || lParams.size() == 0) && argsMap.get("Files") == null && argsMap.get("-sID") == null && argsMap.get("-ls") == null) {
                throw new IllegalArgumentException("No source specified");
            }
        }
    }

    private static String initLogging(String[] args) throws IOException {
        String logLevel = null;
        File logFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (logLevel != null) continue;
            if (args[i].equals("-v")) {
                logLevel = "FINE";
            }
            if (args[i].equals("-vv")) {
                logLevel = "FINER";
            }
            if (args[i].equals("-vvv")) {
                logLevel = "FINEST";
            }
            if (logFile != null || !args[i].equals("-log")) continue;
            if (i >= args.length - 1) {
                throw new IllegalArgumentException("The -log parameter expects a file path");
            }
            String logPathParam = args[i + 1];
            if (logPathParam.startsWith("-")) {
                throw new IllegalArgumentException("The -log parameter expects a file path which does not start with '-'");
            }
            File logF = new File(logPathParam);
            File logFParent = logF.getParentFile();
            if (logFParent != null && !logFParent.exists()) {
                try {
                    boolean mkdirsResult = logFParent.mkdirs();
                    if (!mkdirsResult) {
                        throw new IllegalArgumentException("Unable to create parent dirs for log file: '" + logFParent + "' OS syscall failed");
                    }
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException("Unable to create parent dirs for log file: '" + logFParent + "' Cause:", t);
                }
            }
            if (logF.exists()) {
                if (!logF.canWrite()) {
                    throw new IOException("The provided log file: '" + logF + "' exists but is not writable!");
                }
            } else {
                boolean createFileResult = logF.createNewFile();
                if (!createFileResult) {
                    throw new IOException("The provided log file: '" + logF + "' cannot be created!");
                }
            }
            logFile = logF;
        }
        if (logLevel == null) {
            logLevel = "INFO";
        }
        if (logLevel.startsWith("FIN")) {
            logger.info(" LogLevel: " + logLevel);
        }
        Utils.initLogger(logLevel, logFile, localProps);
        return logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForTask() throws Exception {
        if (!DirectByteBufferPool.initInstance(config.getByteBufferSize(), Config.getMaxTakePollIter())) {
            throw new FDTProcolException("The buffer pool cannot be already initialized");
        }
        ExecutorService executor = null;
        ServerSocketChannel ssc = null;
        ServerSocket ss = null;
        Selector sel = null;
        try {
            executor = Utils.getStandardExecService("[ Acceptable ServersThreadPool ] ", 2, 10, new ArrayBlockingQueue<Runnable>(65500), 3);
            ssc = ServerSocketChannel.open();
            ssc.configureBlocking(false);
            ss = ssc.socket();
            ss.bind(new InetSocketAddress(config.getPort()));
            sel = Selector.open();
            ssc.register(sel, 16);
            System.out.println("READY");
            Utils.waitAndWork(executor, ss, sel, config);
            logger.log(Level.INFO, "[FDT] [ waitForTask ] main loop FINISHED!");
        }
        catch (Throwable throwable) {
            logger.log(Level.INFO, "[FDT] [ waitForTask ] main loop FINISHED!");
            Utils.closeIgnoringExceptions(ssc);
            Utils.closeIgnoringExceptions(sel);
            Utils.closeIgnoringExceptions(ss);
            if (executor != null) {
                executor.shutdown();
            }
            throw throwable;
        }
        Utils.closeIgnoringExceptions(ssc);
        Utils.closeIgnoringExceptions(sel);
        Utils.closeIgnoringExceptions(ss);
        if (executor != null) {
            executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initApMon() throws Exception {
        String configApMonHosts = config.getApMonHosts();
        if (configApMonHosts != null) {
            long lStart = System.currentTimeMillis();
            ApMon apmon = null;
            String apMonHosts = configApMonHosts.length() > 0 ? configApMonHosts : MONALISA2_CERN_CH;
            logger.info("Trying to instantiate apMon to: " + apMonHosts);
            try {
                Vector<String> vHosts = new Vector<String>();
                Vector<Integer> vPorts = new Vector<Integer>();
                String[] apMonDstTks = apMonHosts.split(",");
                if (apMonDstTks.length == 0) {
                    logger.log(Level.WARNING, "\n\nApMon enabled but no hosts defined! Cannot send apmon statistics\n\n");
                } else {
                    String node_name;
                    String cluster_name;
                    for (String host_port : apMonDstTks) {
                        int port;
                        String host;
                        int index = host_port.indexOf(58);
                        if (index != -1) {
                            host = host_port.substring(0, index);
                            try {
                                port = Integer.parseInt(host_port.substring(index + 1));
                            }
                            catch (Exception ex) {
                                port = 28884;
                            }
                        } else {
                            host = host_port;
                            port = 28884;
                        }
                        vHosts.add(host);
                        vPorts.add(port);
                    }
                    ApMon.setLogLevel("WARNING");
                    apmon = new ApMon(vHosts, vPorts);
                    apmon.setConfRecheck(false, -1L);
                    apmon.setGenMonitoring(true, 40);
                    if (config.getHostName() != null) {
                        cluster_name = "Clients";
                        node_name = config.getHostName();
                    } else {
                        cluster_name = "Servers";
                        node_name = apmon.getMyHostname();
                    }
                    apmon.setMonitorClusterNode(cluster_name, node_name);
                    apmon.setSysMonitoring(true, 40L);
                    try {
                        apmon.sendParameter(cluster_name, node_name, "FDT_version", FDT_FULL_VERSION);
                    }
                    catch (Exception e) {
                        logger.info("Send operation failed: ");
                        e.printStackTrace();
                    }
                }
            }
            catch (Throwable ex) {
                logger.log(Level.WARNING, "Error initializing ApMon engine.", ex);
            }
            finally {
                Utils.initApMonInstance(apmon);
            }
            try {
                if (Utils.getApMon() != null) {
                    ApMonReportingTask apmrt = new ApMonReportingTask();
                    Utils.getMonitoringExecService().scheduleWithFixedDelay(apmrt, 1L, config.getApMonReportingInterval(), TimeUnit.SECONDS);
                } else {
                    logger.log(Level.WARNING, "Cannot start ApMonReportingTask because apMon is null!");
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Cannot start ApMonReportingTask because got Exception.", t);
            }
            long lEnd = System.currentTimeMillis();
            logger.info("ApMon initialization took " + (lEnd - lStart) + " ms");
        }
    }

    static {
        localProps = new Properties();
    }

    private static final class GracefulStopper
    extends AbstractFDTCloseable {
        private boolean internalClosed = false;

        private GracefulStopper() {
        }

        @Override
        protected synchronized void internalClose() throws Exception {
            this.internalClosed = true;
            this.notifyAll();
        }
    }
}

