/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.UUID;
import lia.util.net.common.FileChannelProvider;
import lia.util.net.copy.FDTSession;
import lia.util.net.copy.FileSession;

public class FileReaderSession
extends FileSession {
    public FileReaderSession(String fileName, FDTSession fdtSession, boolean isLoop, FileChannelProvider fileChannelProvider) throws IOException {
        this(UUID.randomUUID(), fdtSession, fileName, isLoop, fileChannelProvider);
    }

    public FileReaderSession(UUID uid, FDTSession fdtSession, String fileName, boolean isLoop, FileChannelProvider fileChannelProvider) throws IOException {
        super(uid, fdtSession, fileName, isLoop, fileChannelProvider);
        this.fileName = this.file.getAbsolutePath();
        this.file = this.fileChannelProvider.getFile(fileName);
        if (!fileName.startsWith("/dev/zero") && !this.file.exists()) {
            throw new FileNotFoundException("No such file: " + fileName);
        }
        this.sessionSize = this.file.length();
        if (fileName.startsWith("/dev/zero") || isLoop) {
            this.sessionSize = -1L;
            return;
        }
        boolean bNoChk = Boolean.getBoolean("DO_NOT_CHECK_FILE");
        if (bNoChk) {
            this.sessionSize = -1L;
            return;
        }
        if (!isLoop && !this.file.isFile()) {
            throw new IOException("The specified name [ " + fileName + " ] is not a file!");
        }
        this.partitionID = this.fileChannelProvider.getPartitionID(this.file);
    }

    public String toString() {
        return "FileReaderSession [file=" + this.file + ", partitionID=" + this.partitionID + ", sessionID=" + this.sessionID + ", sessionSize=" + this.sessionSize + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileChannel getChannel() throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.isClosed()) {
                if (!this.isLoop) {
                    throw new IOException("FileReaderSession closed!");
                }
            } else if (this.fileChannel != null) {
                return this.fileChannel;
            }
            try {
                this.fileChannel = this.fileChannelProvider.getFileChannel(this.file, null);
            }
            catch (Exception ex) {
                this.close("Cannot instantiate fileChannel", ex);
                throw ex;
            }
        }
        return this.fileChannel;
    }

    @Override
    protected void internalClose() {
        super.internalClose();
        if (this.isLoop) {
            this.closed = false;
        }
    }
}

