/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.filters.examples;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import lia.util.net.copy.FileSession;
import lia.util.net.copy.filters.Preprocessor;
import lia.util.net.copy.filters.ProcessorInfo;

public class FirewallFileExtension
implements Preprocessor {
    private static final Logger logger = Logger.getLogger(FirewallFileExtension.class.getName());

    @Override
    public void preProcessFileList(ProcessorInfo processorInfo, Subject peerSubject) throws Exception {
        Map<String, FileSession> fileSessionMap = processorInfo.fileSessionMap;
        String firewallSuffix = System.getProperty("FirewallFileExtension.suffix");
        if (firewallSuffix == null || firewallSuffix.trim().isEmpty()) {
            logger.log(Level.INFO, "[ FirewallFileNames ] No suffix defined");
            return;
        }
        String firewallSuffixTrim = firewallSuffix.trim();
        logger.log(Level.INFO, " [ FirewallFileNames ] firewall suffix pattern=" + firewallSuffixTrim);
        Iterator<Map.Entry<String, FileSession>> iterator = fileSessionMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FileSession> entry = iterator.next();
            FileSession fileSession = entry.getValue();
            String fName = fileSession.fileName();
            logger.log(Level.INFO, "[ FirewallFileNames ] fname = " + fName);
            if (!fName.endsWith(firewallSuffixTrim)) continue;
            logger.log(Level.INFO, "FNAME firewalled: " + fName);
            iterator.remove();
        }
    }
}

