/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui;

import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import lia.util.net.copy.gui.StatusBar;

public class CustomLogHandler
extends Handler {
    private final StatusBar status;
    private final MyCustomFormatter formatter;

    public CustomLogHandler(StatusBar status) {
        this.status = status;
        this.formatter = new MyCustomFormatter();
    }

    private void setStatus(String status) {
        if (this.status == null) {
            return;
        }
        this.status.addText(status);
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.setStatus(this.formatter.format(record));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    class MyCustomFormatter
    extends Formatter {
        @Override
        public String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            sb.append("<font color=#ff0000>");
            Date date = new Date(record.getMillis());
            sb.append(date.toString());
            sb.append(" ");
            sb.append(record.getSourceClassName());
            sb.append(" ");
            sb.append(record.getSourceMethodName().replace("<", "[").replace(">", "]"));
            sb.append("\n");
            sb.append(record.getLevel().getName());
            sb.append(": ");
            sb.append(this.formatMessage(record).replace("<", "[").replace(">", "]"));
            sb.append("\n");
            sb.append("</font>");
            return sb.toString();
        }
    }
}

