/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.gui.session;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import lia.util.net.copy.gui.RemoteSessionManager;
import lia.util.net.copy.gui.session.Session;
import lia.util.net.copy.transport.gui.FileHandler;

public class RemoteSession
extends Session {
    public static final Icon folderIcon;
    public static final HashMap<String, Icon> icons;
    static final String osName;
    private static final FileSystemView local;
    private final RemoteSessionManager manager;
    private ImageIcon unknownIcon;

    public RemoteSession(RemoteSessionManager manager) {
        this.manager = manager;
    }

    private static final boolean isWindows() {
        return osName.indexOf("windows") > -1;
    }

    private static final boolean isLinux() {
        return osName.indexOf("linux") > -1;
    }

    private static final boolean isMac() {
        return osName.indexOf("mac") > -1;
    }

    @Override
    public void setAbsoluteDir(String dir) throws Exception {
        this.manager.setAbsoluteDir(dir);
        this.update();
    }

    @Override
    public void setRelativeDir(String dir) throws Exception {
        this.manager.setRelativeDir(dir);
        this.update();
    }

    @Override
    public void setUpDir() throws Exception {
        this.manager.setUpDir();
        this.update();
    }

    @Override
    public String[] getRoots() throws Exception {
        return this.manager.getRoots();
    }

    @Override
    public String getFileSeparator() {
        return this.manager.getFileSeparator();
    }

    @Override
    public String getShortRootName(String rootFolder) {
        return this.manager.getShortRootName(rootFolder);
    }

    @Override
    public boolean isRoot() {
        return this.manager.isRoot();
    }

    @Override
    public void removeFiles(String[] files) throws Exception {
        this.manager.removeFiles(files);
    }

    @Override
    public void createDir(String name) throws Exception {
        this.manager.createDir(name);
    }

    private void update() {
        this.dirs.clear();
        this.length.clear();
        icons.clear();
        this.modif.clear();
        this.read.clear();
        this.write.clear();
        Vector<FileHandler> v = this.manager.getFileList();
        if (v != null) {
            for (FileHandler h : v) {
                String fn = h.getName();
                if (h.getSize() < 0L) {
                    this.dirs.add(fn);
                    ((Session)this).icons.put(fn, this.getFolderIcon());
                } else {
                    this.length.put(fn, h.getSize());
                    ((Session)this).icons.put(fn, this.getFileIcon(fn));
                }
                this.modif.put(fn, h.getModif());
                this.read.put(fn, h.canRead());
                this.write.put(fn, h.canWrite());
            }
        }
    }

    private Icon getFolderIcon() {
        return folderIcon;
    }

    private Icon getUnknownIcon() {
        if (this.unknownIcon != null) {
            return this.unknownIcon;
        }
        try {
            URL r = this.getClass().getResource("../icons/file.png");
            this.unknownIcon = new ImageIcon(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.unknownIcon;
    }

    private final boolean okFS(String str) {
        if (RemoteSession.isWindows()) {
            return !str.contains("\\") && !str.contains("/") && !str.contains(":") && !str.contains("*") && !str.contains("?") && !str.contains("\"") && !str.contains("<") && !str.contains(">") && !str.contains("|");
        }
        return true;
    }

    private Icon getFileIcon(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index < 0) {
            return this.getUnknownIcon();
        }
        String ext = fileName.substring(index + 1);
        if (!this.okFS(ext)) {
            return this.getUnknownIcon();
        }
        if (icons.containsKey(ext)) {
            return icons.get(ext);
        }
        try {
            File file = File.createTempFile("icon", "." + ext);
            Icon icon = null;
            if (file.exists()) {
                try {
                    icon = local.getSystemIcon(file);
                    icons.put(ext, icon);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            file.delete();
            if (icon != null) {
                return icon;
            }
            return this.getUnknownIcon();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return this.getUnknownIcon();
        }
    }

    @Override
    public String getWorkingDir() {
        return this.manager.getWorkingDirectory();
    }

    @Override
    public boolean canWrite() {
        return this.manager.canWrite();
    }

    @Override
    public String getOSName() {
        return this.manager.getOSName();
    }

    @Override
    public String getUserDir() {
        return this.manager.getUserHome();
    }

    @Override
    public boolean fileExists(String fileName) {
        if (fileName == null) {
            return false;
        }
        return this.modif.containsKey(fileName);
    }

    @Override
    public String freeSpace() {
        return this.manager.freeSpace();
    }

    static {
        icons = new HashMap();
        osName = System.getProperty("os.name").toLowerCase(Locale.US);
        local = FileSystemView.getFileSystemView();
        folderIcon = local.getSystemIcon(new File(System.getProperty("user.dir")));
    }
}

