/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import lia.gsi.GSIServer;
import lia.gsi.net.GSIGssSocketFactory;
import lia.util.net.common.AbstractFDTCloseable;
import lia.util.net.common.Config;
import lia.util.net.common.DirectByteBufferPool;
import lia.util.net.common.FDTVersion;
import lia.util.net.common.Utils;
import lia.util.net.copy.transport.ControlChannelNotifier;
import lia.util.net.copy.transport.CtrlMsg;
import lia.util.net.copy.transport.FDTListFilesMsg;
import lia.util.net.copy.transport.FDTProcolException;

public class ControlChannel
extends AbstractFDTCloseable
implements Runnable {
    public static final int CONNECT_TIMEOUT = 20000;
    public static final int SOCKET_TIMEOUT = 60000;
    public static final int MAX_RETRIES = 1000;
    public static final int RETRY_TIMEOUT = 300;
    private static final Logger logger = Logger.getLogger(ControlChannel.class.getName());
    private static final CtrlMsg versionMsg = new CtrlMsg(1, "0.26.3-2021-03-31");
    private static final Config config = Config.getInstance();
    public final InetAddress remoteAddress;
    public final int remotePort;
    public final int localPort;
    private final Socket controlSocket;
    private final ConcurrentLinkedQueue<Object> qToSend = new ConcurrentLinkedQueue();
    private final AtomicBoolean cleanupFinished = new AtomicBoolean(false);
    private final ControlChannelNotifier notifier;
    public Map<String, Object> remoteConf;
    public volatile Subject subject;
    private UUID fdtSessionID;
    private volatile ObjectOutputStream oos = null;
    private volatile ObjectInputStream ois = null;
    private volatile String fullRemoteVersion;
    private volatile String myName;
    private volatile ScheduledFuture<?> ccptFuture;

    public ControlChannel(String address, int port, UUID sessionID, ControlChannelNotifier notifier) throws Exception {
        this(InetAddress.getByName(address), port, sessionID, notifier);
    }

    public ControlChannel(InetAddress inetAddress, int port, UUID fdtSessionID, ControlChannelNotifier notifier) throws Exception {
        try {
            this.notifier = notifier;
            this.fdtSessionID = fdtSessionID;
            if (config.isGSIModeEnabled()) {
                GSIGssSocketFactory factory = new GSIGssSocketFactory();
                this.controlSocket = GSIGssSocketFactory.createSocket(inetAddress, config.getGSIPort(), false, false);
                this.subject = GSIGssSocketFactory.getLocalSubject(this.controlSocket);
            } else {
                this.controlSocket = new Socket();
                this.controlSocket.connect(new InetSocketAddress(inetAddress, port), 20000);
            }
            this.remoteAddress = inetAddress;
            this.remotePort = port;
            this.localPort = this.controlSocket.getLocalPort();
            this.controlSocket.setTcpNoDelay(true);
            if (!config.isGSIModeEnabled()) {
                this.controlSocket.getOutputStream().write(new byte[]{0});
            }
            this.initStreams();
            this.controlSocket.setSoTimeout(1000);
        }
        catch (Throwable t) {
            this.close("Cannot instantiate ControlChannel", t);
            throw new Exception(t);
        }
    }

    public ControlChannel(Socket s, ControlChannelNotifier notifier) throws Exception {
        try {
            this.controlSocket = s;
            this.remoteAddress = s.getInetAddress();
            this.remotePort = s.getPort();
            this.localPort = s.getLocalPort();
            this.notifier = notifier;
            this.initStreams();
            this.controlSocket.setTcpNoDelay(true);
            this.controlSocket.setSoTimeout(1000);
        }
        catch (Throwable t) {
            this.close("Cannot instantiate ControlChannel", t);
            throw new Exception(t);
        }
    }

    public ControlChannel(GSIServer parent, Socket s, Subject peerSubject, ControlChannelNotifier notifier) throws Exception {
        try {
            this.controlSocket = s;
            this.subject = peerSubject;
            this.remoteAddress = s.getInetAddress();
            this.remotePort = s.getPort();
            this.localPort = s.getLocalPort();
            this.notifier = notifier;
            this.initStreams();
            this.controlSocket.setTcpNoDelay(true);
            this.controlSocket.setSoTimeout(1000);
        }
        catch (Throwable t) {
            this.close("Cannot instantiate ControlChannel", t);
            throw new Exception(t);
        }
    }

    public boolean isSocketClosed() {
        return this.controlSocket == null ? true : this.controlSocket.isClosed();
    }

    public UUID fdtSessionID() {
        return this.fdtSessionID;
    }

    public String toString() {
        return this.controlSocket == null ? "null" : this.controlSocket.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initStreams() throws Exception {
        long remoteKA;
        this.oos = new ObjectOutputStream(new BufferedOutputStream(this.controlSocket.getOutputStream()));
        this.sendMsgImpl(versionMsg);
        try {
            BufferedInputStream bis = new BufferedInputStream(this.controlSocket.getInputStream());
            if (bis.available() == 1) {
                throw new IllegalStateException("Could not initialise stream to server, client did not use GSI");
            }
            this.ois = new ObjectInputStream(new BufferedInputStream(this.controlSocket.getInputStream()));
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not initialise stream to server, check if server is running or certificates present" + ex);
            throw ex;
        }
        CtrlMsg ctrlMsg = (CtrlMsg)this.ois.readObject();
        if (ctrlMsg.tag != 1) {
            throw new FDTProcolException("Unexpected remote control message. Expected PROTOCOL_VERSION tag [ 1 ] Received tag: " + ctrlMsg.tag);
        }
        this.fullRemoteVersion = (String)ctrlMsg.message;
        ctrlMsg = new CtrlMsg(4, Config.getInstance().getConfigMap());
        this.sendMsgImpl(ctrlMsg);
        ctrlMsg = (CtrlMsg)this.ois.readObject();
        if (ctrlMsg.tag != 4) {
            throw new FDTProcolException("Unexpected remote control message. Expected INIT_FDT_CONF tag [ 4 ] Received tag: " + ctrlMsg.tag);
        }
        this.remoteConf = (HashMap)ctrlMsg.message;
        try {
            if (DirectByteBufferPool.initInstance(Integer.parseInt((String)this.remoteConf.get("-bs")), Config.getMaxTakePollIter())) {
                logger.log(Level.FINER, "The buffer pool has been initialized");
            } else {
                logger.log(Level.FINER, "The buffer pool is already initialized");
            }
        }
        catch (Throwable t) {
            throw new FDTProcolException("Unable to instantiate the buffer pool", t);
        }
        if (this.fdtSessionID == null) {
            ctrlMsg = (CtrlMsg)this.ois.readObject();
            if (ctrlMsg.tag != 2) throw new FDTProcolException("Unexpected remote control message. Expected SESSION_ID tag [ 2 ] Received tag: " + ctrlMsg.tag);
            this.fdtSessionID = (UUID)ctrlMsg.message;
        } else {
            this.sendMsgImpl(new CtrlMsg(2, this.fdtSessionID));
        }
        Utils.initLogger(config.getLogLevel(), null, new Properties());
        this.myName = " ControlThread for ( " + this.fdtSessionID + " ) " + this.controlSocket.getInetAddress() + ":" + this.controlSocket.getPort();
        if (Utils.isTransferPort(this.localPort)) {
            config.registerTransferPortForSession(this.localPort, this.fdtSessionID.toString());
        }
        logger.log(Level.INFO, "NEW CONTROL stream for " + this.fdtSessionID + " initialized ");
        long localKA = Config.getInstance().getKeepAliveDelay(TimeUnit.NANOSECONDS);
        String remoteKAS = (String)this.remoteConf.get("-ka");
        long remoteKAN = remoteKAS == null ? localKA : TimeUnit.SECONDS.toNanos(Long.parseLong(remoteKAS));
        long l = remoteKA = remoteKAN < 0L ? localKA : remoteKAN;
        if (this.fullRemoteVersion != null && Utils.compareVersions(this.fullRemoteVersion, "0.9.8") >= 0) {
            Object object = this.closeLock;
            synchronized (object) {
                FDTVersion localVersion = FDTVersion.fromVersionString("0.26.3-2021-03-31");
                FDTVersion remoteVersion = FDTVersion.fromVersionString(this.fullRemoteVersion);
                long kaMinNanos = Math.min(localKA, remoteKA);
                long kaMaxSeconds = TimeUnit.NANOSECONDS.toSeconds(kaMinNanos);
                String strLog = kaMaxSeconds > 0L ? kaMaxSeconds + " second(s)" : TimeUnit.NANOSECONDS.toMillis(kaMinNanos) + " millis";
                logger.log(Level.INFO, "App KeepAlive [ " + strLog + " ] enabled for control channel. Local " + localVersion + ", Remote " + remoteVersion);
                this.ccptFuture = Utils.getMonitoringExecService().scheduleWithFixedDelay(new ControlChannelPingerTask(this), kaMinNanos, kaMinNanos, TimeUnit.NANOSECONDS);
                return;
            }
        } else {
            if (!logger.isLoggable(Level.FINE)) return;
            logger.log(Level.FINE, "[ ControlChannel ] remote version " + this.fullRemoteVersion + " does not support KEEP_ALIVE messages");
        }
    }

    public String remoteVersion() {
        return this.fullRemoteVersion;
    }

    private final void cleanup() {
        if (this.cleanupFinished.compareAndSet(false, true)) {
            Utils.cancelFutureIgnoringException(this.ccptFuture, false);
            Utils.closeIgnoringExceptions(this.ois);
            Utils.closeIgnoringExceptions(this.oos);
            Utils.closeIgnoringExceptions(this.controlSocket);
            if (this.notifier != null) {
                try {
                    this.notifier.notifyCtrlSessionDown(this, this.downCause());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void sendCtrlMessage(CtrlMsg ctrlMsg) {
        if (ctrlMsg == null) {
            throw new NullPointerException("Control message cannot be null over the ControlChannel");
        }
        logger.log(Level.FINER, "[ CtrlChannel ] adding to send queue msg: " + ctrlMsg.toString());
        if (logger.isLoggable(Level.FINEST)) {
            Thread.dumpStack();
        }
        this.qToSend.add(ctrlMsg);
    }

    public void sendSessionIDToCoordinator(CtrlMsg ctrlMsg) {
        logger.log(Level.INFO, "[ ControlChannel ] [ sendSessionIDToCoordinator ( " + ctrlMsg.message.toString() + " )");
        logger.log(Level.FINER, "[ ControlChannel ] adding to send queue msg: " + ctrlMsg.toString());
        if (logger.isLoggable(Level.FINEST)) {
            Thread.dumpStack();
        }
        try {
            this.sendMsgImpl(ctrlMsg);
            this.sendAllMsgs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendRemoteTransferPort(CtrlMsg ctrlMsg) {
        logger.log(Level.INFO, "[ ControlChannel ] [ sendRemoteTransferPort ( " + ctrlMsg.message.toString() + " )" + this.remoteAddress + ":" + this.remotePort);
        logger.log(Level.FINER, "[ CtrlChannel ] adding to send queue msg: " + ctrlMsg.toString());
        if (logger.isLoggable(Level.FINEST)) {
            Thread.dumpStack();
        }
        try {
            this.sendMsgImpl(ctrlMsg);
            this.sendAllMsgs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> sendListFilesMessage(CtrlMsg ctrlMsg) throws IOException {
        logger.log(Level.INFO, "[ ControlChannel ] [ sendListFilesMessage ]");
        logger.log(Level.FINER, "[ CtrlChannel ] adding to send queue msg: " + ctrlMsg.toString());
        if (logger.isLoggable(Level.FINEST)) {
            Thread.dumpStack();
        }
        try {
            logger.log(Level.FINEST, "[ ControlChannel ] [ sendListFilesMessage ] sendMsgImpl " + ctrlMsg);
            this.sendMsgImpl(ctrlMsg);
            this.sendAllMsgs();
            logger.log(Level.FINEST, "[ ControlChannel ] [ sendListFilesMessage ] waiting for response " + ctrlMsg);
            CtrlMsg newCtrlMsg = this.getResponse();
            logger.log(Level.FINER, "[ CtrlChannel ] [ sendListFilesMessage ] listing files on remote machine: " + newCtrlMsg.message.toString());
            FDTListFilesMsg msg = (FDTListFilesMsg)newCtrlMsg.message;
            return msg.filesInDir;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to retrieve response from server", e);
            this.cleanup();
            return null;
        }
    }

    public int sendTransferPortMessage(CtrlMsg ctrlMsg) throws IOException {
        logger.log(Level.INFO, "[ ControlChannel ] [ sendTransferPortMessage ]");
        logger.log(Level.FINER, "[ CtrlChannel ] adding to send queue msg: " + ctrlMsg.toString());
        if (logger.isLoggable(Level.FINEST)) {
            Thread.dumpStack();
        }
        try {
            this.sendMsgImpl(ctrlMsg);
            this.sendAllMsgs();
            CtrlMsg newCtrlMsg = this.getResponse();
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "[ CtrlChannel ] [ sendTransferPortMessage ] got response: " + newCtrlMsg.message);
            }
            return (Integer)newCtrlMsg.message;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to retrieve response from server", e);
            this.cleanup();
            return -1;
        }
    }

    public String sendCoordinatorMessage(CtrlMsg ctrlMsg) throws IOException {
        logger.log(Level.INFO, "[ ControlChannel ] [ sendCoordinatorMessage ]");
        logger.log(Level.FINER, "[ CtrlChannel ] adding to send queue msg: " + ctrlMsg.toString());
        if (logger.isLoggable(Level.FINEST)) {
            Thread.dumpStack();
        }
        try {
            this.sendMsgImpl(ctrlMsg);
            this.sendAllMsgs();
            CtrlMsg newCtrlMsg = this.getResponse();
            logger.info("Remote job session ID: " + newCtrlMsg.message.toString());
            return newCtrlMsg.message.toString();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to retrieve response from server", e);
            this.cleanup();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CtrlMsg getResponse() throws Exception {
        Exception t = null;
        CtrlMsg newCtrlMsg = null;
        logger.log(Level.FINEST, "[ ControlChannel ] [ getResponse] will wait for response 300000ms");
        for (int i = 1; i <= 1000; ++i) {
            CtrlMsg ctrlMsg;
            block6: {
                try {
                    logger.log(Level.FINER, "[ ControlChannel ] [ getResponse] trying to read CtrlMsg for " + i + " time");
                    newCtrlMsg = (CtrlMsg)this.ois.readObject();
                    logger.log(Level.FINER, "[ ControlChannel ] [ getResponse] read CtrlMsg " + newCtrlMsg);
                    ctrlMsg = newCtrlMsg;
                    if (newCtrlMsg != null || i != 1000) break block6;
                    logger.log(Level.FINEST, "[ ControlChannel ] [ getResponse] CtrlMsg " + newCtrlMsg, t);
                }
                catch (Exception e) {
                    try {
                        logger.log(Level.FINEST, "[ ControlChannel ] [ getResponse] failed to read CtrlMsg ", e);
                        t = e;
                        Thread.sleep(300L);
                        logger.log(Level.FINEST, "[ ControlChannel ] [ getResponse] waited for 300ms");
                        if (newCtrlMsg != null || i != 1000) continue;
                        logger.log(Level.FINEST, "[ ControlChannel ] [ getResponse] CtrlMsg " + newCtrlMsg, t);
                    }
                    catch (Throwable throwable) {
                        if (newCtrlMsg == null && i == 1000) {
                            logger.log(Level.FINEST, "[ ControlChannel ] [ getResponse] CtrlMsg " + newCtrlMsg, t);
                            throw t;
                        }
                        throw throwable;
                    }
                    throw t;
                }
                throw t;
            }
            return ctrlMsg;
        }
        logger.log(Level.FINEST, "[ ControlChannel ] [ getResponse] got message null");
        return null;
    }

    public void emptyMsgQueue() throws Exception {
        this.sendAllMsgs();
    }

    private synchronized void sendAllMsgs() throws Exception {
        Object ctrlMsg;
        while ((ctrlMsg = this.qToSend.poll()) != null) {
            this.sendMsgImpl(ctrlMsg);
        }
    }

    private void sendMsgImpl(Object o) throws Exception {
        block2: {
            try {
                logger.log(Level.INFO, " [ ControlChannel ] sending message " + o);
                this.oos.writeObject(o);
                this.oos.reset();
                this.oos.flush();
                logger.log(Level.FINER, " [ ControlChannel ] sent message " + o);
            }
            catch (Throwable t) {
                if (this.isClosed()) break block2;
                this.close("Exception sending control data", t);
                throw new IOException(" Cannot send ctrl message ( " + t.getCause() + " ) ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        final ArrayBlockingQueue<Object> notifQueue = new ArrayBlockingQueue<Object>(10);
        Thread iNotif = new Thread(){

            @Override
            public void run() {
                this.setName("INotifier for: " + ControlChannel.this.myName);
                while (ControlChannel.this.controlSocket != null && !ControlChannel.this.controlSocket.isClosed()) {
                    try {
                        Object toNotif = notifQueue.poll(1L, TimeUnit.SECONDS);
                        if (toNotif == null) continue;
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.log(Level.FINEST, "[ ControlChannel ] [ INotifier ] notifying msg: " + toNotif);
                        }
                        ControlChannel.this.notifier.notifyCtrlMsg(ControlChannel.this, toNotif);
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(Level.FINER)) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("[ ControlChannel ] [ INotifier ] Got exception. ControlChannel isClosed(): ").append(ControlChannel.this.isClosed());
                            if (ControlChannel.this.isClosed()) {
                                sb.append(" downMessage: ").append(ControlChannel.this.downMessage()).append(" downCause: ").append(Utils.getStackTrace(ControlChannel.this.downCause()));
                            }
                            sb.append(" Inotifier Exception: ");
                            logger.log(Level.FINER, sb.toString(), t);
                        }
                        ControlChannel.this.close("INotifier got exception ", t);
                        ControlChannel.this.cleanup();
                    }
                }
            }
        };
        iNotif.setDaemon(true);
        iNotif.start();
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, this.myName + " STARTED main loop");
        }
        String internalDownMsg = null;
        Throwable internalDownCause = null;
        try {
            while (this.controlSocket != null && !this.controlSocket.isClosed()) {
                try {
                    this.sendAllMsgs();
                    Object o = this.ois.readObject();
                    if (o == null) continue;
                    boolean isFine = logger.isLoggable(Level.FINE);
                    if (isFine) {
                        logger.log(Level.FINE, " [ ControlChannel ] received msg: " + o);
                    }
                    if (o instanceof CtrlMsg) {
                        CtrlMsg ctrlMsg = (CtrlMsg)o;
                        if (ctrlMsg.tag == 0) {
                            if (!isFine) continue;
                            logger.log(Level.FINE, "Ctrl channel received app KEEP_ALIVE_MSG");
                            continue;
                        }
                        if (ctrlMsg.tag == 12) {
                            if (this.isClosed()) break;
                            String errMsg = "Remote site will close the transfer session; FINAL timeout was reached. Most likely the TCP buffers on remote site are higher than normal. Try the blocking I/O -bio on both sides and no -ss.";
                            logger.log(Level.WARNING, "Remote site will close the transfer session; FINAL timeout was reached. Most likely the TCP buffers on remote site are higher than normal. Try the blocking I/O -bio on both sides and no -ss.");
                            this.close("Remote site will close the transfer session; FINAL timeout was reached. Most likely the TCP buffers on remote site are higher than normal. Try the blocking I/O -bio on both sides and no -ss.", null);
                            break;
                        }
                    }
                    notifQueue.add(o);
                }
                catch (SocketTimeoutException o) {
                }
                catch (IOException ioe) {
                    this.close("Control channel got I/O Exception", ioe);
                    this.cleanup();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.close("Control channel got general exception. Will close!", t);
                    this.cleanup();
                }
            }
            config.releaseRemoteTransferPort(this.fdtSessionID.toString());
        }
        catch (Throwable t) {
            try {
                if (!this.isClosed()) {
                    internalDownMsg = this.myName + " got exception in main loop: " + t.getMessage();
                    internalDownCause = t;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Control Thread for " + this.myName + " got exception in main loop", t);
                    }
                }
                config.releaseRemoteTransferPort(this.fdtSessionID.toString());
            }
            catch (Throwable throwable) {
                config.releaseRemoteTransferPort(this.fdtSessionID.toString());
                if (this.downMessage() == null && this.downCause() == null) {
                    this.close(internalDownMsg, internalDownCause);
                    throw throwable;
                }
                this.close(this.downMessage(), this.downCause());
                throw throwable;
            }
            if (this.downMessage() != null || this.downCause() != null) {
                this.close(this.downMessage(), this.downCause());
            } else {
                this.close(internalDownMsg, internalDownCause);
            }
        }
        if (this.downMessage() != null || this.downCause() != null) {
            this.close(this.downMessage(), this.downCause());
        } else {
            this.close(internalDownMsg, internalDownCause);
        }
        logger.log(Level.INFO, this.myName + " FINISHED");
    }

    @Override
    protected void internalClose() {
        try {
            Thread t = new Thread(){

                @Override
                public void run() {
                    this.setName("(ML) ControlChannel Graceful stopper thread");
                    try {
                        int retry = 0;
                        while (retry++ < 3) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                if (ControlChannel.this.controlSocket == null) break;
                                if (ControlChannel.this.controlSocket.isClosed()) {
                                    break;
                                }
                                ControlChannel.this.qToSend.add(new CtrlMsg(12, ControlChannel.this.downMessage() + Utils.getStackTrace(ControlChannel.this.downCause())));
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    finally {
                        ControlChannel.this.cleanup();
                    }
                }
            };
            t.setDaemon(true);
            t.start();
        }
        catch (Throwable ignored) {
            try {
                this.cleanup();
            }
            catch (Throwable exc) {
                logger.log(Level.WARNING, "Exception in cleanup()", exc);
            }
        }
    }

    private static final class ControlChannelPingerTask
    implements Runnable {
        public static final CtrlMsg pingMsg = new CtrlMsg(0, new byte[1]);
        private final ControlChannel cc;

        ControlChannelPingerTask(ControlChannel cc) {
            this.cc = cc;
            logger.log(Level.INFO, "[ ControlChannelPingerTask ] initialized");
        }

        @Override
        public void run() {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "[ ControlChannelPingerTask ] sending KEEP_ALIVE_MSG");
            }
            try {
                this.cc.sendCtrlMessage(pingMsg);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, " [ ContrlChannelPingerTask ] Unable to send msg  ... Close the socket ??? This should not happen", t);
            }
        }
    }
}

