/*
 * Decompiled with CFR 0.152.
 */
package lia.util.net.copy.transport;

import java.nio.ByteBuffer;
import java.util.UUID;
import lia.util.net.copy.FileBlock;
import lia.util.net.copy.transport.FDTKeyAttachement;
import lia.util.net.copy.transport.internal.FDTSelectionKey;

class FDTReaderKeyAttachement
extends FDTKeyAttachement {
    public int version;
    public int packetType;
    public UUID uuid;
    public long fileOffset;
    public volatile int payloadSize;
    public volatile long seq;
    public volatile long tstamp;
    boolean isHeaderProcessed = false;

    FDTReaderKeyAttachement(FDTSelectionKey fdtSelectionKey, boolean useFixedSizeBlocks) {
        super(fdtSelectionKey, useFixedSizeBlocks);
    }

    public final synchronized FileBlock toFileBlock() {
        ByteBuffer payload = this.payload();
        payload.flip();
        payload.limit(this.payloadSize);
        FileBlock fileBlock = FileBlock.getInstance(this.fdtSelectionKey.fdtSessionID(), this.uuid, this.fileOffset, payload);
        this.setPayload(null);
        return fileBlock;
    }

    public synchronized boolean isHeaderRead() {
        if (this.isHeaderProcessed) {
            return true;
        }
        ByteBuffer header = this.header();
        if (header != null && !header.hasRemaining()) {
            this.processHeader();
            this.isHeaderProcessed = true;
            return true;
        }
        return false;
    }

    private void processHeader() {
        ByteBuffer header = this.header();
        header.flip();
        this.version = header.getInt();
        this.packetType = header.getInt();
        header.getInt();
        this.payloadSize = header.getInt();
        this.seq = header.getLong();
        this.tstamp = header.getLong();
        this.uuid = new UUID(header.getLong(), header.getLong());
        this.fileOffset = header.getLong();
        if (!this.useFixedSizeBlocks) {
            this.payload().limit(this.payloadSize);
        }
    }

    @Override
    public synchronized void setBuffers(ByteBuffer header, ByteBuffer payload) {
        super.setBuffers(header, payload);
        this.isHeaderProcessed = false;
    }

    public synchronized boolean isPayloadRead() {
        ByteBuffer payload = this.payload();
        return payload != null && !payload.hasRemaining();
    }
}

