/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator.bc;

import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD4Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Memoable;

class BcUtil {
    BcUtil() {
    }

    static Digest createDigest(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        Memoable memoable;
        if (algorithmIdentifier.getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
            memoable = new SHA1Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
            memoable = new SHA224Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
            memoable = new SHA256Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha384)) {
            memoable = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha512)) {
            memoable = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.md5)) {
            memoable = new MD5Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.md4)) {
            memoable = new MD4Digest();
        } else {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return memoable;
    }
}

