/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.transport.commons;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedIOException;

public class ExtendedHttpConnection
extends HttpConnection {
    private static Log logger = LogFactory.getLog(ExtendedHttpConnection.class);
    private boolean staleChecking = true;
    private boolean fromPool = false;
    private CommonsHttpMethodRetryHandler retryHandler;
    private HostConfiguration hostConfiguration;

    public ExtendedHttpConnection(HostConfiguration hc, boolean staleChecking) {
        super(hc);
        this.hostConfiguration = hc;
        this.staleChecking = staleChecking;
    }

    protected HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    protected void setFromPool(boolean fromPool) {
        this.fromPool = fromPool;
    }

    protected boolean isFromPool() {
        return this.fromPool;
    }

    protected HttpMethodRetryHandler getRetryHandler() {
        if (this.retryHandler == null) {
            this.retryHandler = new CommonsHttpMethodRetryHandler();
        }
        return this.retryHandler;
    }

    public void writeLine() throws IOException, IllegalStateException {
        super.writeLine();
        if (this.staleChecking) {
            this.flushRequestOutputStream();
        }
    }

    class CommonsHttpMethodRetryHandler
    implements HttpMethodRetryHandler {
        CommonsHttpMethodRetryHandler() {
        }

        public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
            if (!ExtendedHttpConnection.this.isFromPool()) {
                return false;
            }
            if (exception instanceof InterruptedIOException) {
                return false;
            }
            if (exception instanceof UnknownHostException) {
                return false;
            }
            if (exception instanceof ChainedIOException) {
                return false;
            }
            if (!method.isRequestSent() && executionCount == 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Retrying connection: " + (Object)((Object)ExtendedHttpConnection.this));
                }
                return true;
            }
            return false;
        }
    }
}

