/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.net.ServerSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.HostPort;
import org.globus.ftp.Session;
import org.globus.ftp.dc.ActiveStartTransferTask;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.EBlockImageDCWriter;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.GridFTPActiveConnectTask;
import org.globus.ftp.dc.GridFTPDataChannel;
import org.globus.ftp.dc.GridFTPDataChannelFactory;
import org.globus.ftp.dc.GridFTPPassiveConnectTask;
import org.globus.ftp.dc.ManagedSocketBox;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.SocketPool;
import org.globus.ftp.dc.Task;
import org.globus.ftp.dc.TaskThread;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.extended.GridFTPServerFacade;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;

public class TransferThreadManager {
    static Log logger = LogFactory.getLog(TransferThreadManager.class.getName());
    protected SocketPool socketPool;
    protected GridFTPServerFacade facade;
    protected BasicServerControlChannel localControlChannel;
    protected GridFTPSession gSession;
    protected TaskThread taskThread;
    protected int transferThreadCount = 0;
    protected DataChannelFactory dataChannelFactory;

    public TransferThreadManager(SocketPool socketPool, GridFTPServerFacade facade, BasicServerControlChannel myControlChannel, GridFTPSession gSession) {
        this.socketPool = socketPool;
        this.facade = facade;
        this.gSession = gSession;
        this.localControlChannel = myControlChannel;
        this.dataChannelFactory = new GridFTPDataChannelFactory();
    }

    public void activeConnect(HostPort hp, int connections) {
        for (int i = 0; i < connections; ++i) {
            ManagedSocketBox sbox = new ManagedSocketBox();
            logger.debug("adding new empty socketBox to the socket pool");
            this.socketPool.add(sbox);
            logger.debug("connecting active socket " + i + "; total cached sockets = " + this.socketPool.count());
            GridFTPActiveConnectTask task = new GridFTPActiveConnectTask(hp, this.localControlChannel, sbox, this.gSession);
            this.runTask(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeClose(TransferContext context, int connections) {
        try {
            for (int i = 0; i < connections; ++i) {
                SocketBox sbox = this.socketPool.checkOut();
                try {
                    GridFTPDataChannel dc = new GridFTPDataChannel(this.gSession, sbox);
                    EBlockImageDCWriter writer = (EBlockImageDCWriter)dc.getDataChannelSink(context);
                    writer.setDataStream(sbox.getSocket().getOutputStream());
                    writer.close();
                    continue;
                }
                finally {
                    this.socketPool.remove(sbox);
                    sbox.setSocket(null);
                }
            }
        }
        catch (Exception e) {
            FTPServerFacade.exceptionToControlChannel(e, "closing of a reused connection failed", this.localControlChannel);
        }
    }

    public synchronized void startTransfer(DataSource source, TransferContext context, int connections, boolean reusable) throws ServerException {
        if (this.transferThreadCount != 0) {
            throw new ServerException(5);
        }
        for (int i = 0; i < connections; ++i) {
            logger.debug("checking out a socket; total cached sockets = " + this.socketPool.count() + "; free = " + this.socketPool.countFree() + "; busy = " + this.socketPool.countBusy());
            SocketBox sbox = this.socketPool.checkOut();
            if (sbox == null) {
                logger.debug("No free sockets available, aborting.");
                return;
            }
            ((ManagedSocketBox)sbox).setReusable(reusable);
            ActiveStartTransferTask task = new ActiveStartTransferTask(source, this.localControlChannel, sbox, (Session)this.gSession, this.dataChannelFactory, context);
            this.runTask(task);
        }
    }

    public synchronized void startTransfer(DataSink sink, TransferContext context, int connections, boolean reusable) throws ServerException {
        if (this.transferThreadCount != 0) {
            throw new ServerException(5);
        }
        for (int i = 0; i < connections; ++i) {
            logger.debug("checking out a socket; total cached sockets = " + this.socketPool.count() + "; free = " + this.socketPool.countFree() + "; busy = " + this.socketPool.countBusy());
            SocketBox sbox = this.socketPool.checkOut();
            if (sbox == null) {
                logger.debug("No free sockets available, aborting.");
                return;
            }
            ((ManagedSocketBox)sbox).setReusable(reusable);
            ActiveStartTransferTask task = new ActiveStartTransferTask(sink, this.localControlChannel, sbox, (Session)this.gSession, this.dataChannelFactory, context);
            this.runTask(task);
        }
    }

    public synchronized void passiveConnect(DataSink sink, TransferContext context, int connections, ServerSocket serverSocket) throws ServerException {
        if (this.transferThreadCount != 0) {
            throw new ServerException(5);
        }
        for (int i = 0; i < connections; ++i) {
            GridFTPPassiveConnectTask task = new GridFTPPassiveConnectTask(serverSocket, sink, this.localControlChannel, this.gSession, this.dataChannelFactory, (EBlockParallelTransferContext)context);
            this.runTask(task);
        }
    }

    public synchronized void passiveConnect(DataSource source, TransferContext context, ServerSocket serverSocket) throws ServerException {
        if (this.transferThreadCount != 0) {
            throw new ServerException(5);
        }
        GridFTPPassiveConnectTask task = new GridFTPPassiveConnectTask(serverSocket, source, this.localControlChannel, this.gSession, this.dataChannelFactory, (EBlockParallelTransferContext)context);
        this.runTask(task);
    }

    public synchronized int getTransferThreadCount() {
        return this.transferThreadCount;
    }

    public synchronized void transferThreadStarting() {
        ++this.transferThreadCount;
        logger.debug("one transfer started, total active = " + this.transferThreadCount);
    }

    public synchronized void transferThreadTerminating() {
        --this.transferThreadCount;
        logger.debug("one transfer terminated, total active = " + this.transferThreadCount);
    }

    private synchronized void runTask(Task task) {
        if (this.taskThread == null) {
            this.taskThread = new TaskThread();
        }
        this.taskThread.runTask(task);
    }

    public synchronized void stopTaskThread() {
        if (this.taskThread != null) {
            this.taskThread.stop();
            this.taskThread.join();
            this.taskThread = null;
        }
    }

    public void close() {
        this.stopTaskThread();
    }
}

