/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.vanilla.BasicClientControlChannel;
import org.globus.ftp.vanilla.Command;
import org.globus.ftp.vanilla.Flag;
import org.globus.ftp.vanilla.Reply;

public class FTPControlChannel
extends BasicClientControlChannel {
    private static Log logger = LogFactory.getLog(FTPControlChannel.class.getName());
    public static final String CRLF = "\r\n";
    private static final int WAIT_FOREVER = -1;
    protected Socket socket;
    protected BufferedReader ftpIn;
    protected InputStream rawFtpIn;
    protected OutputStream ftpOut;
    protected String host;
    protected int port;
    protected boolean hasBeenOpened = false;
    private boolean ipv6 = false;
    private Reply lastReply;

    public FTPControlChannel(String host, int port) {
        this.host = host;
        this.port = port;
        this.ipv6 = this.host.indexOf(58) != -1;
    }

    public FTPControlChannel(InputStream in, OutputStream out) {
        this.setInputStream(in);
        this.setOutputStream(out);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isIPv6() {
        return this.ipv6;
    }

    protected BufferedReader getBufferedReader() {
        return this.ftpIn;
    }

    protected OutputStream getOutputStream() {
        return this.ftpOut;
    }

    protected void setInputStream(InputStream in) {
        this.rawFtpIn = in;
        this.ftpIn = new BufferedReader(new InputStreamReader(this.rawFtpIn));
    }

    protected void setOutputStream(OutputStream out) {
        this.ftpOut = out;
    }

    public void open() throws IOException, ServerException {
        if (this.hasBeenOpened()) {
            throw new IOException("Attempt to open an already opened connection");
        }
        if (!this.haveStreams()) {
            boolean found = false;
            int i = 0;
            boolean firstPass = true;
            InetAddress[] allIPs = InetAddress.getAllByName(this.host);
            while (!found) {
                try {
                    logger.debug("opening control channel to " + allIPs[i] + " : " + this.port);
                    InetSocketAddress isa = new InetSocketAddress(allIPs[i], this.port);
                    this.socket = new Socket();
                    this.socket.setSoTimeout(CoGProperties.getDefault().getSocketTimeout());
                    this.socket.connect(isa, CoGProperties.getDefault().getSocketTimeout());
                    found = true;
                }
                catch (IOException ioEx) {
                    logger.debug("failed connecting to  " + allIPs[i] + " : " + this.port + ":" + ioEx);
                    if (++i != allIPs.length) continue;
                    if (firstPass) {
                        firstPass = false;
                        i = 0;
                        continue;
                    }
                    throw ioEx;
                }
            }
            String pv = System.getProperty("org.globus.ftp.IPNAME");
            this.host = pv != null ? this.socket.getInetAddress().getHostAddress() : this.socket.getInetAddress().getCanonicalHostName();
            this.setInputStream(this.socket.getInputStream());
            this.setOutputStream(this.socket.getOutputStream());
        }
        this.readInitialReplies();
        this.hasBeenOpened = true;
    }

    protected void readInitialReplies() throws IOException, ServerException {
        Reply reply = null;
        try {
            reply = this.read();
        }
        catch (FTPReplyParseException rpe) {
            throw ServerException.embedFTPReplyParseException(rpe, "Received faulty initial reply");
        }
        if (Reply.isPositivePreliminary(reply)) {
            try {
                reply = this.read();
            }
            catch (FTPReplyParseException rpe) {
                throw ServerException.embedFTPReplyParseException(rpe, "Received faulty second reply");
            }
        }
        if (!Reply.isPositiveCompletion(reply)) {
            this.close();
            throw ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(reply), "Server refused connection.");
        }
    }

    public Reply getLastReply() {
        return this.lastReply;
    }

    public void close() throws IOException {
        logger.debug("ftp socket closed");
        if (this.ftpIn != null) {
            this.ftpIn.close();
        }
        if (this.ftpOut != null) {
            this.ftpOut.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.hasBeenOpened = false;
    }

    private int checkSocketDone(Flag aborted, int ioDelay, int maxWait) throws ServerException, IOException, InterruptedException {
        int oldTOValue = this.socket.getSoTimeout();
        int c = -10;
        int time = 0;
        boolean done = false;
        if (ioDelay <= 0) {
            ioDelay = 2000;
        }
        while (!done) {
            try {
                if (aborted.flag) {
                    throw new InterruptedException();
                }
                this.socket.setSoTimeout(ioDelay);
                this.ftpIn.mark(2);
                c = this.ftpIn.read();
                done = true;
            }
            catch (SocketTimeoutException e) {
                logger.debug("temp timeout" + e);
            }
            catch (Exception e) {
                throw new InterruptedException();
            }
            finally {
                this.ftpIn.reset();
                this.socket.setSoTimeout(oldTOValue);
            }
            if ((time += ioDelay) <= maxWait || maxWait == -1) continue;
            throw new ServerException(4);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Flag aborted, int ioDelay, int maxWait) throws ServerException, IOException, InterruptedException {
        int oldTimeout = this.socket.getSoTimeout();
        try {
            int c = 0;
            if (maxWait != -1) {
                this.socket.setSoTimeout(maxWait);
            } else {
                this.socket.setSoTimeout(0);
            }
            c = this.checkSocketDone(aborted, ioDelay, maxWait);
            if (c != 0) {
                return;
            }
            logger.debug("Server sent \\0; resume wait");
            try {
                c = this.ftpIn.read();
                c = this.checkSocketDone(aborted, ioDelay, maxWait);
            }
            catch (SocketTimeoutException e) {
                throw new ServerException(4);
            }
            catch (EOFException e) {
                throw new InterruptedException();
            }
        }
        finally {
            this.socket.setSoTimeout(oldTimeout);
        }
    }

    public Reply read() throws ServerException, IOException, FTPReplyParseException, EOFException {
        Reply reply = new Reply(this.ftpIn);
        if (logger.isDebugEnabled()) {
            logger.debug("Control channel received: " + reply);
        }
        this.lastReply = reply;
        return reply;
    }

    public void abortTransfer() {
    }

    public void write(Command cmd) throws IOException, IllegalArgumentException {
        if (cmd == null) {
            throw new IllegalArgumentException("null argument: cmd");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Control channel sending: " + cmd);
        }
        this.writeStr(cmd.toString());
    }

    public Reply exchange(Command cmd) throws ServerException, IOException, FTPReplyParseException {
        this.write(cmd);
        return this.read();
    }

    public Reply execute(Command cmd) throws ServerException, IOException, FTPReplyParseException, UnexpectedReplyCodeException {
        Reply reply = this.exchange(cmd);
        if (!Reply.isPositiveCompletion(reply)) {
            throw new UnexpectedReplyCodeException(reply);
        }
        return reply;
    }

    protected void writeln(String msg) throws IOException {
        this.writeStr(msg + CRLF);
    }

    protected void writeStr(String msg) throws IOException {
        this.ftpOut.write(msg.getBytes());
        this.ftpOut.flush();
    }

    protected boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    protected boolean haveStreams() {
        return this.ftpIn != null && this.ftpOut != null;
    }
}

