/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.ProviderLoader;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.X509Credential;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.gsi.gssapi.ClosedGSSException;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.GlobusGSSException;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.globus.gsi.gssapi.GlobusGSSName;
import org.globus.gsi.gssapi.KeyPairCache;
import org.globus.gsi.gssapi.SSLUtil;
import org.globus.gsi.jsse.SSLConfigurator;
import org.globus.gsi.stores.ResourceSigningPolicyStore;
import org.globus.gsi.stores.Stores;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.CertificateUtil;
import org.globus.gsi.util.ProxyCertificateUtil;
import org.globus.util.I18n;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GlobusGSSContextImpl
implements ExtendedGSSContext {
    private static Log logger = LogFactory.getLog(GlobusGSSContextImpl.class.getName());
    private static I18n i18n = I18n.getI18n("org.globus.gsi.gssapi.errors", GlobusGSSContextImpl.class.getClassLoader());
    private KeyPairCache keyPairCache = KeyPairCache.getKeyPairCache();
    public static final int GSI_WRAP = 26;
    private static final int GSI_SEQUENCE_SIZE = 8;
    private static final int GSI_MESSAGE_DIGEST_PADDING = 12;
    private static final String[] ENABLED_PROTOCOLS;
    private static final String[] GRAM_PROTOCOLS;
    private static final String[] NO_ENCRYPTION;
    private static final String[] GRAM_ENCRYPTION_CIPHER_SUITES;
    private static final String[] GRAM_NO_ENCRYPTION_CIPHER_SUITES;
    private static final byte[] DELEGATION_TOKEN;
    private static final int UNDEFINED = 0;
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    protected int state = 0;
    private static final int HANDSHAKE = 0;
    private static final int CLIENT_START_DEL = 2;
    private static final int CLIENT_END_DEL = 3;
    private static final int SERVER_START_DEL = 4;
    private static final int SERVER_END_DEL = 5;
    protected int delegationState = 0;
    private static final int DELEGATION_START = 0;
    private static final int DELEGATION_SIGN_CERT = 1;
    private static final int DELEGATION_COMPLETE_CRED = 2;
    protected ExtendedGSSCredential delegatedCred;
    protected boolean delegationFinished = false;
    protected boolean credentialDelegation = false;
    protected boolean anonymity = false;
    protected boolean encryption = true;
    protected boolean established = false;
    protected GSSName sourceName = null;
    protected GSSName targetName = null;
    protected int role = 0;
    protected ExtendedGSSCredential delegCred;
    protected GSIConstants.DelegationType delegationType = GSIConstants.DelegationType.LIMITED;
    protected Integer gssMode = GSIConstants.MODE_GSI;
    protected Boolean checkContextExpiration = Boolean.FALSE;
    protected Boolean rejectLimitedProxy = Boolean.FALSE;
    protected Boolean requireClientAuth = Boolean.TRUE;
    protected Boolean acceptNoClientCerts = Boolean.FALSE;
    protected Boolean requireAuthzWithDelegation = Boolean.TRUE;
    protected Boolean forceSSLv3AndConstrainCipherSuitesForGram = Boolean.FALSE;
    protected GlobusGSSCredentialImpl ctxCred;
    protected GSSName expectedTargetName = null;
    protected Date goodUntil = null;
    protected SSLConfigurator sslConfigurator = null;
    protected SSLContext sslContext = null;
    protected SSLEngine sslEngine = null;
    protected boolean conn = false;
    private byte[] savedInBytes = null;
    private ByteBuffer outByteBuff = null;
    protected BouncyCastleCertProcessingFactory certFactory;
    protected KeyPair keyPair;
    protected TrustedCertificates tc;
    protected Map proxyPolicyHandlers;
    protected Boolean peerLimited = null;
    private String[] bannedCiphers = new String[0];

    public GlobusGSSContextImpl(GSSName target, GlobusGSSCredentialImpl cred) throws GSSException {
        if (cred == null) {
            throw new GSSException(13);
        }
        this.expectedTargetName = target;
        this.ctxCred = cred;
        try {
            this.sslConfigurator = new SSLConfigurator();
            if (System.getProperty("com.sun.net.ssl.rsaPreMasterSecretFix") == null) {
                System.setProperty("com.sun.net.ssl.rsaPreMasterSecretFix", "true");
            }
            System.setProperty("jsse.enableCBCProtection", "false");
        }
        catch (Exception e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    private void runDelegatedTasks(SSLEngine engine) throws Exception {
        Runnable runnable;
        while ((runnable = engine.getDelegatedTask()) != null) {
            logger.debug("\trunning delegated task...");
            runnable.run();
        }
        SSLEngineResult.HandshakeStatus hsStatus = engine.getHandshakeStatus();
        if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            throw new Exception("handshake shouldn't need additional tasks");
        }
        logger.debug("\tnew HandshakeStatus: " + (Object)((Object)hsStatus));
    }

    private X509Certificate bcConvert(X509Certificate cert) throws GSSException {
        if (!(cert instanceof X509CertificateObject)) {
            ByteArrayInputStream inputStream = null;
            try {
                inputStream = new ByteArrayInputStream(cert.getEncoded());
                X509Certificate x509Certificate = CertificateLoadUtil.loadCertificate(inputStream);
                return x509Certificate;
            }
            catch (Exception e) {
                throw new GlobusGSSException(11, (Throwable)e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e) {
                        logger.warn("Unable to close streamreader.");
                    }
                }
            }
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] acceptSecContext(byte[] inBuff, int off, int len) throws GSSException {
        ByteBuffer inByteBuff;
        logger.debug("enter acceptSecContext");
        if (!this.conn) {
            this.role = 2;
            logger.debug("enter initializing in acceptSecContext");
            if (this.ctxCred.getName().isAnonymous()) {
                throw new GlobusGSSException(9, 102, "acceptCtx00");
            }
            if (this.ctxCred.getUsage() != 2 && this.ctxCred.getUsage() != 0) {
                throw new GlobusGSSException(9, 102, "badCredUsage");
            }
            this.setCredential();
            try {
                this.init(this.role);
            }
            catch (SSLException e) {
                throw new GlobusGSSException(11, (Throwable)e);
            }
            this.conn = true;
            logger.debug("done initializing in acceptSecContext");
        }
        this.outByteBuff.clear();
        if (this.savedInBytes != null) {
            if (len > 0) {
                byte[] allInBytes = new byte[this.savedInBytes.length + len];
                logger.debug("ALLOCATED for allInBytes " + this.savedInBytes.length + " + " + len + " bytes\n");
                System.arraycopy(this.savedInBytes, 0, allInBytes, 0, this.savedInBytes.length);
                System.arraycopy(inBuff, off, allInBytes, this.savedInBytes.length, len);
                inByteBuff = ByteBuffer.wrap(allInBytes, 0, allInBytes.length);
            } else {
                inByteBuff = ByteBuffer.wrap(this.savedInBytes, 0, this.savedInBytes.length);
            }
            this.savedInBytes = null;
        } else {
            inByteBuff = ByteBuffer.wrap(inBuff, off, len);
        }
        switch (this.state) {
            case 0: {
                try {
                    Certificate[] chain;
                    logger.debug("STATUS BEFORE: " + this.sslEngine.getHandshakeStatus().toString());
                    SSLEngineResult.HandshakeStatus handshake_status = this.sslEngine.getHandshakeStatus();
                    if (handshake_status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        throw new Exception("GSSAPI in HANDSHAKE state but SSLEngine in NOT_HANDSHAKING state!");
                    }
                    this.outByteBuff = this.sslProcessHandshake(inByteBuff, this.outByteBuff);
                    logger.debug("STATUS AFTER: " + this.sslEngine.getHandshakeStatus().toString());
                    this.outByteBuff.flip();
                    if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
                    logger.debug("acceptSecContext handshake finished");
                    this.handshakeFinished();
                    for (X509Certificate cert : this.ctxCred.getCertificateChain()) {
                        this.setGoodUntil(cert.getNotAfter());
                    }
                    this.targetName = this.ctxCred.getName();
                    try {
                        chain = this.sslEngine.getSession().getPeerCertificates();
                    }
                    catch (SSLPeerUnverifiedException e) {
                        chain = null;
                    }
                    if (chain == null || chain.length == 0) {
                        this.sourceName = new GlobusGSSName();
                        this.anonymity = true;
                    } else {
                        for (X509Certificate cert : (X509Certificate[])chain) {
                            this.setGoodUntil(cert.getNotAfter());
                        }
                        String identity = BouncyCastleUtil.getIdentity(this.bcConvert(BouncyCastleUtil.getIdentityCertificate((X509Certificate[])chain)));
                        this.sourceName = new GlobusGSSName(CertificateUtil.toGlobusID(identity, false));
                        this.peerLimited = ProxyCertificateUtil.isLimitedProxy(BouncyCastleUtil.getCertificateType((X509Certificate)chain[0]));
                        logger.debug("Peer Identity is: " + identity + " Target name is: " + this.targetName + " Limited Proxy: " + this.peerLimited.toString());
                        this.anonymity = false;
                    }
                    if (this.gssMode == GSIConstants.MODE_GSI) {
                        this.state = 4;
                        break;
                    }
                    this.setDone();
                    break;
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (Exception e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
            case 4: {
                try {
                    Certificate[] chain;
                    if (inByteBuff.remaining() <= 0) {
                        return null;
                    }
                    this.outByteBuff = this.sslDataUnwrap(inByteBuff, this.outByteBuff);
                    this.outByteBuff.flip();
                    byte[] delChar = new byte[this.outByteBuff.remaining()];
                    this.outByteBuff.get(delChar, 0, delChar.length);
                    if (!Arrays.equals(delChar, DELEGATION_TOKEN)) {
                        this.setDone();
                        break;
                    }
                    try {
                        chain = this.sslEngine.getSession().getPeerCertificates();
                    }
                    catch (SSLPeerUnverifiedException e) {
                        chain = null;
                    }
                    if (chain == null || chain.length == 0) {
                        throw new GlobusGSSException(11, 30, "noClientCert");
                    }
                    X509Certificate tmpCert = (X509Certificate)chain[0];
                    byte[] req = this.generateCertRequest(tmpCert);
                    inByteBuff = ByteBuffer.wrap(req, 0, req.length);
                    this.outByteBuff.clear();
                    this.outByteBuff = this.sslDataWrap(inByteBuff, this.outByteBuff);
                    this.outByteBuff.flip();
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                this.state = 5;
                break;
            }
            case 5: {
                try {
                    if (inByteBuff.remaining() <= 0) {
                        return null;
                    }
                    this.outByteBuff = this.sslDataUnwrap(inByteBuff, this.outByteBuff);
                    this.outByteBuff.flip();
                    if (!this.outByteBuff.hasRemaining()) break;
                    byte[] buf = new byte[this.outByteBuff.remaining()];
                    this.outByteBuff.get(buf, 0, buf.length);
                    ByteArrayInputStream inStream = new ByteArrayInputStream(buf, 0, buf.length);
                    CertificateFactory cf = null;
                    X509Certificate certificate = null;
                    try {
                        cf = CertificateFactory.getInstance("X.509");
                        certificate = (X509Certificate)cf.generateCertificate(inStream);
                    }
                    finally {
                        inStream.close();
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Received delegated cert: " + certificate.toString());
                    }
                    this.verifyDelegatedCert(certificate);
                    Certificate[] chain = this.sslEngine.getSession().getPeerCertificates();
                    int chainLen = chain.length;
                    X509Certificate[] newChain = new X509Certificate[chainLen + 1];
                    newChain[0] = this.bcConvert(certificate);
                    for (int i = 0; i < chainLen; ++i) {
                        newChain[i + 1] = this.bcConvert((X509Certificate)chain[i]);
                    }
                    X509Credential proxy = new X509Credential(this.keyPair.getPrivate(), newChain);
                    this.delegCred = new GlobusGSSCredentialImpl(proxy, 0);
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                this.setDone();
                break;
            }
            default: {
                throw new GSSException(11);
            }
        }
        if (inByteBuff.hasRemaining()) {
            logger.debug("Not all data processed; Original: " + len + " Remaining: " + inByteBuff.remaining() + " Handshaking status: " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
            logger.debug("SAVING unprocessed " + inByteBuff.remaining() + "BYTES\n");
            this.savedInBytes = new byte[inByteBuff.remaining()];
            inByteBuff.get(this.savedInBytes, 0, this.savedInBytes.length);
        }
        logger.debug("exit acceptSecContext");
        if (this.outByteBuff.hasRemaining()) {
            byte[] out = new byte[this.outByteBuff.remaining()];
            this.outByteBuff.get(out, 0, out.length);
            return out;
        }
        return null;
    }

    private ByteBuffer sslDataWrap(ByteBuffer inBBuff, ByteBuffer outBBuff) throws GSSException {
        try {
            if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                throw new Exception("SSLEngine handshaking needed! HandshakeStatus: " + this.sslEngine.getHandshakeStatus().toString());
            }
            int iter = 0;
            do {
                logger.debug("PROCESSING DATA (WRAP) " + ++iter + ": " + inBBuff.remaining());
                SSLEngineResult result = this.sslEngine.wrap(inBBuff, outBBuff);
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.runDelegatedTasks(this.sslEngine);
                    continue;
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    int pktSize = this.sslEngine.getSession().getPacketBufferSize();
                    ByteBuffer b = ByteBuffer.allocate(pktSize + outBBuff.position());
                    outBBuff.flip();
                    b.put(outBBuff);
                    outBBuff = b;
                    continue;
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    throw new GlobusGSSException(11, (Throwable)new Exception("Unexpected BUFFER_UNDERFLOW; Handshaking status: " + (Object)((Object)this.sslEngine.getHandshakeStatus())));
                }
                if (result.getStatus() == SSLEngineResult.Status.OK) continue;
                throw new GlobusGSSException(11, 29, result.getStatus().toString());
            } while (inBBuff.hasRemaining());
            return outBBuff;
        }
        catch (Exception e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    private ByteBuffer sslDataUnwrap(ByteBuffer inBBuff, ByteBuffer outBBuff) throws GSSException {
        try {
            int iter = 0;
            if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                throw new Exception("SSLEngine handshaking needed! HandshakeStatus: " + this.sslEngine.getHandshakeStatus().toString());
            }
            do {
                logger.debug("PROCESSING DATA (UNWRAP) " + ++iter + ": " + inBBuff.remaining());
                SSLEngineResult result = this.sslEngine.unwrap(inBBuff, outBBuff);
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.runDelegatedTasks(this.sslEngine);
                    continue;
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    int appSize = this.sslEngine.getSession().getApplicationBufferSize();
                    ByteBuffer b = ByteBuffer.allocate(appSize + outBBuff.position());
                    outBBuff.flip();
                    b.put(outBBuff);
                    outBBuff = b;
                    continue;
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    throw new ClosedGSSException();
                }
                if (result.getStatus() == SSLEngineResult.Status.OK) continue;
                throw new GlobusGSSException(11, 29, result.getStatus().toString());
            } while (inBBuff.hasRemaining());
            return outBBuff;
        }
        catch (IllegalArgumentException e) {
            throw new GlobusGSSException(10, (Throwable)e);
        }
        catch (SSLException e) {
            if (e.toString().endsWith("bad record MAC")) {
                throw new GlobusGSSException(6, (Throwable)e);
            }
            if (e.toString().endsWith("ciphertext sanity check failed")) {
                throw new GlobusGSSException(10, (Throwable)e);
            }
            throw new GlobusGSSException(11, (Throwable)e);
        }
        catch (GSSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    private ByteBuffer sslProcessHandshake(ByteBuffer inBBuff, ByteBuffer outBBuff) throws GSSException {
        try {
            block2: while (true) {
                if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    SSLEngineResult result = this.sslEngine.wrap(inBBuff, outBBuff);
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.runDelegatedTasks(this.sslEngine);
                        continue;
                    }
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        int pktSize = this.sslEngine.getSession().getPacketBufferSize();
                        ByteBuffer b = ByteBuffer.allocate(pktSize + outBBuff.position());
                        outBBuff.flip();
                        b.put(outBBuff);
                        outBBuff = b;
                        continue;
                    }
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        throw new GlobusGSSException(11, (Throwable)new Exception("Unexpected BUFFER_UNDERFLOW; Handshaking status: " + (Object)((Object)this.sslEngine.getHandshakeStatus())));
                    }
                    if (result.getStatus() == SSLEngineResult.Status.OK) continue;
                    throw new GlobusGSSException(11, 29, result.getStatus().toString());
                }
                int iter = 0;
                while (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    logger.debug("PROCESSING " + ++iter + ": " + inBBuff.remaining());
                    SSLEngineResult result = this.sslEngine.unwrap(inBBuff, outBBuff);
                    if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        this.runDelegatedTasks(this.sslEngine);
                        continue;
                    }
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        int appSize = this.sslEngine.getSession().getApplicationBufferSize();
                        ByteBuffer b = ByteBuffer.allocate(appSize + outBBuff.position());
                        outBBuff.flip();
                        b.put(outBBuff);
                        outBBuff = b;
                        continue;
                    }
                    if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) break block2;
                    if (result.getStatus() == SSLEngineResult.Status.OK) continue;
                    throw new GlobusGSSException(11, 29, result.getStatus().toString());
                }
                if (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
            }
            return outBBuff;
        }
        catch (Exception e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] initSecContext(byte[] inBuff, int off, int len) throws GSSException {
        GlobusGSSContextImpl.logger.debug("enter initSecContext");
        if (!this.conn) {
            this.role = 1;
            GlobusGSSContextImpl.logger.debug("enter initializing in initSecContext");
            if (this.anonymity || this.ctxCred.getName().isAnonymous()) {
                this.anonymity = true;
            } else {
                this.anonymity = false;
                this.setCredential();
                if (this.ctxCred.getUsage() != 1 && this.ctxCred.getUsage() != 0) {
                    throw new GlobusGSSException(9, 102, "badCredUsage");
                }
            }
            if (this.getCredDelegState()) {
                if (this.gssMode == GSIConstants.MODE_SSL) {
                    throw new GlobusGSSException(11, 7, "initCtx00");
                }
                if (this.anonymity) {
                    throw new GlobusGSSException(11, 7, "initCtx01");
                }
            }
            try {
                this.init(this.role);
            }
            catch (SSLException e) {
                throw new GlobusGSSException(11, (Throwable)e);
            }
            this.conn = true;
            GlobusGSSContextImpl.logger.debug("done initializing in initSecContext");
        }
        GlobusGSSContextImpl.logger.debug("Require authz with delegation: " + this.requireAuthzWithDelegation);
        if (!Boolean.FALSE.equals(this.requireAuthzWithDelegation) && this.expectedTargetName == null && this.getCredDelegState()) {
            throw new GlobusGSSException(11, 7, "initCtx02");
        }
        this.outByteBuff.clear();
        if (this.savedInBytes != null) {
            if (len > 0) {
                allInBytes = new byte[this.savedInBytes.length + len];
                GlobusGSSContextImpl.logger.debug("ALLOCATED for allInBytes " + this.savedInBytes.length + " + " + len + " bytes\n");
                System.arraycopy(this.savedInBytes, 0, allInBytes, 0, this.savedInBytes.length);
                System.arraycopy(inBuff, off, allInBytes, this.savedInBytes.length, len);
                inByteBuff = ByteBuffer.wrap(allInBytes, 0, allInBytes.length);
            } else {
                inByteBuff = ByteBuffer.wrap(this.savedInBytes, 0, this.savedInBytes.length);
            }
            this.savedInBytes = null;
        } else {
            inByteBuff = ByteBuffer.wrap(inBuff, off, len);
        }
        switch (this.state) {
            case 0: {
                try {
                    GlobusGSSContextImpl.logger.debug("STATUS BEFORE: " + this.sslEngine.getHandshakeStatus().toString());
                    handshake_status = this.sslEngine.getHandshakeStatus();
                    if (handshake_status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        throw new Exception("GSSAPI in HANDSHAKE state but SSLEngine in NOT_HANDSHAKING state!");
                    }
                    this.outByteBuff = this.sslProcessHandshake(inByteBuff, this.outByteBuff);
                    GlobusGSSContextImpl.logger.debug("STATUS AFTER: " + this.sslEngine.getHandshakeStatus().toString());
                    this.outByteBuff.flip();
                    if (this.sslEngine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
                    GlobusGSSContextImpl.logger.debug("initSecContext handshake finished");
                    this.handshakeFinished();
                    chain = this.sslEngine.getSession().getPeerCertificates();
                    if (!(chain instanceof X509Certificate[])) {
                        throw new Exception("Certificate chain not of type X509Certificate");
                    }
                    for (X509Certificate cert : (X509Certificate[])chain) {
                        this.setGoodUntil(cert.getNotAfter());
                    }
                    identity = BouncyCastleUtil.getIdentity(this.bcConvert(BouncyCastleUtil.getIdentityCertificate((X509Certificate[])chain)));
                    this.targetName = new GlobusGSSName(CertificateUtil.toGlobusID(identity, false));
                    this.peerLimited = ProxyCertificateUtil.isLimitedProxy(BouncyCastleUtil.getCertificateType((X509Certificate)chain[0]));
                    GlobusGSSContextImpl.logger.debug("Peer Identity is: " + identity + " Target name is: " + this.targetName + " Limited Proxy: " + this.peerLimited.toString());
                    if (this.anonymity) {
                        this.sourceName = new GlobusGSSName();
                    } else {
                        for (X509Certificate cert : this.ctxCred.getCertificateChain()) {
                            this.setGoodUntil(cert.getNotAfter());
                        }
                        this.sourceName = this.ctxCred.getName();
                    }
                    if (this.expectedTargetName != null && !this.expectedTargetName.equals(this.targetName)) {
                        throw new GlobusGSSException(15, 25, "authFailed00", new Object[]{this.expectedTargetName, this.targetName});
                    }
                    if (this.gssMode != GSIConstants.MODE_GSI) ** GOTO lbl79
                    this.state = 2;
                    if (this.outByteBuff.remaining() > 0) {
                        break;
                    }
                    ** GOTO lbl85
lbl79:
                    // 1 sources

                    this.setDone();
                    break;
                }
                catch (IOException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                catch (Exception e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
lbl85:
            // 2 sources

            case 2: {
                GlobusGSSContextImpl.logger.debug("CLIENT_START_DEL");
                if (this.state != 2) throw new GSSException(11);
                if (this.outByteBuff.remaining() > 0) {
                    throw new GSSException(11);
                }
                if (inByteBuff.hasRemaining()) {
                    throw new GlobusGSSException(11, (Throwable)new Exception("Not all data processed; Original: " + len + " Remaining: " + inByteBuff.remaining() + " Handshaking status: " + (Object)this.sslEngine.getHandshakeStatus()));
                }
                this.outByteBuff.clear();
                try {
                    if (this.getCredDelegState()) {
                        deleg = Character.toString('D');
                        this.state = 3;
                    } else {
                        deleg = Character.toString('0');
                        this.setDone();
                    }
                    a = deleg.getBytes("US-ASCII");
                    inByteBuff = ByteBuffer.wrap(a, 0, a.length);
                    this.outByteBuff = this.sslDataWrap(inByteBuff, this.outByteBuff);
                    this.outByteBuff.flip();
                    break;
                }
                catch (Exception e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
            }
            case 3: {
                GlobusGSSContextImpl.logger.debug("CLIENT_END_DEL");
                if (!inByteBuff.hasRemaining()) {
                    throw new GSSException(10);
                }
                byteArrayInputStream = null;
                try {
                    this.outByteBuff = this.sslDataUnwrap(inByteBuff, this.outByteBuff);
                    this.outByteBuff.flip();
                    if (!this.outByteBuff.hasRemaining()) {
                        if (byteArrayInputStream == null) break;
                    }
                    ** GOTO lbl-1000
                }
                catch (GeneralSecurityException e) {
                    try {
                        throw new GlobusGSSException(11, (Throwable)e);
                        catch (IOException e) {
                            throw new GlobusGSSException(11, (Throwable)e);
                        }
                    }
                    catch (Throwable var12_26) {
                        if (byteArrayInputStream == null) throw var12_26;
                        try {
                            byteArrayInputStream.close();
                            throw var12_26;
                        }
                        catch (Exception e) {
                            GlobusGSSContextImpl.logger.warn("Unable to close stream.");
                        }
                        throw var12_26;
                    }
                }
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception e) {
                    GlobusGSSContextImpl.logger.warn("Unable to close stream.");
                }
                break;
lbl-1000:
                // 1 sources

                {
                    certReq = new byte[this.outByteBuff.remaining()];
                    this.outByteBuff.get(certReq, 0, certReq.length);
                    chain = this.ctxCred.getCertificateChain();
                    byteArrayInputStream = new ByteArrayInputStream(certReq);
                    cert = this.certFactory.createCertificate((InputStream)byteArrayInputStream, chain[0], this.ctxCred.getPrivateKey(), -1, BouncyCastleCertProcessingFactory.decideProxyType(chain[0], this.delegationType));
                    enc = cert.getEncoded();
                    inByteBuff = ByteBuffer.wrap(enc, 0, enc.length);
                    this.outByteBuff.clear();
                    this.outByteBuff = this.sslDataWrap(inByteBuff, this.outByteBuff);
                    this.outByteBuff.flip();
                    this.setDone();
                    if (byteArrayInputStream == null) break;
                }
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception e) {
                    GlobusGSSContextImpl.logger.warn("Unable to close stream.");
                }
                break;
            }
            default: {
                throw new GSSException(11);
            }
        }
        if (inByteBuff.hasRemaining()) {
            GlobusGSSContextImpl.logger.debug("Not all data processed; Original: " + len + " Remaining: " + inByteBuff.remaining() + " Handshaking status: " + (Object)this.sslEngine.getHandshakeStatus());
            GlobusGSSContextImpl.logger.debug("SAVING unprocessed " + inByteBuff.remaining() + "BYTES\n");
            this.savedInBytes = new byte[inByteBuff.remaining()];
            inByteBuff.get(this.savedInBytes, 0, this.savedInBytes.length);
        }
        GlobusGSSContextImpl.logger.debug("exit initSecContext");
        if (this.outByteBuff.hasRemaining() == false) return null;
        out = new byte[this.outByteBuff.remaining()];
        this.outByteBuff.get(out, 0, out.length);
        return out;
    }

    private void setDone() {
        logger.debug("DONE with Handshaking and any initial cred delegation");
        this.established = true;
    }

    private void setGoodUntil(Date date) {
        if (this.goodUntil == null) {
            this.goodUntil = date;
        } else if (date.before(this.goodUntil)) {
            this.goodUntil = date;
        }
    }

    private void init(int how) throws GSSException, SSLException {
        try {
            if (this.tc == null) {
                KeyStore trustStore = Stores.getDefaultTrustStore();
                this.sslConfigurator.setTrustAnchorStore(trustStore);
                String[] crlStore = Stores.getDefaultCRLStore();
                this.sslConfigurator.setCrlStore((CertStore)crlStore);
                ResourceSigningPolicyStore sigPolStore = Stores.getDefaultSigningPolicyStore();
                this.sslConfigurator.setPolicyStore(sigPolStore);
            }
            this.sslConfigurator.setRejectLimitProxy(this.rejectLimitedProxy);
            if (this.proxyPolicyHandlers != null) {
                this.sslConfigurator.setHandlers(this.proxyPolicyHandlers);
            }
            this.sslContext = this.sslConfigurator.getSSLContext();
            this.sslEngine = this.sslContext.createSSLEngine();
        }
        catch (Exception e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        if (this.forceSSLv3AndConstrainCipherSuitesForGram.booleanValue()) {
            this.sslEngine.setEnabledProtocols(GRAM_PROTOCOLS);
        } else {
            this.sslEngine.setEnabledProtocols(ENABLED_PROTOCOLS);
        }
        logger.debug("SUPPORTED PROTOCOLS: " + Arrays.toString(this.sslEngine.getSupportedProtocols()) + "; ENABLED PROTOCOLS: " + Arrays.toString(this.sslEngine.getEnabledProtocols()));
        ArrayList<String> cs = new ArrayList<String>();
        if (this.encryption) {
            if (this.forceSSLv3AndConstrainCipherSuitesForGram.booleanValue()) {
                for (String cipherSuite : GRAM_ENCRYPTION_CIPHER_SUITES) {
                    cs.add(cipherSuite);
                }
            } else {
                cs.addAll(Arrays.asList(this.sslEngine.getEnabledCipherSuites()));
            }
        } else if (this.forceSSLv3AndConstrainCipherSuitesForGram.booleanValue()) {
            for (String cipherSuite : GRAM_NO_ENCRYPTION_CIPHER_SUITES) {
                cs.add(cipherSuite);
            }
        } else {
            for (String cipherSuite : NO_ENCRYPTION) {
                cs.add(cipherSuite);
            }
            cs.addAll(Arrays.asList(this.sslEngine.getEnabledCipherSuites()));
        }
        cs.removeAll(Arrays.asList(this.bannedCiphers));
        String[] testSuite = new String[]{};
        this.sslEngine.setEnabledCipherSuites(cs.toArray(testSuite));
        logger.debug("CIPHER SUITE IS: " + Arrays.toString(this.sslEngine.getEnabledCipherSuites()));
        if (this.requireClientAuth.booleanValue() == Boolean.TRUE.booleanValue()) {
            this.sslEngine.setNeedClientAuth(this.requireClientAuth);
        } else {
            this.sslEngine.setWantClientAuth(this.acceptNoClientCerts == false);
        }
        this.sslEngine.setUseClientMode(how == 1);
        this.certFactory = BouncyCastleCertProcessingFactory.getDefault();
        this.state = 0;
        int appSize = this.sslEngine.getSession().getApplicationBufferSize();
        this.outByteBuff = ByteBuffer.allocate(appSize);
        this.sslEngine.beginHandshake();
    }

    private void handshakeFinished() throws IOException {
        String cs = this.sslEngine.getSession().getCipherSuite();
        this.encryption = !cs.contains("WITH_NULL");
        logger.debug("encryption alg: " + cs);
    }

    private void setCredential() throws GSSException {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            X509Credential cred = this.ctxCred.getX509Credential();
            keyStore.setKeyEntry("default", cred.getPrivateKey(), "password".toCharArray(), cred.getCertificateChain());
            this.sslConfigurator.setCredentialStore(keyStore);
            this.sslConfigurator.setCredentialStorePassword("password");
        }
        catch (GeneralSecurityException e) {
            throw new GlobusGSSException(9, (Throwable)e);
        }
        catch (Exception e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    public byte[] wrap(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        this.checkContext();
        logger.debug("enter wrap");
        byte[] token = null;
        boolean doGSIWrap = false;
        if (prop != null) {
            if (prop.getQOP() != 0 && prop.getQOP() != 1) {
                throw new GSSException(14);
            }
            boolean bl = doGSIWrap = !prop.getPrivacy() && prop.getQOP() == 1;
        }
        if (doGSIWrap) {
            throw new GSSException(16);
        }
        token = this.wrap(inBuf, off, len);
        if (prop != null) {
            prop.setPrivacy(this.encryption);
            prop.setQOP(0);
        }
        logger.debug("exit wrap");
        return token;
    }

    private byte[] wrap(byte[] inBuf, int off, int len) throws GSSException {
        try {
            ByteBuffer inByteBuff = ByteBuffer.wrap(inBuf, off, len);
            this.outByteBuff.clear();
            this.outByteBuff = this.sslDataWrap(inByteBuff, this.outByteBuff);
            this.outByteBuff.flip();
            if (inByteBuff.hasRemaining()) {
                throw new Exception("Not all data processed; Original: " + len + " Remaining: " + inByteBuff.remaining() + " Handshaking status: " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
            }
        }
        catch (Exception e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
        if (this.outByteBuff.hasRemaining()) {
            byte[] out = new byte[this.outByteBuff.remaining()];
            this.outByteBuff.get(out, 0, out.length);
            return out;
        }
        return null;
    }

    public byte[] unwrap(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        this.checkContext();
        logger.debug("enter unwrap");
        byte[] token = null;
        if (inBuf[off] == 26 && inBuf[off + 1] == 3 && inBuf[off + 2] == 0) {
            throw new GSSException(16);
        }
        token = this.unwrap(inBuf, off, len);
        if (prop != null) {
            prop.setPrivacy(this.encryption);
            prop.setQOP(0);
        }
        logger.debug("exit unwrap");
        return token;
    }

    private byte[] unwrap(byte[] inBuf, int off, int len) throws GSSException {
        ByteBuffer inByteBuff;
        if (this.savedInBytes != null) {
            if (len > 0) {
                byte[] allInBytes = new byte[this.savedInBytes.length + len];
                logger.debug("ALLOCATED for allInBytes " + this.savedInBytes.length + " + " + len + " bytes\n");
                System.arraycopy(this.savedInBytes, 0, allInBytes, 0, this.savedInBytes.length);
                System.arraycopy(inBuf, off, allInBytes, this.savedInBytes.length, len);
                inByteBuff = ByteBuffer.wrap(allInBytes, 0, allInBytes.length);
            } else {
                inByteBuff = ByteBuffer.wrap(this.savedInBytes, 0, this.savedInBytes.length);
            }
            this.savedInBytes = null;
        } else {
            inByteBuff = ByteBuffer.wrap(inBuf, off, len);
        }
        this.outByteBuff.clear();
        this.outByteBuff = this.sslDataUnwrap(inByteBuff, this.outByteBuff);
        this.outByteBuff.flip();
        if (inByteBuff.hasRemaining()) {
            logger.debug("Not all data processed; Original: " + len + " Remaining: " + inByteBuff.remaining() + " Handshaking status: " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
            logger.debug("SAVING unprocessed " + inByteBuff.remaining() + "BYTES\n");
            this.savedInBytes = new byte[inByteBuff.remaining()];
            inByteBuff.get(this.savedInBytes, 0, this.savedInBytes.length);
        }
        if (this.outByteBuff.hasRemaining()) {
            byte[] out = new byte[this.outByteBuff.remaining()];
            this.outByteBuff.get(out, 0, out.length);
            return out;
        }
        return null;
    }

    public void dispose() throws GSSException {
        logger.debug("dipose");
    }

    public boolean isEstablished() {
        return this.established;
    }

    public void requestCredDeleg(boolean state) throws GSSException {
        this.credentialDelegation = state;
    }

    public boolean getCredDelegState() {
        return this.credentialDelegation;
    }

    public boolean isInitiator() throws GSSException {
        if (this.role == 0) {
            throw new GSSException(11);
        }
        return this.role == 1;
    }

    public boolean isProtReady() {
        return this.isEstablished();
    }

    public void requestLifetime(int lifetime) throws GSSException {
        if (lifetime == Integer.MAX_VALUE) {
            throw new GlobusGSSException(11, 102, "badLifetime00");
        }
        if (lifetime != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, lifetime);
            this.setGoodUntil(calendar.getTime());
        }
    }

    public int getLifetime() {
        if (this.goodUntil != null) {
            return (int)((this.goodUntil.getTime() - System.currentTimeMillis()) / 1000L);
        }
        return -1;
    }

    public Oid getMech() throws GSSException {
        return GSSConstants.MECH_OID;
    }

    public GSSCredential getDelegCred() throws GSSException {
        return this.delegCred;
    }

    public void requestConf(boolean state) throws GSSException {
        this.encryption = state;
    }

    public boolean getConfState() {
        return this.encryption;
    }

    public byte[] getMIC(byte[] inBuf, int off, int len, MessageProp prop) throws GSSException {
        throw new GSSException(16);
    }

    public void verifyMIC(byte[] inTok, int tokOff, int tokLen, byte[] inMsg, int msgOff, int msgLen, MessageProp prop) throws GSSException {
        throw new GSSException(16);
    }

    public int initSecContext(InputStream in, OutputStream out) throws GSSException {
        byte[] inToken = null;
        try {
            inToken = !this.conn ? new byte[]{} : SSLUtil.readSslMessage(in);
            byte[] outToken = this.initSecContext(inToken, 0, inToken.length);
            if (outToken != null) {
                out.write(outToken);
                return outToken.length;
            }
            return 0;
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    public void acceptSecContext(InputStream in, OutputStream out) throws GSSException {
        try {
            byte[] inToken = SSLUtil.readSslMessage(in);
            byte[] outToken = this.acceptSecContext(inToken, 0, inToken.length);
            if (outToken != null) {
                out.write(outToken);
            }
        }
        catch (IOException e) {
            throw new GlobusGSSException(11, (Throwable)e);
        }
    }

    public GSSName getSrcName() throws GSSException {
        return this.sourceName;
    }

    public GSSName getTargName() throws GSSException {
        return this.targetName;
    }

    public void requestInteg(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "integOn");
        }
    }

    public boolean getIntegState() {
        return true;
    }

    public void requestSequenceDet(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "seqDet");
        }
    }

    public boolean getSequenceDetState() {
        return true;
    }

    public void requestReplayDet(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "replayDet");
        }
    }

    public boolean getReplayDetState() {
        return true;
    }

    public void requestAnonymity(boolean state) throws GSSException {
        this.anonymity = state;
    }

    public boolean getAnonymityState() {
        return this.anonymity;
    }

    public void requestMutualAuth(boolean state) throws GSSException {
        if (!state) {
            throw new GlobusGSSException(11, 101, "mutualAuthOn");
        }
    }

    public boolean getMutualAuthState() {
        return true;
    }

    protected byte[] generateCertRequest(X509Certificate cert) throws GeneralSecurityException {
        int bits = ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength();
        this.keyPair = this.keyPairCache.getKeyPair(bits);
        return this.certFactory.createCertificateRequest(cert, this.keyPair);
    }

    protected void verifyDelegatedCert(X509Certificate certificate) throws GeneralSecurityException {
        RSAPublicKey pubKey = (RSAPublicKey)certificate.getPublicKey();
        RSAPrivateKey privKey = (RSAPrivateKey)this.keyPair.getPrivate();
        if (!pubKey.getModulus().equals(privKey.getModulus())) {
            throw new GeneralSecurityException(i18n.getMessage("keyMismatch"));
        }
    }

    protected void checkContext() throws GSSException {
        if (!this.conn || !this.isEstablished()) {
            throw new GSSException(12);
        }
        if (this.checkContextExpiration.booleanValue() && this.getLifetime() <= 0) {
            throw new GSSException(7);
        }
    }

    protected void setGssMode(Object value) throws GSSException {
        if (!(value instanceof Integer)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"GSS mode", Integer.class});
        }
        Integer v = (Integer)value;
        if (v != GSIConstants.MODE_GSI && v != GSIConstants.MODE_SSL) {
            throw new GlobusGSSException(11, 101, "badGssMode");
        }
        this.gssMode = v;
    }

    protected void setDelegationType(Object value) throws GSSException {
        GSIConstants.DelegationType v;
        if (value instanceof GSIConstants.DelegationType) {
            v = (GSIConstants.DelegationType)((Object)value);
        } else if (value instanceof Integer) {
            v = GSIConstants.DelegationType.get((Integer)value);
        } else {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"delegation type", GSIConstants.DelegationType.class});
        }
        if (v != GSIConstants.DelegationType.FULL && v != GSIConstants.DelegationType.LIMITED) {
            throw new GlobusGSSException(11, 101, "badDelegType");
        }
        this.delegationType = v;
    }

    protected void setCheckContextExpired(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"check context expired", Boolean.class});
        }
        this.checkContextExpiration = (Boolean)value;
    }

    protected void setRejectLimitedProxy(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"reject limited proxy", Boolean.class});
        }
        this.rejectLimitedProxy = (Boolean)value;
    }

    protected void setRequireClientAuth(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"require client auth", Boolean.class});
        }
        this.requireClientAuth = (Boolean)value;
    }

    protected void setRequireAuthzWithDelegation(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"require authz with delehation", Boolean.class});
        }
        this.requireAuthzWithDelegation = (Boolean)value;
    }

    protected void setAcceptNoClientCerts(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"accept no client certs", Boolean.class});
        }
        this.acceptNoClientCerts = (Boolean)value;
    }

    protected void setForceSslV3AndConstrainCipherSuitesForGram(Object value) throws GSSException {
        if (!(value instanceof Boolean)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"adjust cipher suites for GRAM", Boolean.class});
        }
        this.forceSSLv3AndConstrainCipherSuitesForGram = (Boolean)value;
    }

    protected void setProxyPolicyHandlers(Object value) throws GSSException {
        if (!(value instanceof Map)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"Proxy policy handlers", Map.class});
        }
        this.proxyPolicyHandlers = (Map)value;
    }

    protected void setTrustedCertificates(Object value) throws GSSException {
        if (!(value instanceof TrustedCertificates)) {
            throw new GlobusGSSException(11, 100, "badType", new Object[]{"Trusted certificates", TrustedCertificates.class});
        }
        this.tc = (TrustedCertificates)value;
        TrustedCertificates cfr_ignored_0 = (TrustedCertificates)value;
        this.sslConfigurator.setTrustAnchorStore(TrustedCertificates.getTrustStore());
        TrustedCertificates cfr_ignored_1 = (TrustedCertificates)value;
        this.sslConfigurator.setCrlStore(TrustedCertificates.getcrlStore());
        TrustedCertificates cfr_ignored_2 = (TrustedCertificates)value;
        this.sslConfigurator.setPolicyStore(TrustedCertificates.getsigPolStore());
    }

    public void setOption(Oid option, Object value) throws GSSException {
        if (option == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (value == null) {
            throw new GlobusGSSException(11, 7, "nullOptionValue");
        }
        if (option.equals(GSSConstants.GSS_MODE)) {
            this.setGssMode(value);
        } else if (option.equals(GSSConstants.DELEGATION_TYPE)) {
            this.setDelegationType(value);
        } else if (option.equals(GSSConstants.CHECK_CONTEXT_EXPIRATION)) {
            this.setCheckContextExpired(value);
        } else if (option.equals(GSSConstants.REJECT_LIMITED_PROXY)) {
            this.setRejectLimitedProxy(value);
        } else if (option.equals(GSSConstants.REQUIRE_CLIENT_AUTH)) {
            this.setRequireClientAuth(value);
        } else if (option.equals(GSSConstants.TRUSTED_CERTIFICATES)) {
            this.setTrustedCertificates(value);
        } else if (option.equals(GSSConstants.PROXY_POLICY_HANDLERS)) {
            this.setProxyPolicyHandlers(value);
        } else if (option.equals(GSSConstants.ACCEPT_NO_CLIENT_CERTS)) {
            this.setAcceptNoClientCerts(value);
        } else if (option.equals(GSSConstants.AUTHZ_REQUIRED_WITH_DELEGATION)) {
            this.setRequireAuthzWithDelegation(value);
        } else if (option.equals(GSSConstants.FORCE_SSLV3_AND_CONSTRAIN_CIPHERSUITES_FOR_GRAM)) {
            this.setForceSslV3AndConstrainCipherSuitesForGram(value);
        } else {
            throw new GlobusGSSException(11, 37, "unknownOption", new Object[]{option});
        }
    }

    public Object getOption(Oid option) throws GSSException {
        if (option == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (option.equals(GSSConstants.GSS_MODE)) {
            return this.gssMode;
        }
        if (option.equals(GSSConstants.DELEGATION_TYPE)) {
            return this.delegationType;
        }
        if (option.equals(GSSConstants.CHECK_CONTEXT_EXPIRATION)) {
            return this.checkContextExpiration;
        }
        if (option.equals(GSSConstants.REJECT_LIMITED_PROXY)) {
            return this.rejectLimitedProxy;
        }
        if (option.equals(GSSConstants.REQUIRE_CLIENT_AUTH)) {
            return this.requireClientAuth;
        }
        if (option.equals(GSSConstants.TRUSTED_CERTIFICATES)) {
            return this.tc;
        }
        if (option.equals(GSSConstants.PROXY_POLICY_HANDLERS)) {
            throw new GSSException(16);
        }
        if (option.equals(GSSConstants.ACCEPT_NO_CLIENT_CERTS)) {
            return this.acceptNoClientCerts;
        }
        return null;
    }

    public byte[] initDelegation(GSSCredential credential, Oid mechanism, int lifetime, byte[] buf, int off, int len) throws GSSException {
        logger.debug("Enter initDelegation: " + this.delegationState);
        if (mechanism != null && !mechanism.equals(this.getMech())) {
            throw new GSSException(2);
        }
        if (this.gssMode != GSIConstants.MODE_SSL && buf != null && len > 0) {
            buf = this.unwrap(buf, off, len);
            off = 0;
            len = buf.length;
        }
        byte[] token = null;
        switch (this.delegationState) {
            case 0: {
                this.delegationFinished = false;
                token = DELEGATION_TOKEN;
                this.delegationState = 1;
                break;
            }
            case 1: {
                if (credential == null) {
                    GlobusGSSManagerImpl manager = new GlobusGSSManagerImpl();
                    credential = ((GSSManager)manager).createCredential(0);
                }
                if (!(credential instanceof GlobusGSSCredentialImpl)) {
                    throw new GSSException(9);
                }
                X509Credential cred = ((GlobusGSSCredentialImpl)credential).getX509Credential();
                X509Certificate[] chain = cred.getCertificateChain();
                int time = lifetime == 0 ? -1 : lifetime;
                ByteArrayInputStream inData = null;
                ByteArrayOutputStream out = null;
                try {
                    inData = new ByteArrayInputStream(buf, off, len);
                    X509Certificate cert = this.certFactory.createCertificate((InputStream)inData, chain[0], cred.getPrivateKey(), time, BouncyCastleCertProcessingFactory.decideProxyType(chain[0], this.delegationType));
                    out = new ByteArrayOutputStream();
                    out.write(cert.getEncoded());
                    for (int i = 0; i < chain.length; ++i) {
                        out.write(chain[i].getEncoded());
                    }
                    token = out.toByteArray();
                }
                catch (Exception e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                finally {
                    if (inData != null) {
                        try {
                            inData.close();
                        }
                        catch (Exception e) {
                            logger.warn("Unable to close stream.");
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            logger.warn("Unable to close stream.");
                        }
                    }
                }
                this.delegationState = 0;
                this.delegationFinished = true;
                break;
            }
            default: {
                throw new GSSException(11);
            }
        }
        logger.debug("Exit initDelegation");
        if (this.gssMode != GSIConstants.MODE_SSL && token != null) {
            return this.wrap(token, 0, token.length);
        }
        return token;
    }

    public byte[] acceptDelegation(int lifetime, byte[] buf, int off, int len) throws GSSException {
        logger.debug("Enter acceptDelegation: " + this.delegationState);
        if (this.gssMode != GSIConstants.MODE_SSL && buf != null && len > 0) {
            buf = this.unwrap(buf, off, len);
            off = 0;
            len = buf.length;
        }
        byte[] token = null;
        switch (this.delegationState) {
            case 0: {
                this.delegationFinished = false;
                if (len != 1 && buf[off] != 68) {
                    throw new GlobusGSSException(11, 30, "delegError00", new Object[]{new Character((char)buf[off])});
                }
                try {
                    Certificate[] certChain;
                    try {
                        certChain = this.sslEngine.getSession().getPeerCertificates();
                    }
                    catch (SSLPeerUnverifiedException e) {
                        certChain = null;
                    }
                    if (certChain == null || certChain.length == 0) {
                        throw new GlobusGSSException(11, 30, "noClientCert");
                    }
                    X509Certificate tmpCert = (X509Certificate)certChain[0];
                    token = this.generateCertRequest(tmpCert);
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                this.delegationState = 2;
                break;
            }
            case 2: {
                ByteArrayInputStream in = null;
                X509Certificate[] chain = null;
                LinkedList<X509Certificate> certList = new LinkedList<X509Certificate>();
                X509Certificate cert = null;
                try {
                    in = new ByteArrayInputStream(buf, off, len);
                    while (in.available() > 0) {
                        cert = CertificateLoadUtil.loadCertificate(in);
                        certList.add(cert);
                    }
                    chain = new X509Certificate[certList.size()];
                    chain = certList.toArray(chain);
                    this.verifyDelegatedCert(chain[0]);
                }
                catch (GeneralSecurityException e) {
                    throw new GlobusGSSException(11, (Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            logger.warn("Unable to close streamreader.");
                        }
                    }
                }
                X509Credential proxy = new X509Credential(this.keyPair.getPrivate(), chain);
                this.delegatedCred = new GlobusGSSCredentialImpl(proxy, 0);
                this.delegationState = 0;
                this.delegationFinished = true;
                break;
            }
            default: {
                throw new GSSException(11);
            }
        }
        logger.debug("Exit acceptDelegation");
        if (this.gssMode != GSIConstants.MODE_SSL && token != null) {
            return this.wrap(token, 0, token.length);
        }
        return token;
    }

    public GSSCredential getDelegatedCredential() {
        return this.delegatedCred;
    }

    public boolean isDelegationFinished() {
        return this.delegationFinished;
    }

    public Object inquireByOid(Oid oid) throws GSSException {
        if (oid == null) {
            throw new GlobusGSSException(11, 7, "nullOption");
        }
        if (oid.equals(GSSConstants.X509_CERT_CHAIN)) {
            if (this.isEstablished()) {
                try {
                    Certificate[] peerCerts;
                    try {
                        peerCerts = this.sslEngine.getSession().getPeerCertificates();
                    }
                    catch (SSLPeerUnverifiedException e) {
                        peerCerts = null;
                    }
                    if (peerCerts != null && peerCerts.length > 0) {
                        return (X509Certificate[])peerCerts;
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new GlobusGSSException(9, (Throwable)e);
                }
            }
        } else if (oid.equals(GSSConstants.RECEIVED_LIMITED_PROXY)) {
            return this.peerLimited;
        }
        return null;
    }

    public void setBannedCiphers(String[] ciphers) {
        this.bannedCiphers = new String[ciphers.length];
        System.arraycopy(ciphers, 0, this.bannedCiphers, 0, ciphers.length);
    }

    public int getWrapSizeLimit(int qop, boolean confReq, int maxTokenSize) throws GSSException {
        throw new GSSException(16);
    }

    public void wrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void unwrap(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void getMIC(InputStream inStream, OutputStream outStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void verifyMIC(InputStream tokStream, InputStream msgStream, MessageProp msgProp) throws GSSException {
        throw new GSSException(16);
    }

    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        throw new GSSException(16);
    }

    public boolean isTransferable() throws GSSException {
        throw new GSSException(16);
    }

    public byte[] export() throws GSSException {
        throw new GSSException(16);
    }

    static {
        new ProviderLoader();
        ENABLED_PROTOCOLS = new String[]{"TLSv1", "SSLv3"};
        GRAM_PROTOCOLS = new String[]{"SSLv3"};
        NO_ENCRYPTION = new String[]{"SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_MD5"};
        GRAM_ENCRYPTION_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
        GRAM_NO_ENCRYPTION_CIPHER_SUITES = new String[]{"SSL_RSA_WITH_NULL_SHA"};
        DELEGATION_TOKEN = new byte[]{68};
    }
}

