/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.stores;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import org.apache.commons.io.FileUtils;
import org.globus.gsi.CredentialException;
import org.globus.gsi.X509Credential;
import org.globus.gsi.stores.CredentialWrapper;
import org.globus.gsi.stores.ResourceStoreException;
import org.globus.gsi.stores.SecurityObjectWrapper;
import org.globus.gsi.stores.Storable;
import org.globus.util.GlobusResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertKeyCredential
implements SecurityObjectWrapper<X509Credential>,
Storable,
CredentialWrapper {
    protected GlobusResource globusCertFile;
    protected GlobusResource globusKeyFile;
    private long certLastModified = -1L;
    private long keyLastModified = -1L;
    private X509Credential credential;
    private boolean changed;

    public CertKeyCredential(GlobusResource certResource, GlobusResource keyResource) throws ResourceStoreException {
        this.init(certResource, keyResource);
    }

    public CertKeyCredential(GlobusResource certResource, GlobusResource keyResource, X509Credential credential) throws ResourceStoreException {
        this.globusCertFile = certResource;
        try {
            if (!certResource.exists()) {
                FileUtils.touch(certResource.getFile());
                this.certLastModified = certResource.lastModified();
            }
            this.globusKeyFile = keyResource;
            if (!keyResource.exists()) {
                FileUtils.touch(keyResource.getFile());
                this.keyLastModified = keyResource.lastModified();
            }
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        this.credential = credential;
    }

    protected void init(GlobusResource initCertResource, GlobusResource initKeyResource) throws ResourceStoreException {
        if (initCertResource == null || initKeyResource == null) {
            throw new IllegalArgumentException();
        }
        this.globusCertFile = initCertResource;
        this.globusKeyFile = initKeyResource;
        this.credential = this.createObject(this.globusCertFile, this.globusKeyFile);
        try {
            this.certLastModified = this.globusCertFile.lastModified();
            this.keyLastModified = this.globusKeyFile.lastModified();
        }
        catch (IOException ioe) {
            throw new ResourceStoreException(ioe);
        }
    }

    protected void init(GlobusResource initCertFile, GlobusResource keyResource, X509Credential initCredential) throws ResourceStoreException {
        if (initCredential == null) {
            throw new IllegalArgumentException("Object cannot be null");
        }
        this.credential = initCredential;
        this.globusCertFile = initCertFile;
        this.globusKeyFile = keyResource;
    }

    @Override
    public void refresh() throws ResourceStoreException {
        long kLatestLastModified;
        long cLatestLastModified;
        this.changed = false;
        try {
            cLatestLastModified = this.globusCertFile.lastModified();
            kLatestLastModified = this.globusKeyFile.lastModified();
        }
        catch (IOException ioe) {
            throw new ResourceStoreException(ioe);
        }
        if (this.certLastModified < cLatestLastModified || this.keyLastModified < kLatestLastModified) {
            this.credential = this.createObject(this.globusCertFile, this.globusKeyFile);
            this.certLastModified = cLatestLastModified;
            this.keyLastModified = kLatestLastModified;
            this.changed = true;
        }
    }

    public GlobusResource getCertificateFile() {
        return this.globusCertFile;
    }

    public GlobusResource getKeyFile() {
        return this.globusKeyFile;
    }

    protected X509Credential createObject(GlobusResource certSource, GlobusResource keySource) throws ResourceStoreException {
        try {
            InputStream certIns = certSource.getInputStream();
            InputStream keyIns = keySource.getInputStream();
            return new X509Credential(certIns, keyIns);
        }
        catch (FileNotFoundException e) {
            throw new ResourceStoreException(e);
        }
        catch (CredentialException e) {
            throw new ResourceStoreException(e);
        }
        catch (IOException ioe) {
            throw new ResourceStoreException(ioe);
        }
    }

    @Override
    public X509Credential getSecurityObject() throws ResourceStoreException {
        this.refresh();
        return this.credential;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public X509Credential getCredential() throws ResourceStoreException {
        return this.getSecurityObject();
    }

    @Override
    public void store() throws ResourceStoreException {
        try {
            this.credential.writeToFile(this.globusCertFile.getFile(), this.globusKeyFile.getFile());
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        catch (CertificateEncodingException e) {
            throw new ResourceStoreException(e);
        }
    }

    @Override
    public String getAlias() {
        return null;
    }
}

